package com.bcxin.ins.third.gzx.huatai.util;

import com.alibaba.druid.util.StringUtils;
import com.bcxin.ins.entity.policy_special.SpecialPublicDuty;
import com.bcxin.ins.entity.product_core.ProPrimary;
import com.bcxin.ins.util.Constant;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;


/**
 * 保费计算
 * @author luopeng
 *
 */
public class PremiumCalc {
	

	
	
	//---太保---
	private BigDecimal standard = BigDecimal.valueOf(Double.parseDouble("2000"));//标准款
	Map<String,String> cpic_quotaMap = new HashMap<String,String>();
	Map<String,String> cpic_typeMap = new HashMap<String,String>();
	Map<String,String> cpic_scaleMap = new HashMap<String,String>();
	Map<String,String> cpic_periodMap = new HashMap<String,String>();
	Map<String,String> cpic_fireMap = new HashMap<String,String>();
	Map<String,String> cpic_localMap = new HashMap<String,String>();
	Map<String,String> cpic_guestMap = new HashMap<String,String>();
	Map<String,String> cpic_dangerMap = new HashMap<String,String>();
	
	//---华泰---
	private BigDecimal even = BigDecimal.valueOf(Double.parseDouble("250"));//标准款
	Map<String,String> ht_typeMap = new HashMap<String,String>();
	Map<String,String> ht_quotaMap = new HashMap<String,String>();
	Map<String,String> ht_localMap = new HashMap<String,String>();
	Map<String,String> ht_fireMap = new HashMap<String,String>();
	Map<String,String> ht_scaleMap = new HashMap<String,String>();
	Map<String,String> ht_dangerMap = new HashMap<String,String>();

	
	private void load_cpic_data(){
		cpic_quotaMap.put(Policy_ActivityQuota.CPIC_LEVEL_ONE.getValue(), "1.1");
		cpic_quotaMap.put(Policy_ActivityQuota.CPIC_LEVEL_TWO.getValue(), "1.2");
		cpic_quotaMap.put(Policy_ActivityQuota.CPIC_LEVEL_THREE.getValue(), "1.3");
		cpic_quotaMap.put(Policy_ActivityQuota.CPIC_LEVEL_FOUR.getValue(), "1.4");
		cpic_quotaMap.put(Policy_ActivityQuota.CPIC_LEVEL_FIVE.getValue(), "1.5");
		cpic_quotaMap.put(Policy_ActivityQuota.CPIC_LEVEL_SIX.getValue(), "1.6");
		
		cpic_typeMap.put(Policy_ActivityType.EXHIBITION.getValue(), "1");
		cpic_typeMap.put(Policy_ActivityType.LITERATURE.getValue(), "1.2");
		cpic_typeMap.put(Policy_ActivityType.SPORTS.getValue(), "1.3");
		cpic_typeMap.put(Policy_ActivityType.GARDENLANTERN.getValue(), "1.4");
		cpic_typeMap.put(Policy_ActivityType.OTHER.getValue(), "1.2");
		
		cpic_scaleMap.put(Policy_ActivityScale.CPIC_BELOW.getValue(), "1");
		cpic_scaleMap.put(Policy_ActivityScale.CPIC_MIDDLE.getValue(), "1.2");
		cpic_scaleMap.put(Policy_ActivityScale.CPIC_UP.getValue(), "1.4");
		
		cpic_periodMap.put(Policy_ActivityPeriod.BELOW.getValue(), "1");
		cpic_periodMap.put(Policy_ActivityPeriod.MIDDLE.getValue(), "1.2");
		cpic_periodMap.put(Policy_ActivityPeriod.UP.getValue(), "1.3");
		
		cpic_fireMap.put(Policy_ActivityFireFight.ACCEPTANCE.getValue(), "1");
		cpic_fireMap.put(Policy_ActivityFireFight.EXTINGUISHER.getValue(), "1.1");
		cpic_fireMap.put(Policy_ActivityFireFight.NO_EXTINGUISHER.getValue(), "1.3");
		
		cpic_localMap.put(Policy_ActivityLocal.INDOOR.getValue(), "1");
		cpic_localMap.put(Policy_ActivityLocal.OPEN.getValue(), "1.1");
		cpic_localMap.put(Policy_ActivityLocal.OUTDOOR.getValue(), "1.2");
		
		cpic_guestMap.put(Whether.HAVE.getValue(), "1");
		cpic_guestMap.put(Whether.WITHOUT.getValue(), "1.1");
		
		cpic_dangerMap.put(Whether.HAVE.getValue(), "1");
		cpic_dangerMap.put(Whether.WITHOUT.getValue(), "1.2");
	}
	
	private void load_ht_data(){
		//基本保费
		ht_typeMap.put(Policy_ActivityType.EXHIBITION.getValue(), "2000");
		ht_typeMap.put(Policy_ActivityType.LITERATURE.getValue(), "2500");
		ht_typeMap.put(Policy_ActivityType.SPORTS.getValue(), "3500");
		ht_typeMap.put(Policy_ActivityType.GARDENLANTERN.getValue(), "4000");
		ht_typeMap.put(Policy_ActivityType.OTHER.getValue(), "4000");
		//保险累计赔偿限额
		ht_quotaMap.put("1", "1.1");
		ht_quotaMap.put("2", "1.4");
		ht_quotaMap.put("3", "1.5");
		ht_quotaMap.put("4", "1.6");
		//活动地点
		ht_localMap.put(Policy_ActivityLocal.INDOOR.getValue(), "1");
		ht_localMap.put(Policy_ActivityLocal.OPEN.getValue(), "1.1");
		ht_localMap.put(Policy_ActivityLocal.OUTDOOR.getValue(), "1.2");
		//有无危险环节
		ht_fireMap.put(Policy_ActivityFireFight.ACCEPTANCE.getValue(), "1");
		ht_fireMap.put(Policy_ActivityFireFight.EXTINGUISHER.getValue(), "1.1");
		//活动人数
		ht_scaleMap.put(Policy_ActivityScale.HT_BELOW.getValue(), "1");
		ht_scaleMap.put(Policy_ActivityScale.HT_MIDDLE.getValue(), "1.2");
		ht_scaleMap.put(Policy_ActivityScale.HT_SE_MIDDLE.getValue(), "1.5");
		ht_scaleMap.put(Policy_ActivityScale.HT_UP.getValue(), "2");
		//有无危险环节（如烟花）
		ht_dangerMap.put(Whether.WITHOUT.getValue(), "1");
		ht_dangerMap.put(Whether.HAVE.getValue(), "1.3");
	}

	public  String  getQuota(String amount){
        if(org.apache.commons.lang.StringUtils.isNotEmpty(amount)){
			double  num = Double.parseDouble(amount);
			if( num<1000){
               return  "1";
			}else if(num<1500){
				return  "2";
			}else if(num<2000){
				return  "3";
			}else{
				return  "4";
			}

		}

		return "1";
	}

	public BigDecimal calc(ProPrimary product, SpecialPublicDuty extra,String companyType) {
		
		if (companyType.equals(Constant.INS_CODE_PICC)) { //太保
			load_cpic_data();
			BigDecimal premium = standard;
			
			String quota = cpic_quotaMap.get(extra.getActivity_quota());//限额
			String type = cpic_typeMap.get(extra.getActivity_type());//类型
			String scale = cpic_scaleMap.get(extra.getActivity_scale());//规模
			String period = cpic_periodMap.get(extra.getActivity_period());
			String fire = cpic_fireMap.get(extra.getActivity_fire_fight());//有无危险
			String local = cpic_localMap.get(extra.getActivity_local());//活动地点
			String guest = cpic_guestMap.get(extra.getGuest());//来宾
			String danger = cpic_dangerMap.get(extra.getDanger());//有无危险
			
			if ( StringUtils.isEmpty(quota) ) {
				quota = "1.1";
			}
			if ( StringUtils.isEmpty(type) ) {
				type = "1";
			}
			if ( StringUtils.isEmpty(scale) ) {
				scale = "1";
			}
			if (  StringUtils.isEmpty(period)) {
				period = "1";
			}
			if ( StringUtils.isEmpty(fire) ) {
				fire = "1";
			}
			if (  StringUtils.isEmpty(local)  ) {
				local = "1";
			}
			if ( StringUtils.isEmpty(guest)  ) {
				guest  = "1";
			}
			if ( StringUtils.isEmpty(danger) ) {
				danger = "1";
			}
			premium = premium.multiply(BigDecimal.valueOf(Double.parseDouble(quota))).multiply(BigDecimal.valueOf(Double.parseDouble(type)))
					.multiply(BigDecimal.valueOf(Double.parseDouble(scale))).multiply(BigDecimal.valueOf(Double.parseDouble(period)))
					.multiply(BigDecimal.valueOf(Double.parseDouble(fire))).multiply(BigDecimal.valueOf(Double.parseDouble(local)))
					.multiply(BigDecimal.valueOf(Double.parseDouble(guest))).multiply(BigDecimal.valueOf(Double.parseDouble(danger)));
			
			return premium.setScale(2,BigDecimal.ROUND_HALF_UP);
			
		} else if ( companyType.equals(Constant.INS_CODE_HT) ) { //华泰
			load_ht_data();
			BigDecimal premium = even;
			String quota="1";
			quota= ht_quotaMap.get(getQuota(extra.getAmount()));//限额

			String type = ht_typeMap.get(extra.getActivity_type());//类型

			Policy_ActivityScale   policyScale= Policy_ActivityScale.calc(extra.getPeople_num(),Constant.INS_CODE_HT);
			String scale = ht_scaleMap.get(policyScale.getValue());//规模

			Policy_ActivityFireFight policyFile= Policy_ActivityFireFight.valueOf(extra.getActivity_fire_fight());
			String fire = ht_fireMap.get(policyFile.getValue());//

			Policy_ActivityLocal   policyLocal= Policy_ActivityLocal.valueOf(extra.getActivity_local());
			String local = ht_localMap.get(policyLocal.getValue());//室内

			Whether whether = Whether.valueOf(extra.getDanger());
			String danger = ht_dangerMap.get(whether.getValue());//有无危险
			String days ="1";
			if(extra.getInsure_days()!=null){
				days=Integer.parseInt(extra.getInsure_days())+1+"";
			}

			
			if ( StringUtils.isEmpty(quota) ) {
				quota = "1";
			}
			if ( StringUtils.isEmpty(type) ) {
				type = "2000";
			}
			if ( StringUtils.isEmpty(scale) ) {
				scale = "1";
			}
			if ( StringUtils.isEmpty(fire) ) {
				fire = "1";
			}
			if (  StringUtils.isEmpty(local)  ) {
				local = "1";
			}
			if ( StringUtils.isEmpty(danger) ) {
				danger = "1";
			}
			if ( StringUtils.isEmpty(days)){
				days = "1";
			}
			BigDecimal dayprice = premium.multiply(BigDecimal.valueOf(Double.parseDouble(days)));
			premium = BigDecimal.valueOf(Double.parseDouble(quota)).multiply(BigDecimal.valueOf(Double.parseDouble(type)))
					.multiply(BigDecimal.valueOf(Double.parseDouble(scale))).multiply(BigDecimal.valueOf(Double.parseDouble(danger)))
					.multiply(BigDecimal.valueOf(Double.parseDouble(fire))).multiply(BigDecimal.valueOf(Double.parseDouble(local)));
			
			premium = premium.add(dayprice);
			return premium.setScale(2,BigDecimal.ROUND_HALF_UP);
		}
		
		return BigDecimal.ZERO;
	}

	/**
	 * <b> 华泰根据条件计算保费 </b>
	 * @param amount 限额
	 * @param activity_type 活动类型
	 * @param people_num 总人数
	 * @param activity_local 场地
	 * @param isdanger 有无危险
	 * @param activity_fire_fight 消防
	 * @param insure_days 活动天数
	 * @author ZXF
	 * @create 2018/08/14 0014 11:12
	 * @version
	 * @注意事项 </b>
	 */
	public BigDecimal calcHT(String amount, String activity_type, String people_num, String activity_local, String isdanger, String activity_fire_fight,String insure_days) {

		load_ht_data();
		BigDecimal premium = even;
		String quota="1";
		quota= ht_quotaMap.get(getQuota(amount));//限额

		String type = ht_typeMap.get(activity_type);//类型

		Policy_ActivityScale   policyScale= Policy_ActivityScale.calc(people_num,Constant.INS_CODE_HT);
		String scale = ht_scaleMap.get(policyScale.getValue());//规模

		Policy_ActivityFireFight policyFile= Policy_ActivityFireFight.valueOf(activity_fire_fight);
		String fire = ht_fireMap.get(policyFile.getValue());//

		Policy_ActivityLocal   policyLocal= Policy_ActivityLocal.valueOf(activity_local);
		String local = ht_localMap.get(policyLocal.getValue());//室内

		Whether whether = Whether.valueOf(isdanger);
		String danger = ht_dangerMap.get(whether.getValue());//有无危险
		String days ="1";
		if(com.bcxin.mybatisplus.toolkit.StringUtils.isNotEmpty(insure_days)){
			days=Integer.parseInt(insure_days)+1+"";
		}


		if ( StringUtils.isEmpty(quota) ) {
			quota = "1";
		}
		if ( StringUtils.isEmpty(type) ) {
			type = "2000";
		}
		if ( StringUtils.isEmpty(scale) ) {
			scale = "1";
		}
		if ( StringUtils.isEmpty(fire) ) {
			fire = "1";
		}
		if (  StringUtils.isEmpty(local)  ) {
			local = "1";
		}
		if ( StringUtils.isEmpty(danger) ) {
			danger = "1";
		}
		if ( StringUtils.isEmpty(days)){
			days = "1";
		}
		BigDecimal dayprice = premium.multiply(BigDecimal.valueOf(Double.parseDouble(days)));
		premium = BigDecimal.valueOf(Double.parseDouble(quota)).multiply(BigDecimal.valueOf(Double.parseDouble(type)))
				.multiply(BigDecimal.valueOf(Double.parseDouble(scale))).multiply(BigDecimal.valueOf(Double.parseDouble(danger)))
				.multiply(BigDecimal.valueOf(Double.parseDouble(fire))).multiply(BigDecimal.valueOf(Double.parseDouble(local)));

		premium = premium.add(dayprice);
		return premium.setScale(2,BigDecimal.ROUND_HALF_UP);
	}
}
