package com.bcxin.ins.third.gzx.huatai.util;

import com.bcxin.ins.util.Constant;
import org.apache.commons.lang.StringUtils;

import java.util.HashMap;
import java.util.Map;


public enum Policy_ActivityQuotaC {

	
	HT_LEVEL_ONE {public String getValue(){return "11";} public String getName(){return "人民币500万≤累计赔偿限额＜人民币1000万";}},
	
	HT_LEVEL_TWO {public String getValue(){return "12";} public String getName(){return "人民币1000万≤累计赔偿限额＜人民币1500万";} },
	
	HT_LEVEL_THREE {public String getValue(){return "13";} public String getName(){return "人民币1500万≤累计赔偿限额＜人民币2000万";} },
	
	HT_LEVEL_FOUR {public String getValue(){return "14";} public String getName(){return "人民币2000万≤累计赔偿限额人民币＜3500万";} };
	
	
    public abstract String getValue();
    
    public abstract String getName();
    
    public static Policy_ActivityQuotaC calc(String number, String  code){
    	int num = Integer.parseInt(number);
    	if ( Constant.INS_CODE_HT.equals(code) ) {
    		if (num<=  5000  ) {
        		return HT_LEVEL_ONE;
        	} else if ( 5000 < num && num <= 10000 ) {
        		return HT_LEVEL_TWO;
        	} else if( 10000 < num && num <= 50000 ) {
        		return HT_LEVEL_THREE;
        	} else if( 50000 < num ) {
        		return HT_LEVEL_FOUR;
        	}
    	}
    	return null;
    }
    
    
    public  static Policy_ActivityQuotaC getLevel(String number){
		if(StringUtils.isEmpty(number)){
			return HT_LEVEL_ONE;
		}
    	int num = Integer.parseInt(number);
    	if (num<=  5000  ) {
    		return HT_LEVEL_ONE;
    	} else if ( num <= 10000 ) {
    		return HT_LEVEL_TWO;
    	} else if( num <= 50000 ) {
    		return HT_LEVEL_THREE;
    	} else  {
    		return HT_LEVEL_FOUR;
    	}

    }
    
    public static Map<String,String> calcLimit(Policy_ActivityQuotaC quota){
    	Map<String,String> map = new HashMap<String,String>();
    	if ( HT_LEVEL_ONE.equals(quota) ) {
    		map.put("minLimit", "500");
    		map.put("maxLimit", "1000");
    	} else if ( HT_LEVEL_TWO.equals(quota) ) {
    		map.put("minLimit", "1000");
    		map.put("maxLimit", "1500");
    	} else if ( HT_LEVEL_THREE.equals(quota) ) {
    		map.put("minLimit", "1500");
    		map.put("maxLimit", "2000");
    	} else if ( HT_LEVEL_FOUR.equals(quota) ) {
    		map.put("minLimit", "2000");
    		map.put("maxLimit", "3500");
    	} 
    	return map;
    }
    
    
}
