package com.bcxin.ins.third.gzx.huatai.util;

import java.util.ArrayList;
import java.util.List;


public enum ActivityType {
	
	/** 	体育比赛活动*/
	SPORT {public String getValue(){return "1";} public String getName(){return "体育比赛活动";}}, 
	/** 	文艺演出活动*/
	LITERATURE{public String getValue(){return "2";} public String getName(){return "文艺演出活动";}},
	/** 	展览展销等活动*/
    EXHIBITION{public String getValue(){return "3";} public String getName(){return "展览展销等活动";}},
    
    GARDENLANTERN{public String getValue(){return "4";} public String getName(){return "游园灯会活动";}},
    
    RECRUIT{public String getValue(){return "5";} public String getName(){return "招聘会活动";}},
    
    CHARITY{public String getValue(){return "6";} public String getName(){return "公益慈善活动";}},
    
    OTHER{public String getValue(){return "7";} public String getName(){return "其他";}};
    
    public abstract String getValue();
    
    public abstract String getName();
    
    
    public static ActivityType convertStringName(String stringName){
    	if ( "SPORT".equals(stringName) ) {
    		return ActivityType.SPORT;
    	} else if ("LITERATURE".equals(stringName)) {
    		return ActivityType.LITERATURE;
    	} else if ("EXHIBITION".equals(stringName)) {
    		return ActivityType.EXHIBITION;
    	} else if ("GARDENLANTERN".equals(stringName)) {
    		return ActivityType.GARDENLANTERN;
    	} else if ("RECRUIT".equals(stringName)) {
    		return ActivityType.RECRUIT;
    	} else if ("CHARITY".equals(stringName)) {
    		return ActivityType.CHARITY;
    	} else if ("OTHER".equals(stringName)) {
    		return ActivityType.OTHER;
    	}
    	return LITERATURE;
    }
    
    public static ActivityType convertName(String name){
    	if ( "体育比赛活动".equals(name) ) {
    		return ActivityType.SPORT;
    	} else if ("文艺演出活动".equals(name)) {
    		return ActivityType.LITERATURE;
    	} else if ("展览展销等活动".equals(name)) {
    		return ActivityType.EXHIBITION;
    	} else if ("游园灯会活动".equals(name)) {
    		return ActivityType.GARDENLANTERN;
    	} else if ("招聘会活动".equals(name)) {
    		return ActivityType.RECRUIT;
    	} else if ("公益慈善活动".equals(name)) {
    		return ActivityType.CHARITY;
    	} else if ("其他".equals(name)) {
    		return ActivityType.OTHER;
    	}
    	return LITERATURE;
    }
    
    public static ActivityType convert_value(String value){
    	if ( "1".equals(value) ) {
    		return ActivityType.SPORT;
    	} else if ("2".equals(value)) {
    		return ActivityType.LITERATURE;
    	} else if ("3".equals(value)) {
    		return ActivityType.EXHIBITION;
    	}else if ("4".equals(value)) {
    		return ActivityType.GARDENLANTERN;
    	}else if ("5".equals(value)) {
    		return ActivityType.RECRUIT;
    	}else if ("6".equals(value)) {
    		return ActivityType.CHARITY;
    	}else if ("7".equals(value)) {
    		return ActivityType.OTHER;
    	}
    	return null;
    }
    
    public static List<ActivityType> validList(){
    	List<ActivityType> types = new ArrayList<ActivityType>();
    	types.add(LITERATURE);
    	types.add(EXHIBITION);
    	types.add(SPORT);
    	types.add(GARDENLANTERN);
    	types.add(RECRUIT);
    	types.add(CHARITY);
    	types.add(OTHER);
    	return types;
    }

	public static List<ActivityType> otherList(){
		List<ActivityType> types = new ArrayList<ActivityType>();
		types.add(GARDENLANTERN);
		types.add(RECRUIT);
		types.add(CHARITY);
		types.add(OTHER);
		return types;
	}

	public static List<ActivityType> mainList(){
		List<ActivityType> types = new ArrayList<ActivityType>();
		types.add(LITERATURE);
		types.add(EXHIBITION);
		types.add(SPORT);
		return types;
	}

    public static String processCorrectTemplate(ActivityType act){
		String activityCode = "";
    	if ( LITERATURE.equals(act) || CHARITY.equals(act)) {
    		return "LITERATURE";
		} else if ( EXHIBITION.equals(act) || GARDENLANTERN.equals(act) || RECRUIT.equals(act) || OTHER.equals(act)){
			return "EXHIBITION";
		} else if ( SPORT.equals(act)){
			return "SPORT";
		}
    	return activityCode;
	}
    
}
