package com.bcxin.ins.third.build.yangguang.yggc;

import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.SpecialBidVo;
import com.google.common.collect.Lists;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

/**
 * 保单信息 ---> 保障责任信息
 * Created by Apple on 2017/7/19.
 */
public class PolicyRisk {
    private String itemName; //责任名称
    private String mult;  //份数
    private String premium; //保险费
    private String riskCode; //险种代码
    private String amtFlag; //是否计入总保额，Y和N
    private String kindCode; //条款代码
    private String insuredNumber; //被保人数量
    private String amount; //保险金额
    private String serialNo; //序号
    private String kindName; //条款名称
    private String mainRiskFlag; //主附险标志,1-主险;2-附加险
    private String itemCode; //责任代码
    private String benchMarkRate; //基准费率
    private String familyNo; //分户序号
    private String deductible; //免赔率

    public static List<PolicyRisk> getDemo(OrderFormVo dto, SpecialBidVo vo){
        List<PolicyRisk>  l  =  Lists.newArrayList();
        l.add(new PolicyRisk(dto,vo));
        return l;
    }
    public static List<PolicyRisk> getDemo(){
        List<PolicyRisk>  l  =  Lists.newArrayList();
        l.add(new PolicyRisk("demo"));
        return l;
    }
    public PolicyRisk(){}
    private PolicyRisk(OrderFormVo dto,SpecialBidVo vo) {
        this.itemName = "投标保证";
        this.mult = "1";
        this.premium =dto.getGross_premium();
        this.riskCode = "2213";
        this.amtFlag = "Y";
        this.kindCode = "002";
        this.insuredNumber = "1";
        this.amount =  vo.getInsured_amount();
        this.serialNo = "1";
        this.kindName = "建设工程施工合同履约保证保险条款（2015版）";
        this.mainRiskFlag = "1";
        this.itemCode = "0001";
        this.benchMarkRate =  (new BigDecimal(dto.getGross_premium())).multiply(new BigDecimal("1000")).divide(new BigDecimal(vo.getInsured_amount()),2, RoundingMode.HALF_UP).toString();
        this.familyNo = "1";
//        this.deductible = "500";
    }
    private PolicyRisk(String demo) {
        this.itemName = "投标保证";
        this.mult = "1";
        this.premium = "200";
        this.riskCode = "2213";
        this.amtFlag = "Y";
        this.kindCode = "002";
        this.insuredNumber = "1";
        this.amount = "100000";
        this.serialNo = "1";
        this.kindName = "建设工程施工合同履约保证保险条款（2015版）";
        this.mainRiskFlag = "1";
        this.itemCode = "0001";
        this.benchMarkRate = "2";
        this.familyNo = "1";
//        this.deductible = "500";
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getMult() {
        return mult;
    }

    public void setMult(String mult) {
        this.mult = mult;
    }

    public String getPremium() {
        return premium;
    }

    public void setPremium(String premium) {
        this.premium = premium;
    }

    public String getRiskCode() {
        return riskCode;
    }

    public void setRiskCode(String riskCode) {
        this.riskCode = riskCode;
    }

    public String getAmtFlag() {
        return amtFlag;
    }

    public void setAmtFlag(String amtFlag) {
        this.amtFlag = amtFlag;
    }

    public String getKindCode() {
        return kindCode;
    }

    public void setKindCode(String kindCode) {
        this.kindCode = kindCode;
    }

    public String getInsuredNumber() {
        return insuredNumber;
    }

    public void setInsuredNumber(String insuredNumber) {
        this.insuredNumber = insuredNumber;
    }

    public String getAmount() {
        return amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public String getSerialNo() {
        return serialNo;
    }

    public void setSerialNo(String serialNo) {
        this.serialNo = serialNo;
    }

    public String getKindName() {
        return kindName;
    }

    public void setKindName(String kindName) {
        this.kindName = kindName;
    }

    public String getMainRiskFlag() {
        return mainRiskFlag;
    }

    public void setMainRiskFlag(String mainRiskFlag) {
        this.mainRiskFlag = mainRiskFlag;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public String getBenchMarkRate() {
        return benchMarkRate;
    }

    public void setBenchMarkRate(String benchMarkRate) {
        this.benchMarkRate = benchMarkRate;
    }

    public String getFamilyNo() {
        return familyNo;
    }

    public void setFamilyNo(String familyNo) {
        this.familyNo = familyNo;
    }

    public String getDeductible() {
        return deductible;
    }

    public void setDeductible(String deductible) {
        this.deductible = deductible;
    }
}
