package com.bcxin.ins.third.build.yangguang.yggc;

import com.bcxin.ins.third.build.yangguang.util.MakeUp;
import com.bcxin.ins.util.RegionUtils;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.SpecialBidVo;
import com.bcxin.mybatisplus.toolkit.StringUtils;

/**
 * 保单信息 ----> 被保险人信息
 * Created by Apple on 2017/7/19.
 */
public class PolicyInsuranceSchema {


    private String mult; // 份数
    private String insuredemail; // 被保联系人email
    private String insuredName; // 被保险单位名称
    private String inputOperator; // 填单人
    private String appliType; // 保单客户类型（1个人/2团体）
    private String isDIY; // Y/N,Y代表是diy产品
    private String premiumFormulaMode; // 额&保费计算方式
    private String insurDate; // 投保日期
    private String holderMobile; // 投保联系人手机号
    private String insuredNumber; // 被保人数量
    private String insuredIdNo; // 被保险单位证件号码
    private String amount; // 保险金额
    private String insuYearFlag; // 保险期间单位：单位为年或月或日Y,M,D
    private String benefMode; // 受益模式：1为法定，2为指定
    private String mainRiskCode; // 主险种
    private String holderAddress;  // 投保人地址
    private String frameNo; // 投保人联系人姓名
    private String licenseNo; // 投保人联系邮编
    private String insuredgrantCountry; // 联系人姓名
    private String insuredzip; // 联系邮编
    private String propertyZip; // 联系邮编
    private String insuredAddress; // 被保险人地址
    private String propertyAddress; // 被保险人地址
    private String insuredmobile; // 被保联系人手机号
    private String inputDate; // 填单日期
    private String operateType; // 操作类型
    private String isSettled; // 对账标识：1为已对帐，否则为空
    private String status; // 转数状态，00-初始值；01-生成保单成功；02-生成保单失败,默认为00
    private String premium; // 保险费
    private String holderName; // 投保单位
    private String discount; // 折扣比例,保留4位有效数字
    private String insuredidType; // 被保险单位证件类型
    private String holderidType; // 证件类型
    private String importSN; // 导入批次号 ，这个我们自己定义50个字符内，0-9a-zA-Z  //TODO 阳光工程 每次投保唯一
    private String groupRiskFlag; // 团、个险标志,0-团险为;1-个险
    private String holderIdNo; // 证件号码
    private String transMode; // 转数模式,1-接口平台,2-生成保单
    private String printNo; // 预印单证号
    private String polFlag; // 保单有效标志，0：正常保单，1：作废保单
    private String insurStartDate; // 保险起期
    private String holderemail; // 投保联系人email
    private String certifyCode; // 产品代码
    private String cardUwTime; // 城市代码
    private String custNumber; // 受益人数量
    private String insurEndDate; // 保险止期
    private String insurPeriod; // 保险期限
    private String taxPayerType; // 纳税人识别号,1小规模纳税人，2一般纳税人
    private String revenueBank; // 税务登记开户行
    private String revenueAccount; // 税务登记开户行账号
    private String revenueAddress; // 税务登记公司地址
    private String revenuePhoneNumber; // 税务登记公司电话
    private String visaCode;  //传真号
    public static PolicyInsuranceSchema getDemo(){
        return new PolicyInsuranceSchema("demo");
    }
    public static PolicyInsuranceSchema getDemo(OrderFormVo dto, SpecialBidVo vo){
        return new PolicyInsuranceSchema(dto,vo);
    }
    public PolicyInsuranceSchema() {}
    private PolicyInsuranceSchema(String demo) {
        this.mult = "1";
        this.insuredemail = "lei.qi1@pactera.com";
        this.insuredName = "林华";
        this.inputOperator = "";
        this.appliType = "2";
        this.isDIY = "Y";
        this.premiumFormulaMode = "0";
        this.insurDate = "2017-01-12 10:33:03";
        this.holderMobile = "13241312312";
        this.insuredNumber = "1";
        this.insuredIdNo = "512501197506045175";
        this.amount = "100000";
        this.cardUwTime = "350200";
        this.insuYearFlag = "Y";
        this.benefMode = "1";
        this.mainRiskCode = "2213";
        this.holderAddress = "北京北京市延庆县";
        this.frameNo = "李世民";
        this.licenseNo = "111111";
        this.insuredgrantCountry = "长孙无忌";
        this.insuredzip = "000002";
        this.propertyZip = "000002";
        this.insuredAddress = "北京北京市延庆县....";
        this.propertyAddress = "北京北京市延庆县....";
        this.insuredmobile = "13241312312";
        this.inputDate = "2017-01-12 10:33:03";
        this.operateType = "input_pay";
        this.isSettled = "1";
        this.status = "00";
        this.premium = "200";
        this.holderName = "天民";
        this.discount = "100";
        this.insuredidType = "1";
        this.holderidType = "1";
//        this.importSN = "BXBHW01219033036191";
        this.importSN = MakeUp.makeUpImportSN();
        this.groupRiskFlag = "0";
        this.holderIdNo = "370203390214161";
        this.transMode = "2";
        this.printNo = "";
        this.polFlag = "0";
        this.insurStartDate = "2017-01-13 00:00:00";
        this.holderemail = "lei.qi1@pactera.com";
        this.certifyCode = "2213";
        this.custNumber = "1";
        this.insurEndDate = "2017-08-12 23:59:59";
        this.insurPeriod = "1";
        this.taxPayerType = "1";
        this.revenueBank = "365";
        this.revenueAccount = "365";
        this.revenueAddress = "365";
        this.revenuePhoneNumber = "365";
        this.visaCode="0592-1234567";
    }
    private PolicyInsuranceSchema(OrderFormVo dto, SpecialBidVo vo) {
        this.mult = "1";
        this.insuredemail = "";
        this.insuredName = vo.getRoleSubjectList().get(1).getName_cn();
        this.inputOperator = "";
        this.appliType = "2";
        this.isDIY = "Y";
        this.premiumFormulaMode = "0";
        this.insurDate =dto.getInception_date();
        this.holderMobile = vo.getRoleSubjectList().get(0).getPhone();
        this.insuredNumber = "1";
        this.insuredIdNo = vo.getRoleSubjectList().get(1).getOrganization_code();
        this.amount = vo.getInsured_amount();
        this.cardUwTime = vo.getCity();
        this.insuYearFlag = "Y";
        this.benefMode = "1";
        this.mainRiskCode = "2213";
        this.holderAddress = RegionUtils.getRegionNameByALLCode(vo.getRoleSubjectList().get(0).getReg_province(),
                vo.getRoleSubjectList().get(0).getReg_city(),vo.getRoleSubjectList().get(0).getReg_district())+
                vo.getRoleSubjectList().get(0).getReg_address();
        this.frameNo = vo.getRoleSubjectList().get(0).getLink_name();
        this.licenseNo = vo.getRoleSubjectList().get(0).getZip_code();
        this.insuredgrantCountry = vo.getRoleSubjectList().get(1).getLink_name();
        this.insuredzip = vo.getRoleSubjectList().get(1).getZip_code();
        this.propertyZip = vo.getRoleSubjectList().get(1).getZip_code();
        this.insuredAddress = RegionUtils.getRegionNameByALLCode(vo.getRoleSubjectList().get(1).getReg_province(),
                vo.getRoleSubjectList().get(1).getReg_city(),vo.getRoleSubjectList().get(1).getReg_district())+
                vo.getRoleSubjectList().get(1).getReg_address();
        this.propertyAddress = RegionUtils.getRegionNameByALLCode(vo.getRoleSubjectList().get(1).getReg_province(),
                vo.getRoleSubjectList().get(1).getReg_city(),vo.getRoleSubjectList().get(1).getReg_district())+
                vo.getRoleSubjectList().get(1).getReg_address();
        this.insuredmobile = vo.getRoleSubjectList().get(1).getPhone();
        this.inputDate = dto.getStart_time();
        this.operateType = "input_pay";
        this.isSettled = "1";
        this.status = "00";
        this.premium = dto.getGross_premium();
        this.holderName = vo.getRoleSubjectList().get(0).getName_cn();
        this.discount = "100";
        this.insuredidType = "08";//被保人证件类型vo.getRoleSubjectList().get(1).getId_type()
        this.holderidType = "08";//投保人证件类型
//        this.importSN = "BXBHW01219033036191";
        this.importSN = MakeUp.makeUpImportSN();
        this.groupRiskFlag = "0";
        this.holderIdNo =vo.getRoleSubjectList().get(0).getOrganization_code();
        this.transMode = "2";
        this.printNo = "";
        this.polFlag = "0";
        this.insurStartDate =vo.getInception_date();
        this.holderemail = vo.getRoleSubjectList().get(0).getEmail();
        this.certifyCode = "2213";
        this.custNumber = "1";
        this.insurEndDate = vo.getPlanned_end_date();
        this.insurPeriod = "1";
        this.taxPayerType = "1";
        this.revenueBank = "365";
        this.revenueAccount = "365";
        this.revenueAddress = "365";
        this.revenuePhoneNumber = "365";
        this.visaCode=buildPhone(vo.getRoleSubjectList().get(0).getPhone());
    }

    private String buildPhone(String p){
        if(StringUtils.isNotEmpty(p)){
            if(p.contains("-")){
                return p.split("-")[0]+p.split("-")[1];
            }
        }
        return p;
    }

    public String getMult() {
        return mult;
    }

    public void setMult(String mult) {
        this.mult = mult;
    }

    public String getInsuredemail() {
        return insuredemail;
    }

    public void setInsuredemail(String insuredemail) {
        this.insuredemail = insuredemail;
    }

    public String getInsuredName() {
        return insuredName;
    }

    public void setInsuredName(String insuredName) {
        this.insuredName = insuredName;
    }

    public String getInputOperator() {
        return inputOperator;
    }

    public void setInputOperator(String inputOperator) {
        this.inputOperator = inputOperator;
    }

    public String getAppliType() {
        return appliType;
    }

    public void setAppliType(String appliType) {
        this.appliType = appliType;
    }

    public String getIsDIY() {
        return isDIY;
    }

    public void setIsDIY(String isDIY) {
        this.isDIY = isDIY;
    }

    public String getPremiumFormulaMode() {
        return premiumFormulaMode;
    }

    public void setPremiumFormulaMode(String premiumFormulaMode) {
        this.premiumFormulaMode = premiumFormulaMode;
    }

    public String getInsurDate() {
        return insurDate;
    }

    public void setInsurDate(String insurDate) {
        this.insurDate = insurDate;
    }

    public String getHolderMobile() {
        return holderMobile;
    }

    public void setHolderMobile(String holderMobile) {
        this.holderMobile = holderMobile;
    }

    public String getInsuredNumber() {
        return insuredNumber;
    }

    public void setInsuredNumber(String insuredNumber) {
        this.insuredNumber = insuredNumber;
    }

    public String getInsuredIdNo() {
        return insuredIdNo;
    }

    public void setInsuredIdNo(String insuredIdNo) {
        this.insuredIdNo = insuredIdNo;
    }

    public String getAmount() {
        return amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public String getInsuYearFlag() {
        return insuYearFlag;
    }

    public void setInsuYearFlag(String insuYearFlag) {
        this.insuYearFlag = insuYearFlag;
    }

    public String getBenefMode() {
        return benefMode;
    }

    public void setBenefMode(String benefMode) {
        this.benefMode = benefMode;
    }

    public String getMainRiskCode() {
        return mainRiskCode;
    }

    public void setMainRiskCode(String mainRiskCode) {
        this.mainRiskCode = mainRiskCode;
    }

    public String getHolderAddress() {
        return holderAddress;
    }

    public void setHolderAddress(String holderAddress) {
        this.holderAddress = holderAddress;
    }

    public String getFrameNo() {
        return frameNo;
    }

    public void setFrameNo(String frameNo) {
        this.frameNo = frameNo;
    }

    public String getLicenseNo() {
        return licenseNo;
    }

    public void setLicenseNo(String licenseNo) {
        this.licenseNo = licenseNo;
    }

    public String getInsuredgrantCountry() {
        return insuredgrantCountry;
    }

    public void setInsuredgrantCountry(String insuredgrantCountry) {
        this.insuredgrantCountry = insuredgrantCountry;
    }

    public String getInsuredzip() {
        return insuredzip;
    }

    public void setInsuredzip(String insuredzip) {
        this.insuredzip = insuredzip;
    }

    public String getInsuredAddress() {
        return insuredAddress;
    }

    public void setInsuredAddress(String insuredAddress) {
        this.insuredAddress = insuredAddress;
    }

    public String getInsuredmobile() {
        return insuredmobile;
    }

    public void setInsuredmobile(String insuredmobile) {
        this.insuredmobile = insuredmobile;
    }

    public String getInputDate() {
        return inputDate;
    }

    public void setInputDate(String inputDate) {
        this.inputDate = inputDate;
    }

    public String getOperateType() {
        return operateType;
    }

    public void setOperateType(String operateType) {
        this.operateType = operateType;
    }

    public String getIsSettled() {
        return isSettled;
    }

    public void setIsSettled(String isSettled) {
        this.isSettled = isSettled;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getPremium() {
        return premium;
    }

    public void setPremium(String premium) {
        this.premium = premium;
    }

    public String getHolderName() {
        return holderName;
    }

    public void setHolderName(String holderName) {
        this.holderName = holderName;
    }

    public String getDiscount() {
        return discount;
    }

    public void setDiscount(String discount) {
        this.discount = discount;
    }

    public String getInsuredidType() {
        return insuredidType;
    }

    public void setInsuredidType(String insuredidType) {
        this.insuredidType = insuredidType;
    }

    public String getHolderidType() {
        return holderidType;
    }

    public void setHolderidType(String holderidType) {
        this.holderidType = holderidType;
    }

    public String getImportSN() {
        return importSN;
    }

    public void setImportSN(String importSN) {
        this.importSN = importSN;
    }

    public String getGroupRiskFlag() {
        return groupRiskFlag;
    }

    public void setGroupRiskFlag(String groupRiskFlag) {
        this.groupRiskFlag = groupRiskFlag;
    }

    public String getHolderIdNo() {
        return holderIdNo;
    }

    public void setHolderIdNo(String holderIdNo) {
        this.holderIdNo = holderIdNo;
    }

    public String getTransMode() {
        return transMode;
    }

    public void setTransMode(String transMode) {
        this.transMode = transMode;
    }

    public String getPrintNo() {
        return printNo;
    }

    public void setPrintNo(String printNo) {
        this.printNo = printNo;
    }

    public String getPolFlag() {
        return polFlag;
    }

    public void setPolFlag(String polFlag) {
        this.polFlag = polFlag;
    }

    public String getInsurStartDate() {
        return insurStartDate;
    }

    public void setInsurStartDate(String insurStartDate) {
        this.insurStartDate = insurStartDate;
    }

    public String getHolderemail() {
        return holderemail;
    }

    public void setHolderemail(String holderemail) {
        this.holderemail = holderemail;
    }

    public String getCertifyCode() {
        return certifyCode;
    }

    public void setCertifyCode(String certifyCode) {
        this.certifyCode = certifyCode;
    }

    public String getCustNumber() {
        return custNumber;
    }

    public void setCustNumber(String custNumber) {
        this.custNumber = custNumber;
    }

    public String getInsurEndDate() {
        return insurEndDate;
    }

    public void setInsurEndDate(String insurEndDate) {
        this.insurEndDate = insurEndDate;
    }

    public String getInsurPeriod() {
        return insurPeriod;
    }

    public void setInsurPeriod(String insurPeriod) {
        this.insurPeriod = insurPeriod;
    }

    public String getTaxPayerType() {
        return taxPayerType;
    }

    public void setTaxPayerType(String taxPayerType) {
        this.taxPayerType = taxPayerType;
    }

    public String getRevenueBank() {
        return revenueBank;
    }

    public void setRevenueBank(String revenueBank) {
        this.revenueBank = revenueBank;
    }

    public String getRevenueAccount() {
        return revenueAccount;
    }

    public void setRevenueAccount(String revenueAccount) {
        this.revenueAccount = revenueAccount;
    }

    public String getRevenueAddress() {
        return revenueAddress;
    }

    public void setRevenueAddress(String revenueAddress) {
        this.revenueAddress = revenueAddress;
    }

    public String getRevenuePhoneNumber() {
        return revenuePhoneNumber;
    }

    public void setRevenuePhoneNumber(String revenuePhoneNumber) {
        this.revenuePhoneNumber = revenuePhoneNumber;
    }

    public String getVisaCode() {
        return visaCode;
    }

    public void setVisaCode(String visaCode) {
        this.visaCode = visaCode;
    }

    public String getCardUwTime() {
        return cardUwTime;
    }

    public void setCardUwTime(String cardUwTime) {
        this.cardUwTime = cardUwTime;
    }

    public String getPropertyZip() {
        return propertyZip;
    }

    public void setPropertyZip(String propertyZip) {
        this.propertyZip = propertyZip;
    }

    public String getPropertyAddress() {
        return propertyAddress;
    }

    public void setPropertyAddress(String propertyAddress) {
        this.propertyAddress = propertyAddress;
    }
}
