package com.bcxin.ins.third.build.yangguang;

import com.bcxin.ins.third.build.yangguang.yggc.Result;
import com.bcxin.ins.core.entity.R;

import java.util.Map;

/**
 * 阳光工程保证保险
 * 陈堂君
 * Created by Apple on 2017/6/26.
 */
public interface YGGCService {
    /**
     * 工程投标保证保险——承保接口
     * @param p
     * @return
     */
    R underwriting(Map<String, Object> p);

    /**
     * 发起核保请求
     * @param json
     *  @param type 请求类型，1是核保请求，2是电子保单下载
     * @return
     */
    Result underwritingHttpSend(String json, String type) throws Exception;

    /**
     * 支付宝url，传入投保单号和支付金额，然后返回支付的url，调用的是阳光的地址
     * @param proposalNoP 投保单号 从承保的接口获得的结果
     * @param sumPremiumP 总金额 20个字符内，精度 0.00
     * @return
     */
    R payUrlZFB(String proposalNoP, String sumPremiumP);
    boolean  policyYG_callbackPay(Result result);
}
