package com.bcxin.ins.service.product.impl;

import com.bcxin.ins.service.order.InsuranceOperationAPIService;
import com.bcxin.ins.service.product.InsProductAPIService;
import com.bcxin.ins.service.product.ProductService;
import com.bcxin.ins.entity.product_core.ProPrimary;
import com.bcxin.ins.util.BASE64Util;
import com.bcxin.ins.util.GlobalResources;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.bcxin.ins.vo.ClientUserVo;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.DwzPage;
import com.bcxin.ins.vo.ProductVo;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
@Service
@Transactional
public class ProductServiceImpl implements ProductService {

	@Autowired
	private InsuranceOperationAPIService insuranceOperationService;
	@Autowired
	private InsProductAPIService insProductAPIService;

	private Logger log =  LoggerFactory.getLogger(ProductServiceImpl.class);
	/**
	 * <b>获取出口险产品列表信息 </b> 
	 * 对接后可把MarketRestriction替换成接口数据
	 * @return
	 * @author ZXF 
	 * @throws Exception 
	 * @date 2016年12月27日 下午2:20:03
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public List<ProductVo> getProducts(){
		return insuranceOperationService.selectProductVoList(new ProPrimary());
	}

	@Override
	public List<ProductVo> getProductsByOnLine(String code){
		return insProductAPIService.getProductsByOnLine(code);
	}

	@Override
	public List<ProductVo> getProductsByCodeForNotCache(String code){
		return insProductAPIService.getProductsByOnLine(code);
	}

	@Override
	public List<ProductVo> getProductsByConditionAndPage(String pro_type, String condition, DwzPage page) {
		return insProductAPIService.getProductsByConditionAndPage(pro_type,condition,page);
	}

	/**
	 * 生成分享链接
	 * @param oid 产品id
	 * @param userVo
	 * @return
	 */
	@Override
	public String setSharePath(Long oid, ClientUserVo userVo){
		String result = "";
		String pUrl = GlobalResources.getResource("BUSINESS_URL")+"insurance/product/productInfo/"+oid;
		if(userVo != null){
			if(StringUtils.isNotEmpty(userVo.getBusiness_support_id())){
				result = shareProduct(userVo.getBusiness_support_id(),pUrl);
			}else{
				result = shareProduct("",pUrl);
			}
		}else{
			result = shareProduct("",pUrl);
		}
		return result;
	}

	private String shareProduct(String resID,String path){
		String oidStr = "";
		if(StringUtils.isNotEmpty(resID)){
			try {
				oidStr = BASE64Util.encryptBASE64(resID);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		return path + "?recommendCode="+oidStr;
	}

	/**
	 * <b>根据产品id获取产品相应信息 </b> 
	 * 
	 * @param productID
	 * @return
	 * @author ZXF 
	 * @date 2016年12月27日 下午2:21:14
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public ProductVo getProduct(long productID){
		ProductVo vo = null;
		if(StrUtil.isNotBlank(String.valueOf(productID))){
			vo = insuranceOperationService.accordingToInsProductIDToGetInsProductInProductVo(productID);
		}
		return vo;
	}

	/**
	 * <b>根据产品Code获取后台产品id </b>
	 *
	 * @param productCode
	 * @return
	 * @author ZXF
	 * @date 2016年12月27日 下午2:21:14
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public String getProductIDByCode(String productCode){
		String product_id = "";
		if(StrUtil.isNotBlank(productCode)){
			ProPrimary product = insProductAPIService.findProductByCode(productCode);
			if(product != null){
				product_id = String.valueOf(product.getPro_primary_id());
			}
		}
		return product_id;
	}


	//根据产品判断是走泰康（1）接口还是平安（2）接口
	@Override
	public int api_request_sign(String product_code){
		if(StringUtils.isNotEmpty(product_code)){
			if(product_code.indexOf(ConstProp.TYX_TK)!=-1){
				return 1;
			}else if(product_code.indexOf(ConstProp.TYX_PAS)!=-1){
				return 2;
			}else if(product_code.indexOf(ConstProp.TYX_RB)!=-1){
				return 4;
			}else if(product_code.indexOf(ConstProp.TYX_PAC)!=-1){
				return 5;
			}else if(product_code.indexOf(ConstProp.ZZX_ZA)!=-1){
				return 1;
			}else if(product_code.indexOf(ConstProp.ZZX_PAC)!=-1){
				return 2;
			}else if(product_code.indexOf(ConstProp.ZZX_HT)!=-1){
				return 5;
			}else if(product_code.indexOf(ConstProp.GZX_HT)!=-1){
				return 1;
			}else if(product_code.indexOf(ConstProp.GZX_PAC)!=-1){
				return 2;
			}else if(product_code.indexOf(ConstProp.GZX_CA)!=-1){
				return 3;
			}else if(product_code.indexOf(ConstProp.ZZX_YA)!=-1){
				return 3;
			}else if(product_code.indexOf(ConstProp.ZZX_CA)!=-1){
				return 4;
			}else if(product_code.indexOf(ConstProp.TYX_CA)!=-1){
				return 6;
			}else if(product_code.indexOf(ConstProp.TYX_QH)!=-1){
				return 7;
			}else if(product_code.indexOf(ConstProp.TYX_HT)!=-1){
				return 8;
			}
		}
		return 9;
	}

	/**
	 * <b> 查询产品信息跟保障责任信息，用于saas对接接口 </b>
	 * @author ZXF
	 * @create 2018/04/02 0002 17:20
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public String listProductAndResponsibility(){
		return insProductAPIService.listProductAndResponsibility();
	}
}
