package com.bcxin.ins.service.product;


import com.bcxin.ins.core.entity.SysCompany;
import com.bcxin.ins.entity.product_core.ProPrimary;
import com.bcxin.ins.vo.*;
import com.bcxin.mybatisplus.service.IService;

import java.util.List;

public interface InsProductAPIService extends IService<ProPrimary> {

    public ProPrimary findProductByCode(String code);

    public List<ProductVo> selectProductVoListByCondition(String keywords);

    public List<ProPrimary> selectInsProductListByCondition(String keywords);

    public List<ProductVo> fillProductList(String[] pids);

    public List<SysCompany> fillCompanyList(String[] cids);

    List<ProPrimary> findProductList(ProPrimary insProduct);

    InsProductVo getProductAttrListByPid(Long pid, String type);

    ProPrimary getProduct(Long pid);

    public List<ProductVo> getProductsByOnLine(String code);

    /**
     * <b> 定时任务加载所有的产品信息到静态列表 DEFAULT_PRO_LIST ，预计10分钟重置一次</b>
     * @author ZXF
     * @create 2021/11/24 0024 16:55
     * @version
     * @注意事项 </b>
     */
    public void loadDefaultProducts();

    public List<ProductVo> getProductsByConditionAndPage(String pro_type, String condition, DwzPage page);

    public void accordingToProductIDToGetInsProductSetUpOrderFormVo(OrderFormVo vo, Long insProduct_id);

    public void accordingToProductIDToGetInsProductSetUpAdviceNoteVo(AdviceNoteVo vo, Long insProduct_id);

    public List<ProductVo> selectProductVoList(ProPrimary insProduct);

    public ProductVo accordingToInsProductIDToGetInsProductInProductVo(Long insProductID);

    public ProductVo willInsProductSetUpProductVo(ProPrimary ip);

    public ProductVo willInsProductAndFeeSetUpProductVo(ProPrimary product);

    public String listProductAndResponsibility();
}
