package com.bcxin.ins.service.preservation.impl;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.dao.preservation.InsPreservationRecordAPIDao;
import com.bcxin.ins.entity.policy_core.InsPreservationRecord;
import com.bcxin.ins.service.order.ComTaskResidualAPIService;
import com.bcxin.ins.service.preservation.RecordUpdateStrategy;
import com.bcxin.ins.spring.executor.MyAsyncExecutor;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.vo.*;
import com.google.common.collect.Maps;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.Map;


/**
 * <b>保单子表业务处理 </b>
 *
 * @author zxf
 * @date 2017年1月5日 上午10:28:33
 * @注意事项 </b>
 * <b>
 */
@Service
@Transactional
public class RbRecordUpdateStrategy implements RecordUpdateStrategy {

    private Logger log =  LoggerFactory.getLogger(RbRecordUpdateStrategy.class);

    @Autowired
    private ComTaskResidualAPIService comTaskResidualAPIService;

    @Autowired
    private InsPreservationRecordAPIDao insPreservationRecordAPIDao;

    @Autowired
    private MyAsyncExecutor myAsyncExecutor;

    private void updateCommonRecordFields(Map<String, String> map, InsPreservationRecord record) {
        // 统一处理批单号
        if (map.containsKey("batchNumber")) {
            record.setRevise_serial_num_ins(map.get("batchNumber"));
        }

        // 统一处理保费
        if (StringUtils.isNotEmpty(map.get("premium"))) {
            record.setTotal_premium(BigDecimal.valueOf(Double.parseDouble(map.get("premium"))));
        }

        // 统一处理电子批单路径
        if (map.get("eurl") != null) {
            record.setRevise_path(map.get("eurl"));
        }
    }

    @Override
    public int handleRenbaoUpdate(Map<String, String> map, InsPreservationRecord record, OrderFormVo vo, int sign) {
        if(map.get("batchNumber").contains("未查询到该批单申请号")){
            String batch_number = map.get("batchNumber").replace("未查询到该批单申请号","").replace("的批单号！","");
            myAsyncExecutor.execute(()->{
                Map parems = Maps.newHashMap();
                parems.put("record_id",String.valueOf(record.getIns_preservation_record_id()));
                parems.put("batch_number",batch_number);
                comTaskResidualAPIService.saveComTaskResidual("updateBatchNumber","修改人保保全批单号",
                        "com.bcxin.ins.service.preservation.InsPreservationRecordAPIService",1,"String",
                        JSONObject.toJSONString(parems));
            });
        }
        updateCommonRecordFields(map, record);
        sign = 1;
        return sign;
    }

    @Override
    public int handlePingAnCaiUpdate(Map<String, String> map, InsPreservationRecord record, OrderFormVo vo, int sign) {
        if(map.get("batchNumber").contains("未查询到该批单申请号")){
            String batch_number = map.get("batchNumber").replace("未查询到该批单申请号","").replace("的批单号！","");
            myAsyncExecutor.execute(()->{
                Map parems = Maps.newHashMap();
                parems.put("record_id",String.valueOf(record.getIns_preservation_record_id()));
                parems.put("batch_number",batch_number);
                comTaskResidualAPIService.saveComTaskResidual("updateBatchNumber","修改人保保全批单号",
                        "com.bcxin.ins.service.preservation.InsPreservationRecordAPIService",1,"String",
                        JSONObject.toJSONString(parems));
            });
        }
        updateCommonRecordFields(map, record);
        sign = 1;
        return sign;
    }

    @Override
    public int handleHuataiUpdate(Map<String, String> map, InsPreservationRecord record, int sign) {
        //华泰返回的批单申请单号
        updateCommonRecordFields(map, record);
        record.setRevise_status(DictConst.REVISE_STATUS_SPZ);
        insPreservationRecordAPIDao.updateById(record);
        //到这里map作用结束，外层根据该值判断批单在待审核阶段
        //map = null;
        return sign;
    }

    @Override
    public int handleZhonghuaUpdate(Map<String, String> map, InsPreservationRecord record, int sign) {
        //批改单号
        updateCommonRecordFields(map, record);
        if(StringUtils.isNotEmpty(map.get("tbsxsj"))){
            record.setInception_date(DateUtil.parseDate(map.get("tbsxsj")));
        }
        sign = 1;
        return sign;
    }

    @Override
    public int handleTaipingyangUpdate(Map<String, String> map, InsPreservationRecord record, int sign) {
        if(StringUtils.isEmpty(map.get("batchNumber")) && DictConst.REVISE_TYPE_Z.equals(record.getRevise_type())){
            record.setRevise_pay(map.get("payurl"));
            if(StringUtils.isNotEmpty(map.get("batchApplyNumber"))&& !map.get("batchApplyNumber").equals(record.getRevise_serial_number())){
                record.setRevise_serial_number(map.get("batchApplyNumber"));
            }
            record.setRevise_status(DictConst.REVISE_STATUS_SPZ);
        }else{
            updateCommonRecordFields(map, record);
            sign = 1;
        }
        insPreservationRecordAPIDao.updateById(record);
        return sign;
    }

    @Override
    public int handleChanganUpdate(Map<String, String> map, InsPreservationRecord record, String productCode, int sign) {
        updateCommonRecordFields(map, record);
        if(productCode.contains(ConstProp.GZZRX_CA)){
            insPreservationRecordAPIDao.updateById(record);
        }else if(productCode.contains(ConstProp.TYX_CA)){
            sign = 1;
        }
        return sign;
    }

    @Override
    public int handleQianhaiUpdate(Map<String, String> map, InsPreservationRecord record, int sign) {
        updateCommonRecordFields(map, record);
        sign = 1;
        return sign;
    }
}
