package com.bcxin.ins.service.preservation;


import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.dto.Result;
import com.bcxin.ins.entity.policy_core.InsPreservationResultSet;
import com.bcxin.ins.entity.policy_core.InsRoleInpolicy;
import com.bcxin.ins.vo.DwzPage;
import com.bcxin.ins.vo.InsPreservationDetailVo;
import com.bcxin.ins.vo.InsPreservationResultSetVo;
import com.bcxin.ins.vo.ResultDto;
import com.bcxin.mybatisplus.service.IService;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

public interface InsPreservationResultSetAPIService extends IService<InsPreservationResultSet> {

    public List<InsPreservationResultSet> findInsPreservationResultSetByKeyword(DwzPage page, Long preservationId, String keyword,String status, String start_time, String end_time);

    public List<InsPreservationResultSet> initFindInsPreservationResultSetByKeyword(DwzPage page, Long policyId, String keyword,String status, String start_time, String end_time);

    public List<InsPreservationResultSet> findZBByPolicyId(Long policyId,String productCode);

    public List<InsPreservationDetailVo> findInsPreservationDetailVoByIdCards(Long policyId, String idCards);

    public List<InsPreservationDetailVo> findInsPreservationDetailVoByImportBatchId(Long policyId, String importBatchId);

    public Integer findZBNumber(int dqNum, Long policyId);

    public InsPreservationResultSetVo getInsPreservationResultSetVoByOidAndSign(String oid, String sign);

    /**
     * <b> 根据订单Id和身份证列查询对应在保人员 </b>
     * @author ZXF
     * @create 2020/06/04 0004 14:26
     * @version
     * @注意事项 </b>
     */
    List<InsPreservationResultSetVo> getInsPreservationResultSetVoByIdCardsAndOrderId(Long policyId,List<String> idCardList);

    public boolean getEffectivePersonnelBySet(Long policyId,String id_card);

    public JSONObject readIPRSExcel(MultipartFile mFile) throws Exception;

    public boolean pushResultSetByRecord(Long record_id, String revise_type);

    public void updateResultSet(Long record_id, String revise_type);

    public void initAllOrderToResultSet(String product_code);

    public void initResultSetByOrderId(Long oid);

    public InsPreservationResultSet getResultSetBypolicyIdAndCardNo(String id_card,Long order_id);
    public Long getIdByIdCardAndOrderId(String id_card,Long order_id);
    public String getBusinessInceptionDateByBusinessId(String businessId);

    public String findDuplicateIdCardNo(String appName,String code,String[] list);

    public String findNotUnderWarrantyIdCardNo(String orderId,String[] list);

    public Map<String, String> getCostByOrderId(int lastDay, int recordCount,Long oid);

    /**
     * <b> 在保人员导出 </b>
     * @author ZXF
     * @create 2020/01/19 0019 16:44
     * @version
     * @注意事项 </b>
     */
    public void downResultSet(Long oid, HttpServletResponse response);

    public List<Map> sassFindPerNameByIdCard(String[] list);

    /**
     * <b> 根据在保人员id统计职业数量 </b>
     * @author ZXF
     * @create 2020/02/06 0006 13:58
     * @version
     * @注意事项 </b>
     */
    public Map<String,Integer> countCareer(String[] list);

    /**
     * <b> 批量人员导入处理(减员专用) </b>
     * @param importBatchId 批次Id：将获取当前登录的perId当做批次Id,这样每次导入就可以将对应批次在临时表的数据删除掉
     * @author ZXF
     * @create 2020/01/15 0015 15:58
     * @version
     * @注意事项 </b>
     */
    Result minusBatchUploadInsPer(Long importBatchId, MultipartFile file) throws Exception;

    /**
     * <b> 根据批次id导出该批次错误人员信息 </b>
     * @author ZXF
     * @create 2020/01/16 0016 14:05
     * @version
     * @注意事项 </b>
     */
    Result downErrInsPer(String importBatchId, HttpServletResponse response);
}
