package com.bcxin.ins.service.preservation;


import com.bcxin.ins.entity.policy_core.InsPreservationRecord;
import com.bcxin.ins.vo.DwzPage;
import com.bcxin.ins.vo.InsPreservationDetailVo;
import com.bcxin.ins.vo.InsPreservationRecordVo;
import com.bcxin.mybatisplus.service.IService;

import java.util.List;
import java.util.Map;

public interface InsPreservationRecordAPIService extends IService<InsPreservationRecord> {


    public List<InsPreservationRecord> findInsPreservationRecordByKeyword(DwzPage page, Long userId, String revise_status, String start_time, String end_time, String keyword);

    /**
     * <b> 统计待审核批单条数 </b>
     * @author ZXF
     * @create 2021/05/10 0010 9:44
     * @version
     * @注意事项 </b>
     */
    public boolean countDSHByPolicyNo(String policyNo);

    public InsPreservationRecordVo findInsPreservationRecordVoById(Long oid);

    public boolean getDZPD(Long preservationId);

    public InsPreservationRecordVo findIPRVoById(Long oid);
    /**
     * <b> 根据批单号查询批单 </b>
     * @author ZXF
     * @create 2021/05/06 0006 14:05
     * @version
     * @注意事项 </b>
     */
    public InsPreservationRecord findInsPreservationRecordByBySerialNum(String serial_num);
    /**
     * <b> 根据暂批单号查询批单 </b>
     * @author ZXF
     * @create 2021/05/06 0006 14:05
     * @version
     * @注意事项 </b>
     */
    public InsPreservationRecord findInsPreservationRecordBySerialNumber(String serial_number);
    public List<InsPreservationRecord> findNotResultRecord(String day);

    //根据保单号查询相关保全申请单最后‘已审核’状态的申请单
    public InsPreservationRecord findInsPreservationRecordByPolicyID(Long policyID);

    public List<InsPreservationRecordVo> findInsPreservationRecordVoByPayId(DwzPage page, Long payId, String keyword);

    public boolean createInsPreservationRecord(int sign,InsPreservationRecordVo iprVo, List<InsPreservationDetailVo> ipdVoList);

    public void updateRecordStatus(String record_id, Map<String,String> map);
    /**
     * <b>
     *     修改保全单状态为已审核
     * </b>
     * @param revise_serial_number 暂批单号
     * @param revise_serial_num_ins 批单号
     * @param eurl 电子批单
     * @param edrResult 批改结果状态
     * @param edrInfo 批改结果信息
     * @author ZXF
     * @create 2018/06/06 0006 14:00
     * @version
     * @注意事项 </b>
     */
    String updateHTRecordStatus(String revise_serial_number, String revise_serial_num_ins, String eurl, String edrResult, String edrInfo);

    /**
     * <b> 捞结算日期大于昨天的保全记录推送商城 </b>
     * @author ZXF
     * @create 2024/05/09 0009 16:36
     * @version
     * @注意事项 </b>
     */
    public void pushRecordToShop();

    public boolean minusInsPreservationRecord(int sign,InsPreservationRecordVo iprVo, List<InsPreservationDetailVo> ipdVoList);

    public boolean deleteInsPreservationRecord(Long oid);
    public boolean revokeInsPreservationRecord(Long oid);

    public boolean againRecord(Long oid);
    public boolean addAgainRecord(Long oid,List<InsPreservationDetailVo> ipdVoList);

    public String printDZPD(Long record_id,String batchNumber);

    public void saveRevisePath(Long record_id, String path);

    /**
     * 发送保全邮件
     * @param oid
     * @param list
     */
    void sendPreservationEmail(String oid,String  type,String content) ;

    /**
     * 保存保全用户 （增员或者减员接口）
     * 对接
     * @param map
     */
    public List<InsPreservationDetailVo> saveOrderPreservation(Map<String, Object> map);

    public String getEffectiveByPolicyId(Long policyId);

    public void setInsPreservationRecordStatus();

    public List<String> selectRecordIdByPolicyIdAndStatus(Long policyId, String status, String resType);

    public List<String> selectRecordIdByWebType(String type);

    public boolean updateRecordByIsPush(String recordId);

    public Map<String,String> recordRestToRB(InsPreservationRecordVo vo, String sign);

    /**
     * <b> 最新批单漏单情况，比对补偿 </b>
     * @author ZXF
     * @create 2023/08/17 0017 13:34
     * @version
     * @注意事项 </b>
     */
    public boolean addFindPDTask(String record_id);

    /**
     * <b> 根据批单ID查询最后一个批单号 </b>
     * @author ZXF
     * @create 2023/09/18 0018 15:21
     * @version
     * @注意事项 </b>
     */
    String last3Record(String record_id,String reNo);

    public boolean recordRest(InsPreservationRecordVo vo);

    /**
     * <b> 如果是平安财雇主的就给加入暂存，方便之后补单 </b>
     * @author ZXF
     * @create 2021/05/20 0020 14:34
     * @version
     * @注意事项 </b>
     */
    public boolean recordRestPAC(InsPreservationRecordVo iprvo);

    /**
     * <b> 特殊情况修改批单号(人保用) </b>
     * @author ZXF
     * @create 2020/01/07 0007 17:34
     * @version
     * @注意事项 </b>
     */
    public boolean updateBatchNumber(String json);

    /**
     * <b> 保存同步业务支撑后台返回的id </b>
     * @author ZXF
     * @create 2020/02/26 0026 13:59
     * @version
     * @注意事项 </b>
     */
    public void saveYWZCId(String record_id, String record_zc_id);

    /**
     * <b> 根据在保id查询批改单号</b>
     * @author ZXF
     * @create 2023/08/30 0030 14:13
     * @version
     * @注意事项 </b>
     */
    public String getRecordByResultId(String result_id);

    /**
     * <b> 订单对账数据入库 </b>
     * @author ZXF
     * @create 2024/05/10 0010 18:16
     * @version
     * @注意事项 </b>
     */
    void loadReconciliation() throws Exception;
}
