package com.bcxin.ins.service.preservation;


import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.entity.policy_core.InsPreservationDetail;
import com.bcxin.ins.vo.DwzPage;
import com.bcxin.ins.vo.InsPreservationDetailVo;
import com.bcxin.ins.vo.InsPreservationRecordVo;
import com.bcxin.ins.vo.InsPreservationResultSetVo;
import com.bcxin.mybatisplus.service.IService;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

public interface InsPreservationDetailAPIService extends IService<InsPreservationDetail> {

    public List<InsPreservationDetail> findInsPreservationDetailByKeyword(DwzPage page, Long preservationId, String keyword);

    public List<InsPreservationDetailVo> findInsPreservationDetailVoByKeyword(DwzPage page, Long preservationId, String keyword);

    public List<InsPreservationDetailVo> findInsPreservationDetailVoByPreservationId(String sign, Long preservationId);

    public boolean deleteInsPreservationDetail(Long oid);

    public boolean saveOrUpdateInsPreservationDetail(String revise_type, Long iprID, List<InsPreservationDetailVo> ipdVoList);

    /**
     * <b> 过滤重复投保人员 </b>
     * @author ZXF
     * @create 2019/09/26 0026 17:03
     * @version
     * @注意事项 </b>
     */
    public String isDuplicateIdCardNoToPreservationDetail(String order_id,List<InsPreservationDetailVo> list);

    /**
     * <b> 筛选重复操作减员的人员姓名 </b>
     * @author ZXF
     * @create 2019/09/26 0026 17:03
     * @version
     * @注意事项 </b>
     */
    public String notUnderWarrantyIdCardNo(String order_id,List<InsPreservationDetailVo> list);

    public String personnelToCheck(InsPreservationDetailVo vo, String revise_type);

    public List<InsPreservationDetail> selectDetailByRecordIdList(Long policyId, String status, String resType);

    public String detailSortAndValidator(InsPreservationRecordVo vo);

    /**
     * 批量人员排序及校验
     * @param vo
     */
    public String batchDetailSortAndValidator(InsPreservationRecordVo vo);

    public String empConfine(InsPreservationRecordVo vo, int perNum);

    public InsPreservationDetailVo detailConvertToResultSet(InsPreservationResultSetVo resultSet);

    public JSONObject readIPDExcel(MultipartFile mFile) throws Exception;

    public List<Map<Object,Object>> queryDetail(Map<Object, Object> p);

    /**
     * <b> 导出批单人员 </b>
     * @author ZXF
     * @create 2020/01/19 0019 16:44
     * @version
     * @注意事项 </b>
     */
    public void downPreservationDetail(Long preservationId, HttpServletResponse response);

    /**
     * <b> 根据用户id导出批单信息 </b>
     * @author ZXF
     * @create 2020/03/17 0017 17:19
     * @version
     * @注意事项 </b>
     */
    void downPreservationList(String userId, String keyword, String name, String start_time, String end_time, HttpServletResponse response);
}
