package com.bcxin.ins.service.order.impl;

import com.bcxin.ins.dao.order.TposBusinessDataAPIDao;
import com.bcxin.ins.service.order.TposBusinessDataAPIService;
import com.bcxin.ins.entity.tpost.TposBusinessData;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;


@Service
@Transactional(readOnly = true)
public class TposBusinessDataAPIServiceImpl extends ServiceImpl<TposBusinessDataAPIDao, TposBusinessData> implements TposBusinessDataAPIService {


	@Autowired
	private TposBusinessDataAPIDao dao;

	@Override
	public TposBusinessData findIdentity(TposBusinessData identity) {
		TposBusinessData bd = null;
		int i = 0;
		if(identity != null){
			if(StringUtils.isEmpty(identity.getName())) {
				i++;
			}
			if(StringUtils.isEmpty(identity.getCustoms_code())) {
				i++;
			}
		}else{
			i++;
		}
		if(i == 0){
			List<TposBusinessData> list = dao.findIdentity(identity.getCustoms_code(), identity.getName());
			if(list.size()>0){
				bd = list.get(0);
			}
		}
		return bd;
	}
}
