package com.bcxin.ins.service.order.impl;


import com.bcxin.ins.dao.order.SpecialPublicDutyAPIDao;
import com.bcxin.ins.service.order.InsInsuranceSlipAPIService;
import com.bcxin.ins.service.order.SpecialPublicDutyAPIService;
import com.bcxin.ins.entity.policy_special.SpecialPublicDuty;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.vo.SpecialPublicDutyVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;


/**
 * <b>公责险特殊字段业务处理 </b>
 * 
 * @author zxf
 * @date 2017年1月5日 上午10:28:33
 * @注意事项 </b>
 * <b>
 */
@Service
@Transactional
public class SpecialPublicDutyAPIServiceImpl extends ServiceImpl<SpecialPublicDutyAPIDao, SpecialPublicDuty> implements SpecialPublicDutyAPIService {

	@Autowired
	private SpecialPublicDutyAPIDao dao;
	@Autowired
	private InsInsuranceSlipAPIService insInsuranceSlipAPIService;

	@Override
	public SpecialPublicDuty initSpecialPublicDuty(){
		SpecialPublicDuty specialPublicDuty = new SpecialPublicDuty();//
		dao.insert(specialPublicDuty);
		return specialPublicDuty;
	}

	/**
	 * <b>根据Vo及公责险ID更新SpecialPublicDuty数据 </b>
	 *
	 * @param vo
	 * @param afrID 公责险id
	 * @author ZXF
	 * @date 2017年1月7日 下午4:26:25
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void accordingToTheSpecialPublicDutyVoSetUpSpecialPublicDuty(SpecialPublicDutyVo vo, Long afrID){
		SpecialPublicDuty specialPublicDuty = dao.selectById(afrID);
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(vo), specialPublicDuty);
		} catch (Exception e) {
			e.printStackTrace();
		}
		dao.updateById(specialPublicDuty);
	}

	/**
	 * <b>获取SpecialPublicDutyVo根据公责险id查询公责险信息插入到SpecialPublicDutyVo </b>
	 *
	 * @param vo 公责险辅助表
	 * @param afrID 公责险id
	 * @author ZXF
	 * @date 2017年1月8日 上午11:39:35
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void getSpecialPublicDutyVoByPolicyID(SpecialPublicDutyVo vo, Long afrID){
		SpecialPublicDuty specialPublicDuty = dao.selectById(afrID);
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(specialPublicDuty), vo);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * 根据pss提供的订单号查询数据库是否存在数据
	 * @param thr_order_id
	 * @return true:存在有效单，false:不存在有效单
	 */
	@Override
	public boolean getSpecialPublicDutyVoByThrOrderId(String thr_order_id){
		boolean flag = false;
		Map<String,Object> m = Maps.newHashMap();
		m.put("thr_order_id",thr_order_id);
		List<SpecialPublicDuty> list = dao.selectByMap(m);
		if(list.size()>0){
			boolean iisFlag = insInsuranceSlipAPIService.getInsInsuranceSlipBySpecialId(list.get(0).getSpecial_public_duty_id());
			if(iisFlag){
				flag = true;
			}
		}
		return flag;
	}
}
