package com.bcxin.ins.service.order.impl;

import com.bcxin.ins.dao.order.LogBusinessrequestDao;
import com.bcxin.ins.entity.common.LogBusinessrequest;
import com.bcxin.ins.service.order.LogBusinessrequestService;
import com.bcxin.ins.spring.executor.MyAsyncExecutor;
import com.bcxin.ins.util.IdWorker;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;


@Service
@Transactional(readOnly = true)
public class LogBusinessrequestServiceImpl extends ServiceImpl<LogBusinessrequestDao, LogBusinessrequest> implements LogBusinessrequestService {


	@Autowired
	private LogBusinessrequestDao dao;

	@Autowired
	private MyAsyncExecutor myAsyncExecutor;
	/**
	 * <b> 初始填充对象信息 </b>
	 * @author ZXF
	 * @create 2020/09/03 0003 16:21
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public LogBusinessrequest initLogBusinessrequest(String pId,String tranType,String url, String reqStr, String resStr, Date bTime, Date eTime,String dec){
		LogBusinessrequest lb = new LogBusinessrequest();
		if(StringUtils.isNotEmpty(pId)) lb.setPolicy_id(Long.parseLong(pId));
		if(StringUtils.isNotEmpty(resStr)&&resStr.length()>5000) resStr=resStr.substring(0,5000);
		lb.setBegin_time(bTime);
		lb.setEnd_time(eTime);
		lb.setRequest_message(reqStr);
		lb.setResponse_message(resStr);
		lb.setRequest_url(url);
		lb.setTrans_type(tranType);
		lb.setApi_dec(dec);
		return lb;
	}

	/**
	 * <b> 补充描述及状态并保存 </b>
	 * @author ZXF
	 * @create 2020/09/03 0003 16:22
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public void supplementDecAndSave (LogBusinessrequest lb,int status,String execStr){
		lb.setStatus(status);
		lb.setExec_message(execStr);
		myAsyncExecutor.execute(()->{
			lb.setLog_businessrequest_id(com.bcxin.mybatisplus.toolkit.IdWorker.getId());
			dao.insert(lb);
		});
	}
}
