package com.bcxin.ins.service.order.impl;

import com.bcxin.ins.service.order.*;
import com.bcxin.ins.service.product.InsProductAPIService;
import com.bcxin.ins.service.product.InsProductResponsibilityAPIService;
import com.bcxin.ins.service.user.ClientUserService;
import com.bcxin.ins.entity.policy_core.InsInsuranceSlip;
import com.bcxin.ins.entity.policy_core.InsMailPolicy;
import com.bcxin.ins.entity.policy_core.InsRoleInpolicy;
import com.bcxin.ins.entity.policy_core.InsTransaction;
import com.bcxin.ins.entity.policy_special.LnAccused;
import com.bcxin.ins.entity.product_core.ProPrimary;
import com.bcxin.ins.entity.user.SysClientUser;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.util.OrderSupportUtil;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.bcxin.ins.vo.*;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

import java.math.BigDecimal;
import java.util.List;


/**
 * <b>订单相关业务处理 </b>
 * 
 * @author zxf
 * @date 2017年1月5日 上午10:28:33
 * @注意事项 </b>
 * <b>
 */
@Service
@Transactional
public class InsuranceOperationAPIServiceImpl implements InsuranceOperationAPIService {

	private Logger log =  LoggerFactory.getLogger(InsuranceOperationAPIServiceImpl.class);

	@Autowired
	private InsInsuranceSlipAPIService insInsuranceSlipService;
	@Autowired
	private InsMicroExportAPIService insMicroExportService;
	@Autowired
	private InsRoleInpolicyAPIService insRoleInpolicyService;
	@Autowired
	private InsCommonExportAPIService insCommonExportService;
	@Autowired
	private SpecialBidAPIService insSpecialBidService;
	@Autowired
	private SpecialExhibitionAPIService specialExhibitionAPIService;
	@Autowired
	private SpecialPerformanceAPIService insSpecialPerformanceService;
	@Autowired
	private InsProductAPIService insProductService;
	@Autowired
	private InsMailPolicyAPIService insMailPolicyService;
	@Autowired
	private InsTransactionAPIService insTransactionService;
	@Autowired
	private InsUnderwriteAPIService insUnderwriteAPIService;
	@Autowired
	private SpecialLitigationAPIService specialLitigationService;
	@Autowired
	private SpecialPublicDutyAPIService specialPublicDutyService;
	@Autowired
	private ClientUserService clientUserService;
	@Autowired
	private LnAccusedAPIService lnAccusedAPIService;
	@Autowired
	private InsProductResponsibilityAPIService insProductResponsibilityAPIService;

	/**
	 * <b>初始化订单相关表 </b> 
	 * 
	 * @param poductID
	 * @param user_id
	 * @author ZXF 
	 * @date 2017年1月9日 下午2:00:35
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public InsInsuranceSlip initOrderCorrelation(Long poductID, Long user_id, String recommendCode,String trade_serial_number){
		InsInsuranceSlip insOrderForm = insInsuranceSlipService.initOrderForm(poductID, user_id, recommendCode, trade_serial_number);
		return insOrderForm;
	}
	
	/**
	 * <b>小微企业接收页面传回的值  SET METHOD </b> 
	 * 
	 * @param vo
	 * @author ZXF 
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void setMicroExportByMicroExportVo(MicroExportVo vo){
        try {
            InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
            if(StringUtils.isNotEmpty(vo.getRecommend_code())){
                insInsuranceSlip.setRecommend_code(vo.getRecommend_code());
            }
			insInsuranceSlip.setPremium(BigDecimal.valueOf(Double.parseDouble(vo.getGross_premium())));
			insInsuranceSlip.setInsured_amount(BigDecimal.valueOf(Double.parseDouble(vo.getInsured_amount())));
			if(StringUtils.isNotEmpty(vo.getInception_date())){
				insInsuranceSlip.setInception_date(DateUtil.convertStringToDate(vo.getInception_date()+ConstProp.DAY_00));
			}
			if(StringUtils.isNotEmpty(vo.getPlanned_end_date())){
				insInsuranceSlip.setPlanned_end_date(DateUtil.convertStringToDate(vo.getPlanned_end_date() + ConstProp.DAY_23));
			}
			insInsuranceSlipService.updateById(insInsuranceSlip);
            vo.setTrade_serial_number(insInsuranceSlip.getTrade_serial_number());
            vo.setOrder_status(insInsuranceSlip.getOrder_status());
            insRoleInpolicyService.setRoleInPolicyByRoleCompanyVo(vo.getRoleSubjectList(), insInsuranceSlip.getIns_insurance_slip_id());
            insMicroExportService.accordingToTheMicroExportVoSetUpInsMicroExport(vo, insInsuranceSlip.getSpecial_id());
            insMailPolicyService.accordingToTheMailPolicyVoSetUpInsMailPolicy(vo.getMailPolicyVo(), insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
        }catch (Exception ex){
            ex.printStackTrace();
        }

	}
	
	/**
	 * <b>根据订单id查询小微短期信息设置到MicroExportVo   GET METHOD</b> 
	 * 
	 * @param orderID 订单id
	 * @author ZXF 
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public MicroExportVo getMicroExportVoByOrderID(Long orderID){
		MicroExportVo vo = new MicroExportVo();
		MailPolicyVo voMP = new MailPolicyVo();
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(orderID);
		vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
		vo.setRecommend_code(insInsuranceSlip.getRecommend_code());
		if(insInsuranceSlip.getPremium() != null){
			vo.setGross_premium(String.valueOf(insInsuranceSlip.getPremium()));
		}
		if(insInsuranceSlip.getInsured_amount() != null){
			vo.setInsured_amount(String.valueOf(insInsuranceSlip.getInsured_amount()));
		}
		if(insInsuranceSlip.getInception_date() != null){
			vo.setInception_date(DateUtil.convertDateToString(insInsuranceSlip.getInception_date(),DateUtil.FORMAT2));
		}
		if(insInsuranceSlip.getPlanned_end_date() != null){
			vo.setPlanned_end_date(DateUtil.convertDateToString(insInsuranceSlip.getPlanned_end_date(),DateUtil.FORMAT2));
		}
		vo.setRoleSubjectList(insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id()));
		vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));
		insMicroExportService.getMicroExportVoByPolicyID(vo, insInsuranceSlip.getSpecial_id());
		InsMailPolicy insMailPolicy = insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
		insMailPolicyService.accordingToInsMailPolicyIntoMailPolicyVo(voMP, insMailPolicy);
		vo.setMailPolicyVo(voMP);
		return vo;
	}
	
	/**
	 * <b>企业短期出口特殊字段信息表接收页面传回的值（CommonExportVo_1）   SET METHOD</b> 
	 * 
	 * @param vo
	 * @author ZXF 
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void setCommonExportByCommonExportVo_1(CommonExportVo_1 vo){

		try {
			InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
			if(StringUtils.isNotEmpty(vo.getRecommend_code())){
				insInsuranceSlip.setRecommend_code(vo.getRecommend_code());
				insInsuranceSlipService.updateById(insInsuranceSlip);
			}
			insRoleInpolicyService.setRoleInPolicyByRoleCompanyVo(vo.getRoleSubjectList(), insInsuranceSlip.getIns_insurance_slip_id());
			insCommonExportService.accordingToTheCommonExportVo_1SetUpInsCommonExport(vo, insInsuranceSlip.getSpecial_id());
			if(vo.getRoleSubjectList().size()>0){
				if(StrUtil.isNotBlank(vo.getRoleSubjectList().get(0).getTurnover_export())){
					insInsuranceSlipService.getInsuredAmountSetToInsInsuranceSlip(BigDecimal.valueOf(Double.parseDouble(vo.getRoleSubjectList().get(0).getTurnover_export())), insInsuranceSlip);
				}
			}
		}catch (Exception ex){
			ex.printStackTrace();
		}

	}
	
	/**
	 * <b>企业短期出口特殊字段信息表接收页面传回的值（CommonExportVo_2）   SET METHOD</b> 
	 * 
	 * @param vo
	 * @author ZXF 
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void setCommonExportByCommonExportVo_2(CommonExportVo_2 vo){
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
		insCommonExportService.accordingToTheCommonExportVo_2SetUpInsCommonExport(vo, insInsuranceSlip.getSpecial_id());
	}
	
	/**
	 * <b>企业短期出口特殊字段信息表接收页面传回的值（CommonExportVo_3）   SET METHOD</b> 
	 * 
	 * @param vo
	 * @author ZXF 
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void setCommonExportByCommonExportVo_3(CommonExportVo_3 vo){
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
		insCommonExportService.accordingToTheCommonExportVo_3SetUpInsCommonExport(vo, insInsuranceSlip.getSpecial_id());
		insMailPolicyService.accordingToTheMailPolicyVoSetUpInsMailPolicy(vo.getMailPolicyVo(), insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
	}
	
	/**
	 * <b>根据订单id查询企业短期出口特殊字段信息设置到CommonExportVo_1  GET METHOD</b> 
	 * 
	 * @param orderID 订单id
	 * @author ZXF 
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public CommonExportVo_1 getCommonExportVo_1ByOrderID(Long orderID){
		CommonExportVo_1 vo = new CommonExportVo_1();
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(orderID);
		vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
		vo.setRecommend_code(insInsuranceSlip.getRecommend_code());
		vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));
		vo.setRoleSubjectList(insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id()));
		insCommonExportService.getCommonExportVo_1BySpecial_id(vo, insInsuranceSlip.getSpecial_id());
		return vo;
	}
	
	/**
	 * <b>根据订单id查询企业短期出口特殊字段信息设置到CommonExportVo_2  GET METHOD</b> 
	 * 
	 * @param orderID 订单id
	 * @author ZXF 
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public CommonExportVo_2 getCommonExportVo_2ByOrderID(Long orderID){
		CommonExportVo_2 vo = new CommonExportVo_2();
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(orderID);
		vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
		insCommonExportService.getCommonExportVo_2BySpecial_id(vo, insInsuranceSlip.getSpecial_id());
		return vo;
	}

	/**
	 * <b>根据订单id查询企业短期出口特殊字段信息设置到CommonExportVo_3  GET METHOD</b> 
	 * 
	 * @param orderID 订单id
	 * @author ZXF 
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public CommonExportVo_3 getCommonExportVo_3ByOrderID(Long orderID) {
		CommonExportVo_3 vo = new CommonExportVo_3();
		MailPolicyVo voMP = new MailPolicyVo();
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(orderID);
		vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
		insCommonExportService.getCommonExportVo_3BySpecial_id(vo, insInsuranceSlip.getSpecial_id());
		InsMailPolicy insMailPolicy = insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
		insMailPolicyService.accordingToInsMailPolicyIntoMailPolicyVo(voMP, insMailPolicy);
		vo.setMailPolicyVo(voMP);
		return vo;
	}
	
	/**
	 * <b>根据前台用户id跟订单状态查询订单并进行分页 </b> 
	 * 
	 * @param user_id
	 * @param status
	 * @param page
	 * @return
	 * @author ZXF 
	 * @date 2017年1月9日 下午8:21:24
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public List<OrderFormVo> selectInsOrderFormByUserIDAndStatusSetUpOrderFormVo(Long user_id, String status, String productType, String keyword, String starDate, String endDate, DwzPage page){
		InsOrderSearchVo search = InsOrderSearchVo.build(user_id,status,ConstProp.BLANK_CHAR, keyword, starDate, endDate, ConstProp.BLANK_CHAR,page);
		return insInsuranceSlipService.selectInsOrderFormByUserIDAndStatusSetUpOrderFormVo(search);
	}
	
	/**
	 * <b>根据前台用户id查找对应订单所有状态的总条目 </b> 
	 * 
	 * @param user_id
	 * @return
	 * @author ZXF 
	 * @date 2017年1月9日 下午9:59:47
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public OrderStatusCountVo selectOrderStatusCountVoByUserID(Long user_id, String pType, String keyword, String starDate, String endDate){
		InsOrderSearchVo search = InsOrderSearchVo.build(user_id,ConstProp.BLANK_CHAR,pType, keyword, starDate, endDate, ConstProp.BLANK_CHAR,null);
		return insInsuranceSlipService.selectOrderStatusCountVoByUserID(search);
	}
	
	/**
	 * <b>查询所有产品 </b> 
	 * 
	 * @return
	 * @author ZXF 
	 * @date 2017年1月10日 下午2:45:30
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public List<ProductVo> selectProductVoList(ProPrimary insProduct){
		return insProductService.selectProductVoList(insProduct);
	}
	
	/**
	 * <b>根据产品子表id查询并封装到ProductVo </b> 
	 * 
	 * @param insProductID
	 * @return
	 * @author ZXF 
	 * @date 2017年1月10日 下午2:46:16
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public ProductVo accordingToInsProductIDToGetInsProductInProductVo(Long insProductID){
		return insProductService.accordingToInsProductIDToGetInsProductInProductVo(insProductID);
	}
	
	/**
	 * <b>根据订单id查询并封装到OrderFormVo </b> 
	 * 
	 * @param order_id
	 * @return
	 * @author ZXF 
	 * @date 2017年1月10日 下午2:46:16
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public OrderFormVo accordingToOrderIDToGetOrderFormVo(Long order_id){
		/*InsOrderForm order = insInsuranceSlipService.packagingInsOrderForm(order_id);
		return insInsuranceSlipService.willInsOrderFormSetUpOrderFormVo(order);*/
		return insInsuranceSlipService.findOrderFormVoByID(order_id);
	}
	
	/**
	 * <b>根据订单id查询并封装到AdviceNoteVo </b> 
	 * 
	 * @param order_id
	 * @return
	 * @author ZXF 
	 * @date 2017年1月10日 下午2:46:16
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public AdviceNoteVo accordingToOrderIDToGetAdviceNoteVo(Long order_id){
		InsInsuranceSlip order = insInsuranceSlipService.selectById(order_id);
		return insInsuranceSlipService.willInsOrderFormSetUpAdviceNoteVo(order);
	}
	
	/**
	 * <b>修改订单状态 </b> 
	 * 
	 * @param vo
	 * @return
	 * @author ZXF 
	 * @date 2017年1月12日 上午9:43:07
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public String updateOrderFormStatus(OrderFormVo vo){
		return insInsuranceSlipService.updateOrderFormStatus(vo);
	}

	/**
	 * <b>有效订单同步到支撑</b>
	 *
	 * @param oid 投保订单id（insInsuranceSlip.id）
	 * @author ZXF
	 * @date 2017年7月5日 上午11:03:32
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void orderSyncZC(String oid){
		//承保订单传给支撑
		InsInsuranceSlip policy = insInsuranceSlipService.packagingInsOrderForm(Long.parseLong(oid));
		OrderFormVo orderVo = accordingToOrderIDToGetOrderFormVo(policy.getIns_insurance_slip_id());
		InsTransaction it = null;
		if(policy.getInsTransaction()!=null && !policy.getInsTransaction().isEmpty()){
			it = policy.getInsTransaction().get(0);
		}
		SysClientUser user = clientUserService.selectById(policy.getRegister_user_id());
		String sup_order_id = OrderSupportUtil.receiveOrderFormData(String.valueOf(user.getBusiness_support_id()),orderVo,policy,it,"");
		if(StringUtils.isNotEmpty(sup_order_id)){
			policy.setOrder_zc_id(Long.parseLong(sup_order_id));
			insInsuranceSlipService.updateById(policy);
		}
		if(it != null && !DictConst.PAY_TYPE_XX.equals(it.getPay_type())){
			OrderSupportUtil.receiveTrancetionData(policy,it);//同步交易信息
		}
	}
	
	/**
	 * <b>页面获取上传支付信息等插入到分销</b> 
	 * 
	 * @param path_url 支付凭证上传路径
	 * @param order_id 订单id
	 * @param path_sign 支付阶段标识
	 * @author ZXF 
	 * @date 2016年12月28日 上午11:03:32
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public String uploadPayMentFileToTranction(String path_url, String order_id, String path_sign, String payAmount, String paymentMethod){
		InsInsuranceSlip order = insInsuranceSlipService.selectById(Long.parseLong(order_id));
		if(order == null){
			return ConstProp.BLANK_CHAR;
		}
		insTransactionService.uploadPayMentFileToTranction(path_url, order, path_sign, payAmount,paymentMethod);
		return String.valueOf(order.getIns_insurance_slip_id());
	}

	/**
	 * <b>根据订单ID获取支付期标识</b> 
	 * 
	 * @param order_id 
	 * @author ZXF 
	 * @date 2016年12月28日 上午11:03:32
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public String accordingToOrderIDGainPathSign(String order_id) {
		return insTransactionService.accordingToOrderIDGainPathSign(order_id);
	}
	
	/**
	 * <b>根据前台获取的买家列表查询相应安全等级再获取产品配的安全等级进行筛选只要跟产品存在的安全等级匹配就创建一条InsRiskDuty数据 </b> 
	 * 
	 * @param order_id
	 * @author ZXF 
	 * @date 2017年1月19日 上午11:03:47
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void accordingToInsTopBuyersListGainInsRiskDuty(Long order_id){
		insInsuranceSlipService.accordingToInsTopBuyersListGainInsRiskDuty(order_id);
	}
	
	/**
	 * <b>生成投保单并保存 </b> 
	 * 
	 * @param order_id
	 * @author ZXF 
	 * @date 2017年1月19日 下午10:03:00
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void accordingToOrderIDCreatePolicySerialNumber(Long order_id){
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(order_id);
		insInsuranceSlipService.accordingToOrderIDCreatePolicySerialNumber(insInsuranceSlip);
	}

	/**
	 * <b>通过ID删除对应被保险人条目 </b>
	 *
	 * @param role_id
	 * @author ZXF
	 * @date 2017年1月19日 下午10:03:00
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public boolean deleteRoleInPolicyByOid(Long role_id){
		boolean flag = false;
		try{
			InsRoleInpolicy insRoleInpolicy = insRoleInpolicyService.selectById(role_id);
			if(insRoleInpolicy != null){
				insRoleInpolicyService.deleteById(role_id);
				flag = true;
			}
		}catch (Exception e){
			e.printStackTrace();
		}
		return flag;
	}

	@Override
	public UnderwriteVo accordingToOrderIDGainInsUnderwrite(Long order_id) {
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.packagingInsOrderForm(order_id);
		UnderwriteVo underwriteVo = insUnderwriteAPIService.accordingToInsUnderwriteIntoUnderwriteVo(insInsuranceSlip.getUnderwrite());
		return underwriteVo;
	}

	@Override
	public OrderFormVo findPolicyByExternalAndRoleName(String externalRefernce, String roleName){
		return insInsuranceSlipService.findPolicyByExternalAndRoleName(externalRefernce,roleName);
	}



	/****************************BUILD*******************************/



	/**
	 * <b>投标险接收页面传回的值  SET METHOD </b>
	 *
	 * @param vo
	 * @author ZXF
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void setSpecialBidBySpecialBidVo(SpecialBidVo vo){
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
		String tsn = insInsuranceSlip.getTrade_serial_number();
		if(StringUtils.isNotEmpty(vo.getRecommend_code())){
			insInsuranceSlip.setRecommend_code(vo.getRecommend_code());
		}
		if(StringUtils.isNotEmpty(vo.getInception_date())){
			vo.setInception_date(vo.getInception_date()+ConstProp.DAY_00);
		}
		if(StringUtils.isNotEmpty(vo.getPlanned_end_date())){
			vo.setPlanned_end_date(vo.getPlanned_end_date() + ConstProp.DAY_23);
		}
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(vo), insInsuranceSlip);
			insInsuranceSlip.setTrade_serial_number(tsn);
			insInsuranceSlipService.updateById(insInsuranceSlip);
		} catch (Exception e) {
			e.printStackTrace();
		}
		insRoleInpolicyService.setRoleInPolicyByRoleCompanyVo(vo.getRoleSubjectList(), insInsuranceSlip.getIns_insurance_slip_id());
		insSpecialBidService.accordingToTheSpecialBidVoSetUpInsSpecialBid(vo, insInsuranceSlip.getSpecial_id());
		insMailPolicyService.accordingToTheMailPolicyVoSetUpInsMailPolicy(vo.getMailPolicyVo(), insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
		if(StrUtil.isNotBlank(vo.getInsured_amount())){
			insInsuranceSlipService.getInsuredAmountSetToInsInsuranceSlip(BigDecimal.valueOf(Double.parseDouble(vo.getInsured_amount())), insInsuranceSlip);
		}
	}

	/**
	 * <b>根据订单id查询投标信息设置到SpecialBidVo   GET METHOD</b>
	 *
	 * @param orderID 订单id
	 * @author ZXF
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public SpecialBidVo getSpecialBidVoByOrderID(Long orderID){
		SpecialBidVo vo = new SpecialBidVo();
		MailPolicyVo voMP = new MailPolicyVo();
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(orderID);
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(insInsuranceSlip), vo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
		vo.setRecommend_code(insInsuranceSlip.getRecommend_code());
		vo.setRoleSubjectList(insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id()));
		vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));
		insSpecialBidService.getSpecialBidVoByPolicyID(vo, insInsuranceSlip.getSpecial_id());
		InsMailPolicy insMailPolicy = insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
		insMailPolicyService.accordingToInsMailPolicyIntoMailPolicyVo(voMP, insMailPolicy);
		vo.setMailPolicyVo(voMP);
		if(StringUtils.isNotEmpty(vo.getBid_time())){
			vo.setBid_time(vo.getBid_time().replace(ConstProp.DAY_00,""));
		}
		if(StringUtils.isNotEmpty(vo.getInception_date())){
			vo.setInception_date(vo.getInception_date().replace(ConstProp.DAY_00,""));
		}
		if(StringUtils.isNotEmpty(vo.getPlanned_end_date())){
			vo.setPlanned_end_date(vo.getPlanned_end_date().replace(ConstProp.DAY_23,""));
		}
		return vo;
	}

	/**
	 * <b>履约特殊字段信息表接收页面传回的值（CommonExportVo_1）   SET METHOD</b>
	 *
	 * @param vo
	 * @author ZXF
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void setSpecialPerformanceBySpecialPerformanceVo_1(SpecialPerformanceVo_1 vo){
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
		String tsn = insInsuranceSlip.getTrade_serial_number();
		if(StringUtils.isNotEmpty(vo.getRecommend_code())){
			insInsuranceSlip.setRecommend_code(vo.getRecommend_code());
		}
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(vo), insInsuranceSlip);
			insInsuranceSlip.setTrade_serial_number(tsn);
			insInsuranceSlipService.updateById(insInsuranceSlip);
		} catch (Exception e) {
			e.printStackTrace();
		}
		insSpecialPerformanceService.accordingToTheSpecialPerformanceVo_1SetUpInsSpecialPerformance(vo, insInsuranceSlip.getSpecial_id());
	}

	/**
	 * <b>履约特殊字段信息表接收页面传回的值（SpecialPerformanceVo_2）   SET METHOD</b>
	 *
	 * @param vo
	 * @author ZXF
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void setSpecialPerformanceBySpecialPerformanceVo_2(SpecialPerformanceVo_2 vo){
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
		String tsn = insInsuranceSlip.getTrade_serial_number();
		if(StringUtils.isNotEmpty(vo.getInception_date())){
			vo.setInception_date(vo.getInception_date()+ConstProp.DAY_00);
		}
		if(StringUtils.isNotEmpty(vo.getPlanned_end_date())){
			vo.setPlanned_end_date(vo.getPlanned_end_date() + ConstProp.DAY_23);
		}
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(vo), insInsuranceSlip);
			insInsuranceSlip.setTrade_serial_number(tsn);
			insInsuranceSlipService.updateById(insInsuranceSlip);
		} catch (Exception e) {
			e.printStackTrace();
		}
		insRoleInpolicyService.setRoleInPolicyByRoleCompanyVo(vo.getRoleSubjectList(), insInsuranceSlip.getIns_insurance_slip_id());
		insSpecialPerformanceService.accordingToTheSpecialPerformanceVo_2SetUpInsSpecialPerformance(vo, insInsuranceSlip.getSpecial_id());
		if(vo.getRoleSubjectList().size()>0){
			if(StrUtil.isNotBlank(vo.getRoleSubjectList().get(0).getTurnover_export())){
				insInsuranceSlipService.getInsuredAmountSetToInsInsuranceSlip(BigDecimal.valueOf(Double.parseDouble(vo.getRoleSubjectList().get(0).getTurnover_export())), insInsuranceSlip);
			}
		}
		insMailPolicyService.accordingToTheMailPolicyVoSetUpInsMailPolicy(vo.getMailPolicyVo(), insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
	}

	/**
	 * <b>履约特殊字段信息表接收页面传回的值（SpecialPerformanceVo_3）   SET METHOD</b>
	 *
	 * @param vo
	 * @author ZXF
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void setSpecialPerformanceBySpecialPerformanceVo_3(SpecialPerformanceVo_3 vo){
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
		insSpecialPerformanceService.accordingToTheSpecialPerformanceVo_3SetUpInsSpecialPerformance(vo, insInsuranceSlip.getSpecial_id());
	}

	/**
	 * <b>根据订单id查询履约特殊字段信息设置到SpecialPerformanceVo_1  GET METHOD</b>
	 *
	 * @param orderID 订单id
	 * @author ZXF
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public SpecialPerformanceVo_1 getSpecialPerformanceVo_1ByOrderID(Long orderID){
		SpecialPerformanceVo_1 vo = new SpecialPerformanceVo_1();
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(orderID);
		vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(insInsuranceSlip), vo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));
		insSpecialPerformanceService.getSpecialPerformanceVo_1BySpecial_id(vo, insInsuranceSlip.getSpecial_id());
		return vo;
	}

	/**
	 * <b>根据订单id查询履约特殊字段信息设置到SpecialPerformanceVo_2  GET METHOD</b>
	 *
	 * @param orderID 订单id
	 * @author ZXF
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public SpecialPerformanceVo_2 getSpecialPerformanceVo_2ByOrderID(Long orderID){
		SpecialPerformanceVo_2 vo = new SpecialPerformanceVo_2();
		MailPolicyVo voMP = new MailPolicyVo();
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(orderID);
		vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(insInsuranceSlip), vo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		insSpecialPerformanceService.getSpecialPerformanceVo_2BySpecial_id(vo, insInsuranceSlip.getSpecial_id());
		vo.setRoleSubjectList(insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id()));
		InsMailPolicy insMailPolicy = insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
		insMailPolicyService.accordingToInsMailPolicyIntoMailPolicyVo(voMP, insMailPolicy);
		vo.setMailPolicyVo(voMP);
		if(StringUtils.isNotEmpty(vo.getInception_date())){
			vo.setInception_date(vo.getInception_date().replace(ConstProp.DAY_00,""));
		}
		if(StringUtils.isNotEmpty(vo.getPlanned_end_date())){
			vo.setPlanned_end_date(vo.getPlanned_end_date().replace(ConstProp.DAY_23,""));
		}
		return vo;
	}

	/**
	 * <b>根据订单id查询履约特殊字段信息设置到SpecialPerformanceVo_3  GET METHOD</b>
	 *
	 * @param orderID 订单id
	 * @author ZXF
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public SpecialPerformanceVo_3 getSpecialPerformanceVo_3ByOrderID(Long orderID) {
		SpecialPerformanceVo_3 vo = new SpecialPerformanceVo_3();
		MailPolicyVo voMP = new MailPolicyVo();
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(orderID);
		vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
		insSpecialPerformanceService.getSpecialPerformanceVo_3BySpecial_id(vo, insInsuranceSlip.getSpecial_id());
		return vo;
	}


	/****************************LAWSUIT*******************************/


	/**
	 * <b>诉讼特殊字段信息表接收页面传回的值（SpecialLitigationVo_1）   SET METHOD</b>
	 *
	 * @param vo
	 * @author ZXF
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void setSpecialLitigationBySpecialLitigationVo_1(SpecialLitigationVo_1 vo){
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.packagingInsOrderForm(Long.parseLong(vo.getOid()));
		String tsn = insInsuranceSlip.getTrade_serial_number();
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(vo), insInsuranceSlip);
			insInsuranceSlip.setTrade_serial_number(tsn);
			insInsuranceSlipService.updateById(insInsuranceSlip);
		} catch (Exception e) {
			e.printStackTrace();
		}
		insRoleInpolicyService.setRoleInPolicyByRoleCompanyVo(vo.getRoleSubjectList(), insInsuranceSlip.getIns_insurance_slip_id());
		specialLitigationService.accordingToTheSpecialLitigationVo_1SetUpSpecialLitigation(vo, insInsuranceSlip.getSpecial_id());
		if(vo.getRoleSubjectList().size()>0){
			if(StrUtil.isNotBlank(vo.getRoleSubjectList().get(0).getTurnover_export())){
				insInsuranceSlipService.getInsuredAmountSetToInsInsuranceSlip(BigDecimal.valueOf(Double.parseDouble(vo.getRoleSubjectList().get(0).getTurnover_export())), insInsuranceSlip);
			}
		}
	}

	/**
	 * <b>诉讼特殊字段信息表接收页面传回的值（SpecialLitigationVo_2）   SET METHOD</b>
	 *
	 * @param vo
	 * @author ZXF
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void setSpecialLitigationBySpecialLitigationVo_2(SpecialLitigationVo_2 vo){
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
		String tsn = insInsuranceSlip.getTrade_serial_number();
		if(StringUtils.isNotEmpty(vo.getInception_date())){
			vo.setInception_date(vo.getInception_date()+ConstProp.DAY_00);
		}
		if(StringUtils.isNotEmpty(vo.getPlanned_end_date())){
			vo.setPlanned_end_date(vo.getPlanned_end_date() + ConstProp.DAY_23);
		}
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(vo), insInsuranceSlip);
			insInsuranceSlip.setTrade_serial_number(tsn);
			insInsuranceSlipService.updateById(insInsuranceSlip);
		} catch (Exception e) {
			e.printStackTrace();
		}
		specialLitigationService.accordingToTheSpecialLitigationVo_2SetUpSpecialLitigation(vo, insInsuranceSlip.getSpecial_id());
		insMailPolicyService.accordingToTheMailPolicyVoSetUpInsMailPolicy(vo.getMailPolicyVo(), insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
	}

	/**
	 * <b>诉讼特殊字段信息表接收页面传回的值（SpecialLitigationVo_3）   SET METHOD</b>
	 *
	 * @param vo
	 * @author ZXF
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void setSpecialLitigationBySpecialLitigationVo_3(SpecialLitigationVo_3 vo){
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
		specialLitigationService.accordingToTheSpecialLitigationVo_3SetUpSpecialLitigation(vo, insInsuranceSlip.getSpecial_id());
	}

	/**
	 * <b>根据订单id查询诉讼特殊字段信息设置到SpecialLitigationVo_1  GET METHOD</b>
	 *
	 * @param orderID 订单id
	 * @author ZXF
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public SpecialLitigationVo_1 getSpecialLitigationVo_1ByOrderID(Long orderID){
		SpecialLitigationVo_1 vo = new SpecialLitigationVo_1();
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(orderID);
		vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(insInsuranceSlip), vo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));
		vo.setRoleSubjectList(insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id()));
		specialLitigationService.getSpecialLitigationVo_1BySpecial_id(vo, insInsuranceSlip.getSpecial_id());
		return vo;
	}

	/**
	 * <b>根据订单id查询诉讼特殊字段信息设置到SpecialLitigationVo_2  GET METHOD</b>
	 *
	 * @param orderID 订单id
	 * @author ZXF
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public SpecialLitigationVo_2 getSpecialLitigationVo_2ByOrderID(Long orderID){
		SpecialLitigationVo_2 vo = new SpecialLitigationVo_2();
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(orderID);
		vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(insInsuranceSlip), vo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		specialLitigationService.getSpecialLitigationVo_2BySpecial_id(vo, insInsuranceSlip.getSpecial_id());
		MailPolicyVo voMP = new MailPolicyVo();
		InsMailPolicy insMailPolicy = insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
		insMailPolicyService.accordingToInsMailPolicyIntoMailPolicyVo(voMP, insMailPolicy);
		vo.setMailPolicyVo(voMP);
		if(StringUtils.isNotEmpty(vo.getInception_date())){
			vo.setInception_date(vo.getInception_date().replace(ConstProp.DAY_00,""));
		}
		if(StringUtils.isNotEmpty(vo.getPlanned_end_date())){
			vo.setPlanned_end_date(vo.getPlanned_end_date().replace(ConstProp.DAY_23,""));
		}
		return vo;
	}

	/**
	 * <b>根据订单id查询诉讼特殊字段信息设置到SpecialLitigationVo_3  GET METHOD</b>
	 *
	 * @param orderID 订单id
	 * @author ZXF
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public SpecialLitigationVo_3 getSpecialLitigationVo_3ByOrderID(Long orderID) {
		SpecialLitigationVo_3 vo = new SpecialLitigationVo_3();
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(orderID);
		vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
		specialLitigationService.getSpecialLitigationVo_3BySpecial_id(vo, insInsuranceSlip.getSpecial_id());
		return vo;
	}


	/**
	 * <b>通过ID删除对应被保险人条目 </b>
	 *
	 * @param lna_id
	 * @author ZXF
	 * @date 2017年1月19日 下午10:03:00
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public boolean deleteLnAccusedByOid(Long lna_id){
		boolean flag = false;
		try{
			LnAccused lnAccused = lnAccusedAPIService.selectById(lna_id);
			if(lnAccused != null){
				lnAccusedAPIService.deleteById(lna_id);
				flag = true;
			}
		}catch (Exception e){
			e.printStackTrace();
		}
		return flag;
	}

	/****************************GMR*******************************/



	/**
	 * <b>投标险接收页面传回的值  SET METHOD </b>
	 *
	 * @param vo
	 * @author ZXF
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void setGMRPolicyByGMRPolicyVo(GMRPolicyVo vo){
		try {
			log.info("团意险订单数据处理开始---------------------");
			InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
			if(StringUtils.isNotEmpty(vo.getRecommend_code())){
				insInsuranceSlip.setRecommend_code(vo.getRecommend_code());
			}
			if(StringUtils.isNotEmpty(vo.getInception_date())){
				insInsuranceSlip.setInception_date(DateUtil.convertString2Date(vo.getInception_date()+ConstProp.DAY_00));
			}

			insInsuranceSlip.setAccredit_path(vo.getAccredit_path());
			insInsuranceSlipService.updateById(insInsuranceSlip);
			vo.setTrade_serial_number(insInsuranceSlip.getTrade_serial_number());
			log.info("团意险订单人员过滤开始---------------------");
			log.info("团意险订单人员初始数据,vo.getRoleSubjectList():"+vo.getRoleSubjectList().size());
			//过滤被保险人中无证件号的条目
			List<RoleSubjectVo> voList = Lists.newArrayList();
			for(RoleSubjectVo rvo : vo.getRoleSubjectList()){
				if(ConstProp.DIGIT_ONE.equals(rvo.getKind())){
					voList.add(rvo);
				}else{
					if(StringUtils.isNotEmpty(rvo.getOrganization_code())||StringUtils.isNotEmpty(rvo.getName_cn())||StringUtils.isNotEmpty(rvo.getMobile())||StringUtils.isNotEmpty(rvo.getBirth_date())){
						voList.add(rvo);
					}
				}
			}
			log.info("团意险订单人员过滤后数据,voList:"+voList);
			log.info("团意险订单人员过滤结束---------------------");
			log.info("团意险订单人员更新数据库开始---------------------");
			insRoleInpolicyService.setRoleInPolicyByRoleCompanyVo(voList, insInsuranceSlip.getIns_insurance_slip_id());
			log.info("团意险订单人员更新数据库结束---------------------");
			insMailPolicyService.accordingToTheMailPolicyVoSetUpInsMailPolicy(vo.getMailPolicyVo(), insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
			insInsuranceSlipService.setPremiumAndCoverageByOrderID(insInsuranceSlip);
			/*if(StrUtil.isNotBlank(vo.getInsured_amount())){
				insInsuranceSlipService.getInsuredAmountSetToInsInsuranceSlip(BigDecimal.valueOf(Double.parseDouble(vo.getInsured_amount())), insInsuranceSlip);
			}*/
		}catch (Exception e){
			log.error("团意险订单更新过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
		}
	}

	/**
	 * <b>根据订单id查询投标信息设置到SpecialBidVo   GET METHOD</b>
	 *
	 * @param orderID 订单id
	 * @author ZXF
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public GMRPolicyVo getGMRPolicyVoByOrderID(Long orderID){
		GMRPolicyVo vo = new GMRPolicyVo();
		MailPolicyVo voMP = new MailPolicyVo();
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(orderID);
//		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.packagingInsOrderForm(orderID);
		vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
		if(insInsuranceSlip.getInception_date() != null){
			vo.setInception_date(DateUtil.convertDateToString(insInsuranceSlip.getInception_date(),DateUtil.FORMAT2));
		}
		vo.setAccredit_path(insInsuranceSlip.getAccredit_path());
		vo.setRecommend_code(insInsuranceSlip.getRecommend_code());
		//查询被保险人条目，如果少于3条补齐
		List<RoleSubjectVo> list = insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id());
		if(list.size()<4){
			int v = 4-list.size();
			RoleSubjectVo rvo = new RoleSubjectVo();
			rvo.setKind(ConstProp.DIGIT_TWO);
			rvo.setMajor_group(ConstProp.DIGIT_ONE);
			for(int i = 0; i<v; i++){
				list.add(rvo);
			}
		}
		vo.setRoleSubjectList(list);
		vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));
		InsMailPolicy insMailPolicy = insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
		insMailPolicyService.accordingToInsMailPolicyIntoMailPolicyVo(voMP, insMailPolicy);
		vo.setMailPolicyVo(voMP);
		return vo;
	}

	/****************************AFR*******************************/



	/**
	 * <b>公责险接收页面传回的值  SET METHOD </b>
	 *
	 * @param vo
	 * @author ZXF
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void setSpecialPublicDutyBySpecialPublicDutyVo(SpecialPublicDutyVo vo){
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
		String tsn = insInsuranceSlip.getTrade_serial_number();
		if(StringUtils.isNotEmpty(vo.getInception_date())){
			if(!vo.getInception_date().contains(ConstProp.DAY_00)){
				vo.setInception_date(vo.getInception_date()+ConstProp.DAY_00);
			}
		}
		if(StringUtils.isNotEmpty(vo.getPlanned_end_date())){
			if(!vo.getPlanned_end_date().contains(ConstProp.DAY_23)){
				vo.setPlanned_end_date(vo.getPlanned_end_date()+ConstProp.DAY_23);
			}
		}
		try {
			MyConverUtil.map2PO( MyConverUtil.PO2Map(vo), insInsuranceSlip);
			insInsuranceSlip.setTrade_serial_number(tsn);
			insInsuranceSlipService.updateById(insInsuranceSlip);
		} catch (Exception e) {
			e.printStackTrace();
		}
		vo.setTrade_serial_number(insInsuranceSlip.getTrade_serial_number());
		insRoleInpolicyService.setRoleInPolicyByRoleCompanyVo(vo.getRoleSubjectList(), insInsuranceSlip.getIns_insurance_slip_id());
		specialPublicDutyService.accordingToTheSpecialPublicDutyVoSetUpSpecialPublicDuty(vo, insInsuranceSlip.getSpecial_id());
		insMailPolicyService.accordingToTheMailPolicyVoSetUpInsMailPolicy(vo.getMailPolicyVo(), insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
		/*if(StrUtil.isNotBlank(vo.getInsured_amount())){//保额计算
			insInsuranceSlipService.getInsuredAmountSetToInsInsuranceSlip(BigDecimal.valueOf(Double.parseDouble(vo.getInsured_amount())), insInsuranceSlip);
		}*/
	}

	/**
	 * <b>根据订单id查询公责险信息设置到SpecialPublicDutyVo   GET METHOD</b>
	 *
	 * @param orderID 订单id
	 * @author ZXF
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public SpecialPublicDutyVo getSpecialPublicDutyVoByOrderID(Long orderID){
		SpecialPublicDutyVo vo = new SpecialPublicDutyVo();
		MailPolicyVo voMP = new MailPolicyVo();
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(orderID);
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(insInsuranceSlip), vo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
		vo.setRoleSubjectList(insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id()));
		vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));
		specialPublicDutyService.getSpecialPublicDutyVoByPolicyID(vo, insInsuranceSlip.getSpecial_id());
		InsMailPolicy insMailPolicy = insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
		insMailPolicyService.accordingToInsMailPolicyIntoMailPolicyVo(voMP, insMailPolicy);
		vo.setMailPolicyVo(voMP);
		return vo;
	}

	/****************************ZZX*******************************/



	/**
	 * <b>展责险接收页面传回的值  SET METHOD </b>
	 *
	 * @param vo
	 * @author ZXF
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void setLOTEPolicyByLOTEPolicyVo(LOTEPolicyVo vo){
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
		if(StringUtils.isNotEmpty(vo.getRecommend_code())){
			insInsuranceSlip.setRecommend_code(vo.getRecommend_code());
		}
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(vo), insInsuranceSlip);
			insInsuranceSlip.setTrade_serial_number(insInsuranceSlip.getTrade_serial_number());
			if(insInsuranceSlip.getInsured_amount() == null || insInsuranceSlip.getInsured_amount().compareTo(BigDecimal.ONE)<0 ){//设置保险金额
				insInsuranceSlip.setInsured_amount(setInsuredAmountByProductId(insInsuranceSlip.getPro_primary().getPro_primary_id()));
			}
			if(vo.getSpecialExhibitionVo() != null){
				if(StringUtils.isNotEmpty(vo.getSpecialExhibitionVo().getStar_time())){
					insInsuranceSlip.setInception_date(DateUtil.convertString2Date(vo.getSpecialExhibitionVo().getStar_time()+ConstProp.DAY_00));
				}
				if(StringUtils.isNotEmpty(vo.getSpecialExhibitionVo().getEnd_time())){
//					Date ped = DateUtil.addDay(DateUtil.convertString2Date(vo.getSpecialExhibitionVo().getEnd_time()+" 23:59:59"),15);
					insInsuranceSlip.setPlanned_end_date(DateUtil.convertString2Date(vo.getSpecialExhibitionVo().getEnd_time()+ConstProp.DAY_23));
				}
			}
			insInsuranceSlipService.updateById(insInsuranceSlip);
		} catch (Exception e) {
			e.printStackTrace();
		}
		insRoleInpolicyService.setRoleInPolicyByRoleCompanyVo(vo.getRoleSubjectList(), insInsuranceSlip.getIns_insurance_slip_id());
		if(insInsuranceSlip.getSpecial_id() != null){
			if(ConstProp.DIGIT_ZERO.equals(vo.getSpecialExhibitionVo().getContains())){
				vo.getSpecialExhibitionVo().setBuild_com_name(" ");
				vo.getSpecialExhibitionVo().setSubcontracting_units(" ");
			}
			specialExhibitionAPIService.accordingToTheSpecialExhibitionVoSetUpSpecialExhibition(vo.getSpecialExhibitionVo(), insInsuranceSlip.getSpecial_id());
		}
		if(insInsuranceSlip.getMailPolicy() != null){
			insMailPolicyService.accordingToTheMailPolicyVoSetUpInsMailPolicy(vo.getMailPolicyVo(), insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
		}
//		insInsuranceSlipService.setPremiumAndCoverageByOrderID(insInsuranceSlip.getIns_insurance_slip_id());
	}

	/**
	 * 通过产品id查询统计保障责任的金额算出保险金额值
	 * @param pId
	 * @return
	 */
	@Override
	public BigDecimal setInsuredAmountByProductId(Long pId){
		BigDecimal result = BigDecimal.ZERO;
		List<ResponsibilityVo> irpVoList = insProductResponsibilityAPIService.findResponsibilityVoList(String.valueOf(pId));
		if(irpVoList.size()<=0){
			return result;
		}
		for(ResponsibilityVo vo : irpVoList){
			if(ConstProp.DIGIT_ONE.equals(vo.getType())){//保险金额算法
				if(StringUtils.isEmpty(vo.getFcy())){
					continue;
				}
				if(StringUtils.isNotEmpty(vo.getCompensation_days())){
					result = result.add((BigDecimal.valueOf(Double.parseDouble(vo.getFcy()))).multiply(BigDecimal.valueOf(Double.parseDouble("180"))));
				}else{
					result = result.add(BigDecimal.valueOf(Double.parseDouble(vo.getFcy())));
				}
			}else{//赔偿限额算法
				if(StringUtils.isNotEmpty(vo.getInsurance_amount_max())){
					result = result.add(BigDecimal.valueOf(Double.parseDouble(vo.getInsurance_amount_max())));
				}
			}
		}
		return result;
	}

	/**
	 * <b>根据订单id查询展责险信息设置到LOTEPolicyVo   GET METHOD</b>
	 *
	 * @param orderID 订单id
	 * @author ZXF
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public LOTEPolicyVo getLOTEPolicyVoByOrderID(Long orderID){
		LOTEPolicyVo vo = new LOTEPolicyVo();
		MailPolicyVo voMP = new MailPolicyVo();
		SpecialExhibitionVo seVo = new SpecialExhibitionVo();
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(orderID);
		vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
		if(insInsuranceSlip.getInception_date() != null){
			vo.setInception_date(DateUtil.convertDateToString(insInsuranceSlip.getInception_date(),DateUtil.FORMAT2));
		}
		vo.setRecommend_code(insInsuranceSlip.getRecommend_code());
		vo.setRoleSubjectList(insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id()));
		vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));
		if(insInsuranceSlip.getSpecial_id() != null){
			specialExhibitionAPIService.getSpecialExhibitionVoByPolicyID(seVo, insInsuranceSlip.getSpecial_id());
		}
		vo.setSpecialExhibitionVo(seVo);
		if(insInsuranceSlip.getMailPolicy() != null){
			InsMailPolicy insMailPolicy = insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
			insMailPolicyService.accordingToInsMailPolicyIntoMailPolicyVo(voMP, insMailPolicy);
		}
		vo.setMailPolicyVo(voMP);
		return vo;
	}

	/****************************GMR*******************************/



	/**
	 * <b>个意险接收页面传回的值  SET METHOD </b>
	 *
	 * @param vo
	 * @author ZXF
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void setGYXPolicyByGYXPolicyVo(GYXPolicyVo vo){
		try {
			log.info("个意险订单数据处理开始---------------------");
			InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
			if(StringUtils.isNotEmpty(vo.getRecommend_code())){
				insInsuranceSlip.setRecommend_code(vo.getRecommend_code());
			}

			if(StringUtils.isNotEmpty(vo.getInception_date())){
				insInsuranceSlip.setInception_date(DateUtil.convertString2Date(vo.getInception_date()+ConstProp.DAY_00));
				insInsuranceSlip.setPlanned_end_date(DateUtil.convertString2Date(vo.getPlanned_end_date()+ConstProp.DAY_23));
			}

			vo.setTrade_serial_number(insInsuranceSlip.getTrade_serial_number());
			log.info("个意险订单人员过滤开始---------------------");
			log.info("个意险订单人员初始数据,vo.getRoleSubjectList():"+vo.getRoleSubjectList().size());
			//过滤被保险人中无证件号的条目
			List<RoleSubjectVo> voList = Lists.newArrayList();
			for(RoleSubjectVo rvo : vo.getRoleSubjectList()){
				if(ConstProp.DIGIT_ONE.equals(rvo.getKind())){
					voList.add(rvo);
				}else{
					if(StringUtils.isNotEmpty(rvo.getOrganization_code())||StringUtils.isNotEmpty(rvo.getName_cn())||StringUtils.isNotEmpty(rvo.getMobile())||StringUtils.isNotEmpty(rvo.getBirth_date())){
						voList.add(rvo);
					}
				}
			}
			int perNum = voList.size()-1;
			insInsuranceSlip.setInsured_amount(setInsuredAmountByProductId(insInsuranceSlip.getPro_primary().getPro_primary_id()).multiply(BigDecimal.valueOf(Double.parseDouble(String.valueOf(perNum)))));
			int days = DateUtil.getDistDates(insInsuranceSlip.getInception_date(),insInsuranceSlip.getPlanned_end_date());
			if(days > 0 || days == 0){
				insInsuranceSlip.setPremium(getPremiumByGYX(days).multiply(BigDecimal.valueOf(Double.parseDouble(String.valueOf(perNum)))));
			}
			insInsuranceSlipService.updateById(insInsuranceSlip);
			log.info("个意险订单人员过滤后数据,voList:"+voList);
			log.info("个意险订单人员过滤结束---------------------");
			insRoleInpolicyService.setRoleInPolicyByRoleCompanyVo(voList, insInsuranceSlip.getIns_insurance_slip_id());
			log.info("个意险订单人员更新数据库结束---------------------");
		}catch (Exception e){
			log.error("个意险订单更新过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
		}
	}

	private BigDecimal getPremiumByGYX(int day){
		BigDecimal allPr = BigDecimal.ZERO;
		if(day<2){
			allPr = BigDecimal.valueOf(Double.parseDouble("10"));
		}else if(day>1&&day<8){
			allPr = BigDecimal.valueOf(Double.parseDouble("20"));
		}else if(day>7&&day<16){
			allPr = BigDecimal.valueOf(Double.parseDouble("30"));
		}else if(day>15&&day<31){
			allPr = BigDecimal.valueOf(Double.parseDouble("50"));
		}
		return allPr;
	}
	/*private BigDecimal getInsuredAmountByGYX(Long product_id){
		List<ResponsibilityVo> irpVoList = insProductResponsibilityAPIService.getResponsibilityVoListByProductID(product_id);
		BigDecimal allAm = BigDecimal.ZERO;
		if(irpVoList.size()>0){
			for(ResponsibilityVo vo : irpVoList){
				if(StringUtils.isNotEmpty(vo.getFcy())){
					allAm = allAm.add(BigDecimal.valueOf(Double.parseDouble(vo.getFcy())));
				}
			}
		}
		return allAm;
	}*/

	/**
	 * <b>根据订单id查询个意险信息设置到GYXPolicyVo   GET METHOD</b>
	 *
	 * @param orderID 订单id
	 * @author ZXF
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public GYXPolicyVo getGYXPolicyVoByOrderID(Long orderID){
		GYXPolicyVo vo = new GYXPolicyVo();
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(orderID);
		vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
		if(insInsuranceSlip.getInception_date() != null){
			vo.setInception_date(DateUtil.convertDateToString(insInsuranceSlip.getInception_date(),DateUtil.FORMAT2));
			vo.setPlanned_end_date(DateUtil.convertDateToString(insInsuranceSlip.getPlanned_end_date(),DateUtil.FORMAT2));
		}
		vo.setRecommend_code(insInsuranceSlip.getRecommend_code());
		vo.setRoleSubjectList(insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id()));
		vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));
		return vo;
	}
}
