package com.bcxin.ins.service.order.impl;

import com.bcxin.ins.dao.order.InsUnderwriteAPIDao;
import com.bcxin.ins.service.order.InsInsuranceSlipAPIService;
import com.bcxin.ins.service.order.InsRiskDutyAPIService;
import com.bcxin.ins.service.order.InsUnderwriteAPIService;
import com.bcxin.ins.entity.policy_core.InsInsuranceSlip;
import com.bcxin.ins.entity.policy_core.InsUnderwrite;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.util.toolbox.DateUtil;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.bcxin.ins.vo.RiskDutyVo;
import com.bcxin.ins.vo.UnderwriteVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;


/**
 * <b>承保信息业务处理 </b>
 * 
 * @author zxf
 * @date 2017年1月5日 上午10:28:33
 * @注意事项 </b>
 * <b>
 */
@Service
@Transactional
public class InsUnderwriteAPIServiceImpl extends ServiceImpl<InsUnderwriteAPIDao, InsUnderwrite> implements InsUnderwriteAPIService {

	@Autowired
	private InsUnderwriteAPIDao dao;

	@Autowired
	private InsRiskDutyAPIService insRiskDutyService;

	@Autowired
	private InsInsuranceSlipAPIService insInsuranceSlipService;

	@Override
	public InsUnderwrite initInsUnderwrite(){
		InsUnderwrite insUnderwrite = new InsUnderwrite();
		dao.insert(insUnderwrite);
		return insUnderwrite;
	}

	/**
	 * <b>通过InsInsuranceSlipg获取InsUnderwrite设置到InsInsuranceSlipg </b>
	 * through the InsInsuranceSlipg for InsUnderwrite set up InsInsuranceSlipg
	 * @param iis
	 * @return
	 * @author ZXF
	 * @date 2017年1月7日 上午11:01:19
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void throughTheInsInsuranceSlipForInsUnderwriteSetUpInsInsuranceSlip(InsInsuranceSlip iis){
		if(iis.getUnderwrite() == null){
			return;
		}
		iis.setUnderwrite(dao.selectById(iis.getUnderwrite().getUnderwrite_id()));
	}

	/**
	 * <b>根据Vo更新InsUnderwrite数据 </b>
	 *
	 * @param vo
	 * @author ZXF
	 * @date 2017年1月7日 下午4:26:25
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void accordingToTheUnderwriteVoSetUpInsUnderwrite(UnderwriteVo vo){
		InsUnderwrite insUnderwrite = null;
		if(StrUtil.isNotBlank(vo.getOid())){
			insUnderwrite = dao.selectById(Long.parseLong(vo.getOid()));
		}else{
			insUnderwrite = initInsUnderwrite();
			vo.setOid(insUnderwrite.getUnderwrite_id().toString());
			if(StrUtil.isNotBlank(vo.getIns_insurance_slip_id())){
				InsInsuranceSlip sg = insInsuranceSlipService.selectById(Long.parseLong(vo.getIns_insurance_slip_id()));

				if(null!=sg) {
					sg.setUnderwrite(new InsUnderwrite(insUnderwrite.getUnderwrite_id()));
					insInsuranceSlipService.updateById(sg);
				}
			}
		}
		insUnderwrite.setUnderwrite_time(DateUtil.getTimestamp());
		for(RiskDutyVo rdVo : vo.getRiskDutyVoList()){
			insRiskDutyService.accordingToTheRiskDutyVoSetUpInsRiskDuty(rdVo, insUnderwrite.getUnderwrite_id());
		}
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(vo), insUnderwrite);
		} catch (Exception e) {
			e.printStackTrace();
		}
		dao.updateById(insUnderwrite);
	}

	/**
	 * <b>根据承保信息表 封装到UnderwriteVo </b>
	 * @param insUnderwrite 承保信息表
	 * @return
	 * @author ZXF
	 * @date 2017年1月9日 下午9:59:47
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public UnderwriteVo accordingToInsUnderwriteIntoUnderwriteVo(InsUnderwrite insUnderwrite) {
		UnderwriteVo vo = new UnderwriteVo();
		if(insUnderwrite == null){
			return vo;
		}
		vo.setOid(String.valueOf(insUnderwrite.getUnderwrite_id()));
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(insUnderwrite), vo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		vo.setRiskDutyVoList(insRiskDutyService.selectInsRiskDutyByInsUnderwriteDLLVO(insUnderwrite.getUnderwrite_id()));
		return vo;
	}
}
