package com.bcxin.ins.service.order.impl;

import com.bcxin.ins.dao.order.InsRoleInpolicyAPIDao;
import com.bcxin.ins.service.order.InsInsuranceSlipAPIService;
import com.bcxin.ins.service.order.InsRoleFavoreeAPIService;
import com.bcxin.ins.service.order.InsRoleInpolicyAPIService;
import com.bcxin.ins.entity.policy_core.InsInsuranceSlip;
import com.bcxin.ins.entity.policy_core.InsRoleInpolicy;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.bcxin.ins.vo.*;
import com.bcxin.ins.vo.excel.ResultSetExcelVo;
import com.bcxin.mybatisplus.plugins.Page;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import com.bcxin.mybatisplus.toolkit.IdWorker;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;


/**
 * <b>投保单被保人业务处理 </b>
 * 
 * @author zxf
 * @date 2017年1月5日 上午10:28:33
 * @注意事项 </b>
 * <b>
 */
@Service
@Transactional
public class InsRoleInpolicyAPIServiceImpl extends ServiceImpl<InsRoleInpolicyAPIDao, InsRoleInpolicy> implements InsRoleInpolicyAPIService {


	@Autowired
	private InsRoleInpolicyAPIDao dao;

	@Autowired
	private InsRoleFavoreeAPIService insRoleFavoreeService;

	@Autowired
	private InsInsuranceSlipAPIService insInsuranceSlipService;

	/**
	 * <b>根据投保单id查询投保单被保人列表 </b>
	 *
	 * @param oid
	 * @return
	 * @author ZXF
	 * @date 2017年1月6日 下午4:18:19
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public List<InsRoleInpolicy> selectInsRoleInpolicyByInsInsuranceSlip(Long oid){
		return dao.selectInsRoleInpolicyByInsInsuranceSlip(oid);
	};

	/**
	 * <b>根据投保单id查询投保单被保人列表并做关键字筛选及分页 </b>
	 *
	 * @param page
	 * @param policyId
	 * @param keyword
	 * @return
	 * @author ZXF
	 * @date 2017年8月5日 下午10:40:19
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public List<InsRoleInpolicy> findInsRoleInpolicyByPolicyAndKeywordForPage(DwzPage page, Long policyId, String keyword){
		List<InsRoleInpolicy> roles;
		if(page != null){
			Page<InsRoleInpolicy> pageHelper = new Page(page.getPageNum(), page.getNumPerPage());
			roles = dao.findInsRoleInpolicyByPolicyAndKeywordForPage(pageHelper, policyId, keyword);
			page.setTotalCount(new Long(pageHelper.getTotal()).intValue());
		}else{
			roles = dao.findInsRoleInpolicyByPolicyAndKeywordForPage(policyId, keyword);
		}
		return roles;
	};

	/**
	 * <b>根据投保人id查询相关信息 </b>
	 *
	 * @param oid
	 * @return
	 * @author ZXF
	 * @date 2017年1月6日 下午4:50:59
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public InsRoleInpolicy packagingInsRoleInpolicy(Long oid){
		InsRoleInpolicy insRoleInpolicy = dao.selectById(oid);
		if(insRoleInpolicy != null){
			insRoleInpolicy.setInsRoleFavoreeList(insRoleFavoreeService.selectInsRoleFavoreeByInsRoleInpolicy(insRoleInpolicy.getIns_role_inpolicy_id()));
		}
		return insRoleInpolicy;
	}

	/**
	 * <b>根据投保单id,投保人类型初始化投保人及相关表，相当于new InsRoleInpolicy()</b>
	 *
	 * @param insInsuranceSlip 投保单
	 * @param roleType 角色（个人或企业）
	 * @param kind 角色（投保人或被保人或2者）
	 * @return
	 * @author ZXF
	 * @date 2017年1月6日 下午1:42:10
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public List<InsRoleInpolicy> initInsRoleInpolicy(InsInsuranceSlip insInsuranceSlip, String roleType, String kind){
		List<InsRoleInpolicy> roleLost = new ArrayList<InsRoleInpolicy>();
		InsRoleInpolicy insRoleInpolicy = new InsRoleInpolicy();
		if(ConstProp.APPANDINS.equals(kind)){
			insRoleInpolicy.setKind(ConstProp.ROLE_APPLICANT);
			createRole(insRoleInpolicy, insInsuranceSlip, roleType);
			roleLost.add(insRoleInpolicy);
			insRoleInpolicy = new InsRoleInpolicy();
			insRoleInpolicy.setKind(ConstProp.ROLE_INSURED);
			createRole(insRoleInpolicy, insInsuranceSlip, roleType);
			roleLost.add(insRoleInpolicy);
		}else{
			insRoleInpolicy.setKind(kind);
			createRole(insRoleInpolicy, insInsuranceSlip, roleType);
			roleLost.add(insRoleInpolicy);
		}
		return roleLost;
	}

	@Override
	public void createRole(InsRoleInpolicy insRoleInpolicy, InsInsuranceSlip insInsuranceSlip, String roleType){
		insRoleInpolicy.setRole_type(roleType);
		insRoleInpolicy.getInsurance_slip().setIns_insurance_slip_id(insInsuranceSlip.getIns_insurance_slip_id());
		dao.insert(insRoleInpolicy);
	}

	/**
	 * <b>接收页面传回的投保人/被保人信息列表进行更新 </b>
	 *
	 * @param voList 投保人/被保人信息列表
	 * @param policyID 投保单id
	 * @author ZXF
	 * @date 2017年1月8日 上午11:39:35
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void setRoleInPolicyByRoleCompanyVo(List<RoleSubjectVo> voList, Long policyID){
		if(voList == null || voList.size()<=ConstProp.INT_NUMBER_ZERO){
			return;
		}
		InsInsuranceSlip insInsuranceSlip = new InsInsuranceSlip();
		insInsuranceSlip.setIns_insurance_slip_id(policyID);
		InsRoleInpolicy insRoleInpolicy;
		//已存在记录做修改
		List<InsRoleInpolicy> uRoles = Lists.newArrayList();
		//未存在记录做新增
		List<InsRoleInpolicy> aRoles = Lists.newArrayList();
		for(RoleSubjectVo vo : voList){
			if(StrUtil.isNotBlank(vo.getOid())){
				pushUpdateList(insInsuranceSlip, uRoles, vo);
			}else{
				pushSaveList(insInsuranceSlip, aRoles, vo);
			}
		}
		if(aRoles.size()>0){
			dao.batchInsert(aRoles);
		}
		if(uRoles.size()>0){
			dao.batchUpdate(uRoles);
		}
	}

	/**
	 * <b> 加入要做save的集合 </b>
	 * @author ZXF
	 * @create 2020/09/17 0017 17:59
	 * @version
	 * @注意事项 </b>
	 */
	private void pushSaveList(InsInsuranceSlip insInsuranceSlip, List<InsRoleInpolicy> aRoles, RoleSubjectVo vo) {
		if(!ConstProp.APPANDINS.equals(vo.getKind())){
			InsRoleInpolicy insRoleInpolicy = new InsRoleInpolicy();
			insRoleInpolicy.setKind(vo.getKind());
			insRoleInpolicy.setIns_role_inpolicy_id(IdWorker.getId());
			insRoleInpolicy.setRole_type(vo.getRole_type());
			insRoleInpolicy.getInsurance_slip().setIns_insurance_slip_id(insInsuranceSlip.getIns_insurance_slip_id());
			insRoleInpolicy.setStatus(1);
			setRole(vo, insRoleInpolicy);
			aRoles.add(insRoleInpolicy);
			return;
		}
		List<InsRoleInpolicy> roleList = initInsRoleInpolicy(insInsuranceSlip, vo.getRole_type(), vo.getKind());
		for(InsRoleInpolicy role : roleList){
			updateRole(vo, role);
		}
	}

	/**
	 * <b> 加入要做update的集合 </b>
	 * @author ZXF
	 * @create 2020/09/17 0017 17:59
	 * @version
	 * @注意事项 </b>
	 */
	private void pushUpdateList(InsInsuranceSlip insInsuranceSlip, List<InsRoleInpolicy> uRoles, RoleSubjectVo vo) {
		if(!ConstProp.APPANDINS.equals(vo.getKind())){
			InsRoleInpolicy insRoleInpolicy = new InsRoleInpolicy();
			insRoleInpolicy.setIns_role_inpolicy_id(Long.parseLong(vo.getOid()));
			insRoleInpolicy.setKind(vo.getKind());
			insRoleInpolicy.setRole_type(vo.getRole_type());
			insRoleInpolicy.getInsurance_slip().setIns_insurance_slip_id(insInsuranceSlip.getIns_insurance_slip_id());
			insRoleInpolicy.setStatus(1);
			setRole(vo, insRoleInpolicy);
			uRoles.add(insRoleInpolicy);
			return;
		}
		List<InsRoleInpolicy> roleList = selectInsRoleInpolicyByInsInsuranceSlip(insInsuranceSlip.getIns_insurance_slip_id());
		for(InsRoleInpolicy role : roleList){
			updateRole(vo, role);
		}
	}

	/**
	 * <b>根据Vo及投保单ID更新InsRoleInpolicy数据 </b>
	 *
	 * @param vo
	 * @param insInsuranceSlip 投保单
	 * @author ZXF
	 * @date 2017年1月7日 下午4:26:25
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void accordingToTheRoleSubjectVoSetUpInsRoleInpolicy(RoleSubjectVo vo,InsInsuranceSlip insInsuranceSlip){
		InsRoleInpolicy insRoleInpolicy = null;

		if(StrUtil.isNotBlank(vo.getOid())){
			if(ConstProp.APPANDINS.equals(vo.getKind())){
				List<InsRoleInpolicy> roleList = selectInsRoleInpolicyByInsInsuranceSlip(insInsuranceSlip.getIns_insurance_slip_id());
				for(InsRoleInpolicy role : roleList){
					updateRole(vo, role);
				}
			}else{
				insRoleInpolicy = packagingInsRoleInpolicy(Long.parseLong(vo.getOid()));
				updateRole(vo, insRoleInpolicy);
			}
		}else{
			List<InsRoleInpolicy> roleList = initInsRoleInpolicy(insInsuranceSlip, vo.getRole_type(), vo.getKind());
			for(InsRoleInpolicy role : roleList){
				updateRole(vo, role);
			}
		}
	}

	private void setRole(RoleSubjectVo vo, InsRoleInpolicy insRoleInpolicy) {
		insRoleInpolicy.setName_cn(vo.getName_cn());
		insRoleInpolicy.setName_en(vo.getName_en());
		vo.setKind(insRoleInpolicy.getKind());
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(vo), insRoleInpolicy);
		} catch (Exception e) {
			e.printStackTrace();
		}
		insRoleInpolicy.setApp_business_path(StringUtils.isNotEmpty(vo.getApp_business_path()) ? vo.getApp_business_path() : ConstProp.DIGIT_ZERO);
		insRoleInpolicy.setApp_address_path(StringUtils.isNotEmpty(vo.getApp_address_path()) ? vo.getApp_address_path() : ConstProp.DIGIT_ZERO);
		insRoleInpolicy.setApp_idcard_path(StringUtils.isNotEmpty(vo.getApp_idcard_path()) ? vo.getApp_idcard_path() : ConstProp.DIGIT_ZERO);
		insRoleInpolicy.setApp_organizing_path(StringUtils.isNotEmpty(vo.getApp_organizing_path()) ? vo.getApp_organizing_path() : ConstProp.DIGIT_ZERO);
		insRoleInpolicy.setApp_spouse_card_path(StringUtils.isNotEmpty(vo.getApp_spouse_card_path()) ? vo.getApp_spouse_card_path() : ConstProp.DIGIT_ZERO);
		insRoleInpolicy.setApp_tax_path(StringUtils.isNotEmpty(vo.getApp_tax_path()) ? vo.getApp_tax_path() : ConstProp.DIGIT_ZERO);
		insRoleInpolicy.setApp_trauschein_path(StringUtils.isNotEmpty(vo.getApp_trauschein_path()) ? vo.getApp_trauschein_path() : ConstProp.DIGIT_ZERO);
	}

	private void updateRole(RoleSubjectVo vo, InsRoleInpolicy insRoleInpolicy) {
		insRoleInpolicy.setName_cn(vo.getName_cn());
		insRoleInpolicy.setName_en(vo.getName_en());
		vo.setKind(insRoleInpolicy.getKind());
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(vo), insRoleInpolicy);
		} catch (Exception e) {
			e.printStackTrace();
		}
		insRoleInpolicy.setApp_business_path(StringUtils.isNotEmpty(vo.getApp_business_path()) ? vo.getApp_business_path() : ConstProp.DIGIT_ZERO);
		insRoleInpolicy.setApp_address_path(StringUtils.isNotEmpty(vo.getApp_address_path()) ? vo.getApp_address_path() : ConstProp.DIGIT_ZERO);
		insRoleInpolicy.setApp_idcard_path(StringUtils.isNotEmpty(vo.getApp_idcard_path()) ? vo.getApp_idcard_path() : ConstProp.DIGIT_ZERO);
		insRoleInpolicy.setApp_organizing_path(StringUtils.isNotEmpty(vo.getApp_organizing_path()) ? vo.getApp_organizing_path() : ConstProp.DIGIT_ZERO);
		insRoleInpolicy.setApp_spouse_card_path(StringUtils.isNotEmpty(vo.getApp_spouse_card_path()) ? vo.getApp_spouse_card_path() : ConstProp.DIGIT_ZERO);
		insRoleInpolicy.setApp_tax_path(StringUtils.isNotEmpty(vo.getApp_tax_path()) ? vo.getApp_tax_path() : ConstProp.DIGIT_ZERO);
		insRoleInpolicy.setApp_trauschein_path(StringUtils.isNotEmpty(vo.getApp_trauschein_path()) ? vo.getApp_trauschein_path() : ConstProp.DIGIT_ZERO);
		dao.updateById(insRoleInpolicy);
	}

	/**
	 * <b>根据投保单id查询投保人/被保人信息列表插入到RoleSubjectVo集合 </b>
	 *
	 * @param policyID 投保单id
	 * @author ZXF
	 * @date 2017年1月8日 上午11:39:35
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public List<RoleSubjectVo> getRoleSubjectVoListByPolicyID(Long policyID){
		return dao.selectRoleSubjectVoByInsInsuranceSlip(policyID);
	}

	/**
	 * <b>根据投保人/被保人信息转换成 RoleSubjectVo</b>
	 *
	 * @param role 投保人/被保人
	 * @return
	 * @author ZXF
	 * @date 2017年1月8日 下午2:22:26
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public RoleSubjectVo accordingToInsRoleInpolicyIntoRoleSubjectVo(InsRoleInpolicy role){
		RoleSubjectVo vo = new RoleSubjectVo();
		vo.setName_cn(role.getName_cn());
		vo.setName_en(role.getName_en());
		vo.setOid(String.valueOf(role.getIns_role_inpolicy_id()));
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(role), vo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		vo.setApp_address_path(ConstProp.DIGIT_ZERO.equals(role.getApp_address_path()) ? ConstProp.BLANK_CHAR : role.getApp_address_path());
		vo.setApp_business_path(ConstProp.DIGIT_ZERO.equals(role.getApp_business_path()) ? ConstProp.BLANK_CHAR : role.getApp_business_path());
		vo.setApp_idcard_path(ConstProp.DIGIT_ZERO.equals(role.getApp_idcard_path()) ? ConstProp.BLANK_CHAR : role.getApp_idcard_path());
		vo.setApp_organizing_path(ConstProp.DIGIT_ZERO.equals(role.getApp_organizing_path()) ? ConstProp.BLANK_CHAR : role.getApp_organizing_path());
		vo.setApp_spouse_card_path(ConstProp.DIGIT_ZERO.equals(role.getApp_spouse_card_path()) ? ConstProp.BLANK_CHAR : role.getApp_spouse_card_path());
		vo.setApp_tax_path(ConstProp.DIGIT_ZERO.equals(role.getApp_tax_path()) ? ConstProp.BLANK_CHAR : role.getApp_tax_path());
		vo.setApp_trauschein_path(ConstProp.DIGIT_ZERO.equals(role.getApp_trauschein_path()) ? ConstProp.BLANK_CHAR : role.getApp_trauschein_path());
		return vo;
	}

	/**
	 * <b>根据投保单id查询相关信息 </b>
	 *
	 * @param oid 投保单id
	 * @param kind 投保人/或被保人标识
	 * @return
	 * @author ZXF
	 * @date 2017年1月6日 下午4:50:59
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public List<InsRoleInpolicy> getInsRoleInpolicyListByIDAndKind(Long oid, String kind){
		Map<String,Object> columnMap = Maps.newHashMap();
		columnMap.put("insurance_slip_id", oid);
		columnMap.put("kind", kind);
		List<InsRoleInpolicy> roleList = dao.selectByMap(columnMap);
		return roleList;
	}

	/**
	 * <b>根据投保单id查询被保险人数量 </b>
	 *
	 * @param oid 投保单id
	 * @return
	 * @author ZXF
	 * @date 2017年1月6日 下午4:20:20
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public int countInsurancedByID(Long oid){
		return dao.countInsurancedByID(oid);
	}

	/**
	 * <b>根据订单id查询被保险人列表并生成对应用户记录 </b>
	 *
	 * @param orderID 投保单id
	 * @return
	 * @author ZXF
	 * @date 2017年1月6日 下午4:20:20
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void createUserByRole(Long orderID){
		InsInsuranceSlip insOrderForm = insInsuranceSlipService.selectById(orderID);
		List<InsRoleInpolicy> roleList = dao.getRoleInPolicyByOrderId(insOrderForm.getIns_insurance_slip_id(), "");
		ClientUserVo vo = null;
		List<ClientUserVo> voList = new ArrayList<ClientUserVo>();
		for(InsRoleInpolicy role : roleList){
			if(ConstProp.DIGIT_TWO.equals(role.getKind())){
				vo = new ClientUserVo();
				vo.setId_card(role.getOrganization_code());//证件号码
				vo.setReal_name(role.getName_cn());//被保险人名称
				vo.setTelephone(role.getMobile());//手机号码
				voList.add(vo);
			}
		}
		//TODO 有错误，之后解开该段代码有用
		/*if(voList.size()>0){
			Map<String,String> map = sysUserAPIService.saveSubUser(insOrderForm.getRegister_user_id(),voList);
			if(map != null){
				for(InsRoleInpolicy role : roleList){
					int H = 0;
					if(ConstProp.DIGIT_TWO.equals(role.getKind())){
						String userID = map.get(role.getOrganization_code());
						if(StrUtil.isNotBlank(userID)){
							role.setUser_id(Long.parseLong(userID));
						}else{
							H = 1;
						}
					}else{
						role.setUser_id(insOrderForm.getRegister_user_id());
					}
					if(H == 0){
						dao.updateById(role);
					}
				}
			}
		}*/

	}


	/**
	 * <b>根据订单id删除所有被保险人记录</b>
	 *
	 * @param order_id 订单id
	 * @author ZXF
	 * @date 2016年12月28日 上午11:03:32
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public boolean delectAllInsRole(Long order_id){
		try {
			dao.delectAllInsRole(order_id);
			return true;
		}catch (Exception e){
			return false;
		}
	}

	/**
	 * <b> 根据投保人收录的银行信息转查太保银行信息 </b>
	 * @author ZXF
	 * @create 2024/04/17 0017 10:26
	 * @version
	 * @注意事项 </b>
	 */
	public Map<String,String> getTBBankByOrderId(Long order_id){
		return dao.getTBBankByOrderId(order_id);
	}

	/**
	 * <b> 根据订单id查询团险保障人员列表 </b>
	 * @author ZXF
	 * @create 2019/11/07 0007 14:57
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public List<ResultSetExcelVo> selectRoleInPolicyListByOrderID(Long policyID){
		return dao.selectRoleInPolicyListByOrderID(policyID);
	}

	/**
	 * <b> 查询被保险人转成在保类 </b>
	 * @author ZXF
	 * @create 2020/03/18 0018 13:45
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public InsPreservationResultSetVo setResultSetVo(Long role_id) {
		return dao.setResultSetVo(role_id);
	}

	/**
	 * <b> 获取投保人营业执照地址 </b>
	 * @author ZXF
	 * @create 2020/05/09 0009 16:52
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public String getOrgUrlByOrderID(Long policyID){
		return dao.getOrgUrlByOrderID(policyID);
	}
}
