package com.bcxin.ins.service.order.impl;

import com.bcxin.ins.dao.order.InsRiskDutyAPIDao;
import com.bcxin.ins.service.order.InsAreaAPIService;
import com.bcxin.ins.service.order.InsRiskDutyAPIService;
import com.bcxin.ins.service.order.InsRiskLevelAPIService;
import com.bcxin.ins.service.order.InsUnderwriteAPIService;
import com.bcxin.ins.entity.policy_core.InsUnderwrite;
import com.bcxin.ins.entity.policy_special.StTopBuyers;
import com.bcxin.ins.entity.product_core.ProPrimary;
import com.bcxin.ins.entity.tpost.TposRiskDuty;
import com.bcxin.ins.service.product.InsProductAPIService;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.RiskDutyVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;


/**
 * <b>国家分类承保条件业务处理 </b>
 * 
 * @author zxf
 * @date 2017年1月5日 上午10:28:33
 * @注意事项 </b>
 * <b>
 */
@Service
@Transactional
public class InsRiskDutyAPIServiceImpl extends ServiceImpl<InsRiskDutyAPIDao, TposRiskDuty> implements InsRiskDutyAPIService {

	@Autowired
	private InsRiskDutyAPIDao dao;

	@Autowired
	private InsAreaAPIService insAreaService;

	@Autowired
	private InsRiskLevelAPIService insRiskLevelService;

	@Autowired
	private InsProductAPIService insProductService;

	@Autowired
	private InsUnderwriteAPIService insUnderwriteAPIService;
	/**
	 * <b>通过承保信息表id查询所有国家地区分类等级 </b>
	 *
	 * @param oid
	 * @return
	 * @author ZXF
	 * @date 2017年1月6日 上午10:07:40
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public List<TposRiskDuty> selectInsRiskDutyByInsUnderwrite(Long oid){
		return dao.selectInsRiskDutyByInsUnderwrite(oid);
	}

	/**
	 * 查询所有的等级分类名称
	 * @return
	 */
	@Override
	public List<TposRiskDuty> findAllList() {
		return dao.findAllList();
	}

	/**
	 * <b>通过承保信息表id查询所有国家地区分类等级并封装成VoList </b>
	 *
	 * @param oid
	 * @return
	 * @author ZXF
	 * @date 2017年1月6日 上午10:07:40
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public List<RiskDutyVo> selectInsRiskDutyByInsUnderwriteDLLVO(Long oid){
		List<TposRiskDuty> irdList = selectInsRiskDutyByInsUnderwrite(oid);
		List<RiskDutyVo> rdList = getRiskDutyVoListByInsRiskDutyList(irdList);
		return rdList;
	}

	@Override
	public TposRiskDuty initInsRiskDuty(Long underwrite_id){
		TposRiskDuty insRiskDuty = new TposRiskDuty();
		InsUnderwrite insUnderwrite = insUnderwriteAPIService.selectById(underwrite_id);
		insRiskDuty.setUnderwrite(insUnderwrite);
		dao.insert(insRiskDuty);
		return insRiskDuty;
	}

	/**
	 * <b>根据Vo及承保信息表ID更新InsRiskDuty数据 </b>
	 *
	 * @param vo
	 * @param underwrite_id 承保信息表id
	 * @author ZXF
	 * @date 2017年1月7日 下午4:26:25
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void accordingToTheRiskDutyVoSetUpInsRiskDuty(RiskDutyVo vo,Long underwrite_id){
		TposRiskDuty insRiskDuty = null;
		if(StrUtil.isNotBlank(vo.getOid())){
			insRiskDuty = dao.selectById(Long.parseLong(vo.getOid()));
		}else{
			insRiskDuty = initInsRiskDuty(underwrite_id);
		}
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(vo), insRiskDuty);
		} catch (Exception e) {
			e.printStackTrace();
		}
		dao.updateById(insRiskDuty);
	}

	/**
	 * <b>接收页面传回的国家分类等级列表进行更新 </b>
	 *
	 * @param voList 国家分类等级信息列表
	 * @param underwrite_id 承保信息表id
	 * @author ZXF
	 * @date 2017年1月8日 上午11:39:35
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void setRiskDutyByRiskDutyVo(List<RiskDutyVo> voList, Long underwrite_id){
		if(voList != null && voList.size()> ConstProp.INT_NUMBER_ZERO){
			for(RiskDutyVo vo : voList){
				accordingToTheRiskDutyVoSetUpInsRiskDuty(vo,underwrite_id);
			}
		}
	}

	/**
	 * <b>将国家分类等级列表插入到RiskDutyVo集合 </b>
	 *
	 * @param irdList 国家分类等级列表
	 * @author ZXF
	 * @date 2017年1月8日 上午11:39:35
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public List<RiskDutyVo> getRiskDutyVoListByInsRiskDutyList(List<TposRiskDuty> irdList){
		List<RiskDutyVo> voList = new ArrayList<RiskDutyVo>();
		if(irdList != null && irdList.size()>ConstProp.INT_NUMBER_ZERO){
			for(TposRiskDuty ird : irdList){
				voList.add(accordingToInsRiskDutyIntoRiskDutyVo(ird));
			}
		}
		return voList;
	}

	/**
	 * <b>根据国家分类等级转换成 RiskDutyVo</b>
	 *
	 * @param ird 国家分类等级
	 * @return
	 * @author ZXF
	 * @date 2017年1月8日 下午2:22:26
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public RiskDutyVo accordingToInsRiskDutyIntoRiskDutyVo(TposRiskDuty ird){
		RiskDutyVo vo = new RiskDutyVo();
		if(ird == null){
			return vo;
		}
		vo.setOid(String.valueOf(ird.getTpos_risk_duty_id()));
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(ird), vo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return vo;
	}

	/**
	 * <b>根据前台获取的买家列表查询相应安全等级再获取产品配的安全等级进行筛选只要跟产品存在的安全等级匹配就创建一条InsRiskDuty数据 </b>
	 *
	 * @param tbList
	 * @param underwrite_id
	 * @param insProducts_id
	 * @author ZXF
	 * @date 2017年1月19日 上午11:03:47
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void accordingToInsTopBuyersListGainInsRiskDuty(List<StTopBuyers> tbList , Long underwrite_id , Long insProducts_id){
		ProPrimary insProduct = insProductService.selectById(insProducts_id);
		//判断产品是否录入 国家/地区危险等级分类 信息
		String cg = insProduct.getCountry_area_risk_type();
		if(insProduct == null || StrUtil.isBlank(cg)){
			return;
		}
		List<String> indexOfList = new ArrayList<String>();
		//循环状态为待核保状态获取的某投保单买家
		for(StTopBuyers itb : tbList){
			/**
			 * 根据买家的国家去获取 国家/地区危险等级分类库里的对应危险等级分类
			 */
			String countryCode = insAreaService.accordingToCountryGainCountryCode(itb.getCom_buyer().getCountry());
			if(StrUtil.isBlank(countryCode)){
				continue;
			}
			String countryGroup = insRiskLevelService.accordingToCountryCodeGainCountryGroup(countryCode,String.valueOf(insProduct.getPro_primary_id()));
			if(StrUtil.isBlank(countryGroup)||cg.indexOf(countryGroup)==ConstProp.INT_NUMBER_MINUS_ONE) {
				//如果没找到分类信息/不存在产品危险分类中
				continue;
			}
			if(!indexOfList.contains(countryGroup)){
				//经过排除重复危险等级分类加到空的List中确保每个分类不重复
				indexOfList.add(countryGroup);
			}
		}
		//便利匹配的分类等级创建InsRiskDuty信息
		for(String str : indexOfList){
			TposRiskDuty insRiskDuty = initInsRiskDuty(underwrite_id);
			insRiskDuty.setCountry_area_risk_type(str);
			dao.updateById(insRiskDuty);
		}
	}
}
