package com.bcxin.ins.service.order.impl;

import com.bcxin.ins.dao.order.InsPaymentInfoAPIDao;
import com.bcxin.ins.service.order.InsPaymentInfoAPIService;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.core.entity.SysUser;
import com.bcxin.ins.entity.policy_report.InsPaymentInfo;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.util.enums.IdType;
import com.bcxin.ins.vo.ClientUserVo;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.report_pac.InsPaymentInfoVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;


@Service
@Transactional
public class InsPaymentInfoAPIServiceImpl extends ServiceImpl<InsPaymentInfoAPIDao, InsPaymentInfo> implements InsPaymentInfoAPIService {

	@Autowired
	private InsPaymentInfoAPIDao dao;

	@Override
	public InsPaymentInfo initInsPaymentInfo(Long user_id) {
		InsPaymentInfo insPaymentInfo = new InsPaymentInfo();
//		insPaymentInfo.setClient_type("02");//客户类型,传数字编码(01=被保险人,02=受益人,03=受害人,04=法院,05=被委托人,99=其他)
//		insPaymentInfo.setCollect_pay_approach("02");//收付途径【01=柜面,02=实时,03=批量】
		insPaymentInfo.setCreate_time(new Date());
		insPaymentInfo.setCreate_by(new SysUser(user_id));
		dao.insert(insPaymentInfo);
		return insPaymentInfo;
	}

	/**
	 * <b> 支付信息变更 </b>
	 * @author ZXF
	 * @create 2019/11/20 0020 16:19
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public void saveInsPaymentInfo(InsPaymentInfoVo vo, Long insPaymentInfoID){
		if(vo == null){
			return;
		}
		InsPaymentInfo insPaymentInfo = dao.selectById(insPaymentInfoID);
		try {
			MyConverUtil.map2PoToString(MyConverUtil.PO2Map(vo), insPaymentInfo);
			insPaymentInfo.setUpdate_time(new Date());
		} catch (Exception e) {
			e.printStackTrace();
		}
		dao.updateByIdForManual(insPaymentInfo);
	}

	/**
	 * <b> 支付信息转vo </b>
	 * @author ZXF
	 * @create 2019/11/20 0020 16:20
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public void convertInsPaymentInfoVo(InsPaymentInfoVo vo, InsPaymentInfo insPaymentInfo){
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(insPaymentInfo), vo);
			if(vo.getProvince_name()!=null){
				vo.setBank_address(vo.getProvince_name()+" "+vo.getCity_name());
			}
			if(vo.getBank_account_attribute()!=null){
				vo.setBank_account_attribute_name(ConstProp.DIGIT_ONE.equals(vo.getBank_account_attribute())?"个人账号":"公司账号");
			}
			if(vo.getClient_certificate_type()!=null){
				vo.setClient_certificate_type_name(IdType.convert_value(vo.getClient_certificate_type()).getName());
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * <b> 获取支付信息 </b>
	 * @author ZXF
	 * @create 2019/11/20 0020 16:20
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public InsPaymentInfoVo getInsPaymentInfoVo(Long insPaymentInfoID){
		InsPaymentInfoVo vo = null;
		try {
			InsPaymentInfo insPaymentInfo = dao.selectById(insPaymentInfoID);
			vo = new InsPaymentInfoVo();
			convertInsPaymentInfoVo(vo,insPaymentInfo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return vo;
	}

	/**
	 * <b> 保存赔款到账时间 </b>
	 * @author ZXF
	 * @create 2019/11/27 0027 17:07
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public void savePayDate(String pay_date, Long report_id){
		dao.savePayDate(pay_date,report_id);
	}
}
