package com.bcxin.ins.service.order.impl;

import com.bcxin.ins.dao.order.InsManagerDetailAPIDao;
import com.bcxin.ins.service.order.InsManagerDetailAPIService;
import com.bcxin.ins.entity.policy_special.StCreditManagement;
import com.bcxin.ins.entity.policy_special.StManagerDetail;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.ManagerDetailVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;


@Service
@Transactional
public class InsManagerDetailAPIServiceImpl extends ServiceImpl<InsManagerDetailAPIDao, StManagerDetail> implements InsManagerDetailAPIService {

	@Autowired
	private InsManagerDetailAPIDao dao;
	/**
	 * <b>通过负责信用风险控制和管理人员的详细资料id查询所有负责信用风险控制和管理人员的详细资料 </b>
	 *
	 * @param oid
	 * @return
	 * @author ZXF
	 * @date 2017年1月6日 上午10:07:40
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public List<StManagerDetail> selectInsManagerDetailByInsCreditManagement(Long oid){
		return dao.selectInsManagerDetailByInsCreditManagement(oid);
	}

	/**
	 * <b>根据Vo及公司信用管理表ID更新InsManagerDetail数据 </b>
	 *
	 * @param vo
	 * @param credit_management_id 公司信用管理表id
	 * @author ZXF
	 * @date 2017年1月7日 下午4:26:25
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void accordingToTheManagerDetailVoSetUpInsManagerDetail(ManagerDetailVo vo, Long credit_management_id){
		StManagerDetail insManagerDetail = new StManagerDetail();
		if(StrUtil.isNotBlank(vo.getOid())){
			insManagerDetail = dao.selectById(Long.parseLong(vo.getOid()));
			insManagerDetail.getCredit_management().setSt_credit_management_id(credit_management_id);
		}else{
			StCreditManagement  stCreditManagement = new StCreditManagement();
			insManagerDetail.setCredit_management(stCreditManagement);
			insManagerDetail.getCredit_management().setSt_credit_management_id(credit_management_id);
			dao.insert(insManagerDetail);
		}
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(vo), insManagerDetail);
		} catch (Exception e) {
			e.printStackTrace();
		}
		dao.updateById(insManagerDetail);
	}

	/**
	 * <b>接收页面传回的负责信用风险控制和管理人员的详细资料信息列表进行更新 </b>
	 *
	 * @param voList 负责信用风险控制和管理人员的详细资料信息列表
	 * @param credit_management_id 公司信用管理表id
	 * @author ZXF
	 * @date 2017年1月8日 上午11:39:35
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void setManagerDetailByManagerDetailVo(List<ManagerDetailVo> voList, Long credit_management_id){
		if(voList != null && voList.size()> ConstProp.INT_NUMBER_ZERO){
			for(ManagerDetailVo vo : voList){
				accordingToTheManagerDetailVoSetUpInsManagerDetail(vo,credit_management_id);
			}
		}
	}

	/**
	 * <b>将账龄及坏账分析周期类插入到ManagerDetailVo集合 </b>
	 *
	 * @param mdList 账龄及坏账分析周期表
	 * @author ZXF
	 * @date 2017年1月8日 上午11:39:35
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public List<ManagerDetailVo> getManagerDetailVoListByInsManagerDetailList(List<StManagerDetail> mdList){
		List<ManagerDetailVo> voList = new ArrayList<ManagerDetailVo>();
		if(mdList != null && mdList.size()>ConstProp.INT_NUMBER_ZERO){
			for(StManagerDetail md : mdList){
				voList.add(accordingToInsManagerDetailIntoManagerDetailVo(md));
			}
		}
		return voList;
	}

	/**
	 * <b>根据负责信用风险控制和管理人员的详细资料转换成 ManagerDetailVo</b>
	 *
	 * @param md 负责信用风险控制和管理人员的详细资料
	 * @return
	 * @author ZXF
	 * @date 2017年1月8日 下午2:22:26
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public ManagerDetailVo accordingToInsManagerDetailIntoManagerDetailVo(StManagerDetail md){
		ManagerDetailVo vo = new ManagerDetailVo();
		if(md != null){
			vo.setOid(String.valueOf(md.getSt_manager_detail_id()));
			try {
				MyConverUtil.map2PO(MyConverUtil.PO2Map(md), vo);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		return vo;
	}
}
