package com.bcxin.ins.service.order.impl;


import com.bcxin.ins.dao.order.InsCaseInfoAPIDao;
import com.bcxin.ins.service.order.InsCaseInfoAPIService;
import com.bcxin.ins.core.entity.SysUser;
import com.bcxin.ins.entity.policy_report.InsCaseInfo;
import com.bcxin.ins.util.IdWorker;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.report_pac.InsCaseInfoVo;
import com.bcxin.ins.vo.report_pac.InsCommonReportVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

import java.util.Date;
import java.util.List;
import java.util.Map;


/**
 * <b>雇主责任险雇员特殊字段业务处理 </b>
 * 
 * @author zxf
 * @date 2017年1月5日 上午10:28:33
 * @注意事项 </b>
 * <b>
 */
@Service
@Transactional
public class InsCaseInfoAPIServiceImpl extends ServiceImpl<InsCaseInfoAPIDao, InsCaseInfo> implements InsCaseInfoAPIService {

	@Autowired
	private InsCaseInfoAPIDao dao;

	public InsCaseInfo initInsCaseInfo(Long user_id,Long report_id) {
		InsCaseInfo insCaseInfo = new InsCaseInfo();
		insCaseInfo.setIns_common_report_id(report_id);
		insCaseInfo.setCreate_time(new Date());
		insCaseInfo.setCreate_by(new SysUser(user_id));
		dao.insert(insCaseInfo);
		return insCaseInfo;
	}

	/**
	 * <b>根据Vo及订单ID更新InsCommonReport数据 </b>
	 *
	 * @param vo
	 * @param report_id 报案id
	 * @author ZXF
	 * @create 2019/11/20 0020 16:56
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public void accordingToTheInsCommonReportVoSetUpInsCaseInfo(InsCommonReportVo vo, Long report_id) {
		List<InsCaseInfoVo> hvoList = vo.getCaseInfoVoList();
		InsCaseInfo icf = null;
		List<InsCaseInfo> ahs = Lists.newArrayList();//新增
		List<InsCaseInfo> uhs = Lists.newArrayList();//修改
		try{
			IdWorker idWorker = new IdWorker(ConstProp.INT_NUMBER_WORKERID, ConstProp.INT_NUMBER_ZERO);
			for(InsCaseInfoVo hvo : hvoList){
				if(hvo.isNull()){
					continue;
				}
				if(StringUtils.isNotEmpty(hvo.getIns_case_info_id())){
					icf = new InsCaseInfo();
					icf.setIns_case_info_id(Long.parseLong(hvo.getIns_case_info_id()));
					icf.setIns_common_report_id(report_id);
					try {
						MyConverUtil.map2PO(MyConverUtil.PO2Map(hvo), icf);
					} catch (Exception e) {
						e.printStackTrace();
					}
					uhs.add(icf);
				}else{
					icf = new InsCaseInfo();
					icf.setIns_case_info_id(idWorker.nextId());
					try {
						MyConverUtil.map2PO(MyConverUtil.PO2Map(hvo), icf);
						icf.setIns_common_report_id(report_id);
						icf.setCreate_time(new Date());
						icf.setCreate_by(new SysUser(Long.parseLong(vo.getRegister_user_id())));
						icf.setStatus(0);
					} catch (Exception e) {
						e.printStackTrace();
					}
					ahs.add(icf);
				}
			}
			if(ahs.size()>0){
				dao.batchInsert(ahs);
			}
			if(uhs.size()>0){
				dao.batchUpdate(uhs);
			}
		}catch (Exception e){
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			e.printStackTrace();
		}

	}

	/**
	 * <b>获取InsCommonReportVo根据报案id查询附件信息插入到InsCommonReportVo </b>
	 *
	 * @param vo 报案辅助表
	 * @param report_id 报案id
	 * @author ZXF
	 * @date 2017年1月8日 上午11:39:35
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void getInsCommonReportVoByReportID(InsCommonReportVo vo, Long report_id){
		List<InsCaseInfoVo> list = dao.selectInsCaseInfoVoByReportId(report_id);
		int count = 0;
		if(list != null){
			if(list.size()<3){
				count = list.size();
			}else{
				count = 100;
			}
		}
		if(count == 100){
			for(int i = count;i<3;i++){
				list.add(new InsCaseInfoVo());
			}
		}
		vo.setCaseInfoVoList(list);
	}

	/**
	 * 根据id删除报案成功案件信息
	 * @param oid 报案成功案件信息id
	 * @return
	 */
	@Override
	public boolean delectInsCaseInfoByOid(Long oid){
		try {
			dao.deleteById(oid);
			return true;
		}catch (Exception e){
			return false;
		}
	}

	/**
	 * 根据id删除报案成功案件信息
	 * @param oid 报案id
	 * @return
	 */
	@Override
	public boolean delectAllInsCaseInfo(Long oid){
		try {
			Map<String, Object> map = Maps.newHashMap();
			map.put("ins_common_report_id",oid);
			dao.deleteByMap(map);
			return true;
		}catch (Exception e){
			return false;
		}
	}
}
