package com.bcxin.ins.service.order.impl;

import com.bcxin.ins.dao.order.InsBadAnalysisAPIDao;
import com.bcxin.ins.service.order.InsBadAnalysisAPIService;
import com.bcxin.ins.entity.policy_special.StBadAnalysis;
import com.bcxin.ins.entity.policy_special.StBadDebt;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.bcxin.ins.vo.BadAnalysisVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;


@Service
@Transactional
public class InsBadAnalysisAPIServiceImpl extends ServiceImpl<InsBadAnalysisAPIDao, StBadAnalysis> implements InsBadAnalysisAPIService {

	@Autowired
	private InsBadAnalysisAPIDao dao;
	/**
	 * <b>通过账龄及坏账分析id查询所有坏账分析 </b>
	 *
	 * @param oid
	 * @return
	 * @author ZXF
	 * @date 2017年1月6日 上午10:07:40
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public List<StBadAnalysis> selectInsBadAnalysisByInsBadDebt(Long oid){
		return dao.selectInsBadAnalysisByInsBadDebt(oid);
	}

	/**
	 * <b>根据Vo及短期出口ID更新InsBadAnalysis数据 </b>
	 *
	 * @param vo
	 * @param bad_debt_id 账龄及坏账分析表id
	 * @author ZXF
	 * @date 2017年1月7日 下午4:26:25
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void accordingToTheBadAnalysisVoSetUpInsBadAnalysis(BadAnalysisVo vo, Long bad_debt_id){
		StBadAnalysis insBadAnalysis = null;
		if(StrUtil.isNotBlank(vo.getOid())){
			insBadAnalysis = dao.selectById(Long.parseLong(vo.getOid()));
		}else{
			insBadAnalysis = new StBadAnalysis();
			StBadDebt stBadDebt = new StBadDebt();
			insBadAnalysis.setBad_debt(stBadDebt);
			insBadAnalysis.getBad_debt().setSt_bad_debt_id(bad_debt_id);
			dao.insert(insBadAnalysis);
		}
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(vo), insBadAnalysis);
		} catch (Exception e) {
			e.printStackTrace();
		}
		dao.updateById(insBadAnalysis);
	}

	/**
	 * <b>接收页面传回的坏账分析信息列表进行更新 </b>
	 *
	 * @param voList 坏账分析信息列表
	 * @param bad_debt_id 账龄及坏账分析表id
	 * @author ZXF
	 * @date 2017年1月8日 上午11:39:35
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void setBadAnalysisByBadAnalysisVo(List<BadAnalysisVo> voList, Long bad_debt_id){
		if(voList != null && voList.size()>0){
			for(BadAnalysisVo vo : voList){
				accordingToTheBadAnalysisVoSetUpInsBadAnalysis(vo,bad_debt_id);
			}
		}
	}

	/**
	 * <b>将坏账分析交互辅助类插入到BadAnalysisVo集合 </b>
	 *
	 * @param ibaList 坏账分析交互辅助类
	 * @author ZXF
	 * @date 2017年1月8日 上午11:39:35
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public List<BadAnalysisVo> getBadAnalysisVoListByInsBadAnalysisList(List<StBadAnalysis> ibaList){
		List<BadAnalysisVo> voList = new ArrayList<BadAnalysisVo>();
		if(ibaList != null && ibaList.size()>0){
			for(StBadAnalysis iba : ibaList){
				voList.add(accordingToInsBadAnalysisIntoBadAnalysisVo(iba));
			}
		}
		return voList;
	}

	/**
	 * <b>根据坏账分析交互辅助类信息转换成 BadAnalysisVo</b>
	 *
	 * @param iba 坏账分析交互辅助类
	 * @return
	 * @author ZXF
	 * @date 2017年1月8日 下午2:22:26
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public BadAnalysisVo accordingToInsBadAnalysisIntoBadAnalysisVo(StBadAnalysis iba){
		BadAnalysisVo vo = new BadAnalysisVo();
		vo.setOid(String.valueOf(iba.getSt_bad_analysis_id()));
		if(iba != null){
			try {
				MyConverUtil.map2PO(MyConverUtil.PO2Map(iba), vo);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		return vo;
	}
}
