package com.bcxin.ins.service.order.impl;

import com.bcxin.ins.dao.order.InsAgreementAPIDao;
import com.bcxin.ins.service.order.InsAgreementAPIService;
import com.bcxin.ins.service.order.InsInsuranceSlipAPIService;
import com.bcxin.ins.entity.policy_core.InsAgreement;
import com.bcxin.ins.entity.policy_core.InsInsuranceSlip;
import com.bcxin.ins.service.product.InsProductResponsibilityAPIService;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.vo.InsurePolicyVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;


/**
 * <b>保单主表业务处理 </b>
 * 
 * @author zxf
 * @date 2017年1月5日 上午10:28:33
 * @注意事项 </b>
 * <b>
 */
@Service
@Transactional
public class InsAgreementAPIServiceImpl extends ServiceImpl<InsAgreementAPIDao, InsAgreement> implements InsAgreementAPIService {



	@Autowired
	private InsInsuranceSlipAPIService insInsuranceSlipService;

	@Autowired
	private InsProductResponsibilityAPIService insProductResponsibilityAPIService;
	@Autowired
	private InsAgreementAPIDao dao;

	public InsAgreement initAgreement(){
		InsAgreement insAgreement = new InsAgreement();
		dao.insert(insAgreement);
		return insAgreement;
	}

	/**
	 * <b>查询保单信息根据保单id </b>
	 *原：getInsAgreementgExtendsParent
	 * @param oid 保单id
	 * @return
	 * @author ZXF
	 * @date 2017年1月5日 下午3:54:36
	 * @注意事项 </b>
	 * <b>
	 */
	public InsAgreement selectById(Long oid){
		return dao.selectById(oid);
	}

	/**
	 * <b>通过投保定单id查询保单信息 </b>
	 *原：selectInsAgreementgByInsInsuranceSlipg
	 * @param insurance_slip_id 投保单id
	 * @return
	 * @author ZXF
	 * @date 2017年1月5日 下午3:54:36
	 * @注意事项 </b>
	 * <b>
	 */
	public InsAgreement selectInsAgreementByInsInsuranceSlip(Long insurance_slip_id){
		return dao.selectInsAgreementByInsInsuranceSlip(insurance_slip_id);
	}

	/**
	 * <b>将InsurePolicyVo转换成保单信息 </b>
	 *原：willInsurePolicyVoChangeIntoInsAgreementg
	 * @param insurance_slip_id 投保定单id
	 * @return
	 * @author ZXF
	 * @date 2017年1月5日 下午3:54:36
	 * @注意事项 </b>
	 * <b>
	 */
	public void willInsurePolicyVoChangeIntoInsAgreement(Long insurance_slip_id,String externalReference){
		InsAgreement insAgreement = selectInsAgreementByInsInsuranceSlip(insurance_slip_id);
		if(insAgreement == null){
			insAgreement = initAgreement();
		}
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(insurance_slip_id);
		InsurePolicyVo vo = insInsuranceSlipService.willInsInsuranceSlipChangeIntoInsurePolicyVo(insurance_slip_id);
		String responsibility_ids = insProductResponsibilityAPIService.findResponsibilityIdsByProductID(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()),insInsuranceSlip.getIs_contain_repo());
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(vo), insAgreement);
		} catch (Exception e) {
			e.printStackTrace();
		}
		//固化保障责任细项
		insAgreement.setResponsibility_ids(responsibility_ids);

		insAgreement.setExternal_reference(externalReference);
		insAgreement.setPro_primary(insInsuranceSlip.getPro_primary());
		insAgreement.setIns_insurance_slip(insInsuranceSlip);
		dao.updateById(insAgreement);
	}

	/**
	 * <b> 临时方法，用于批量补偿固化保障责任细项 如果有订单id只补偿该订单 </b>
	 * @author ZXF
	 * @create 2023/12/29 0029 10:49
	 * @version
	 * @注意事项 </b>
	 */
	public void updateResponsibilityIds(String productCode,String orderId){
		List<OrderFormVo> forms = Lists.newArrayList();
		if(StringUtils.isNotEmpty(orderId)){
			OrderFormVo orderFormVo = insInsuranceSlipService.findOrderFormVoByID(Long.parseLong(orderId));
			forms.add(orderFormVo);
		}else{
			if(StringUtils.isEmpty(productCode)){
				throw new RuntimeException("productCode不能为空");
			}
			forms = insInsuranceSlipService.selectInsOrderFormByStatusAndProductCode("6", productCode);
		}
		for(OrderFormVo vo : forms){
			InsAgreement insAgreement = selectInsAgreementByInsInsuranceSlip(Long.parseLong(vo.getOid()));
			if(insAgreement == null){
				continue;
			}
			//固化保障责任细项
			insAgreement.setResponsibility_ids(insProductResponsibilityAPIService.findResponsibilityIdsByProductID(vo.getProduct_oid(),vo.getIs_contain_repo()));
			dao.updateById(insAgreement);
		}
	}
}
