package com.bcxin.ins.service.order.impl;

import com.bcxin.ins.dao.order.ComRegionAPIDao;
import com.bcxin.ins.service.order.ComRegionAPIService;
import com.bcxin.ins.entity.common.ComRegion;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.*;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;


@Service
@Transactional(readOnly = true)
public class ComRegionAPIServiceImpl extends ServiceImpl<ComRegionAPIDao, ComRegion> implements ComRegionAPIService {


	
	@Autowired
	private ComRegionAPIDao dao;

	@Override
	public Map<String, String> findDistrict(String codeLevel, String parentCode) {
		Map<String, String> map = null;
		List<ComRegion> list = dao.findRegionList("","","",codeLevel,parentCode);
		if(list != null&& list.size()>0){
			map = new LinkedHashMap<String, String>();
			for (ComRegion Region : list) {
				map.put(Region.getCodes(), Region.getNamed());
			}
		}
		return map;
	}

	@Override
	public List<ComRegion> findRegionList(String name) {
		List<ComRegion> list = null;
		if(StrUtil.isNotBlank(name)){
			list = dao.findRegionList(name,"","","","");
		}
		return list;
	}

	@Override
	public List<ComRegion> findRegionListByLevel(String level, String name) {
		return dao.findRegionList(name,"","",level,"");
	}

	@Override
	public List<ComRegion> findDistrictByParentCode(String codeLevel, String parentCode) {
		return dao.findRegionList("","","",codeLevel,parentCode);
	}

	/**
	 * 通过传入省市区代码返回省市区中文组装字符串（如：福建省厦门市集美区）
	 * @param pro
	 * @param cit
	 * @param are
	 * @return
	 */
	public String getRegionName(String pro, String cit, String are){
		String result = "";
		ComRegion region = null;
		if(StringUtils.isNotEmpty(pro)){
			region = findDistrictByCode("",pro);
			if(region != null){
				result = result + region.getNamed();
			}
		}
		if(StringUtils.isNotEmpty(cit)){
			region = findDistrictByCode("",cit);
			if(region != null){
				result = result + region.getNamed();
			}
		}
		if(StringUtils.isNotEmpty(are)){
			region = findDistrictByCode("",are);
			if(region != null){
				result = result + region.getNamed();
			}
		}
		return result;
	}

	@Override
	public ComRegion findDistrictByCode(String kind, String code) {
		List<ComRegion> list = null;
		if(StrUtil.isNotBlank(code)){
			try {
				list = dao.findRegionList("",code,kind,"","");
			}catch (Exception e){
				e.printStackTrace();
			}
			if(list != null&& list.size()>0){
				return list.get(0);
			}
		}
		return null;
	}

	@Override
	public void initSystemDDL(String fileUrl) {
		try(BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(fileUrl),"UTF-8"));) {
			String line;
			int i = 0;
			while ((line = br.readLine()) != null) {
				int j = 0;
				ComRegion ddl = new ComRegion();
				String[] data = new String[8];

				System.out.println("第" + i + "行	：");
				StringTokenizer sk = new StringTokenizer(line, ",", false);
				while(sk.hasMoreTokens()) {
					String value = (String) sk.nextElement();
					data[j] = value;
					j++;
				}
				i++;
				ComRegion cs = findDistrictByCode("", data[0]);
				if(cs != null){
					return;
				}
				ddl.setCodes(data[0]);
				ddl.setCode_level(data[1]);
				ddl.setKind(data[2]);
				ddl.setParent_id(data[3]);
				ddl.setNamed(data[4]);

				dao.updateById(ddl);
			}
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

}
