package com.bcxin.ins.service.order;


import com.bcxin.ins.entity.policy_core.InsInsuranceSlip;
import com.bcxin.ins.entity.policy_core.InsTransaction;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.PolicyTransactionVo;
import com.bcxin.ins.vo.TransactionVo;
import com.bcxin.mybatisplus.service.IService;

import java.util.List;


public interface InsTransactionAPIService extends IService<InsTransaction> {
	
	public List<InsTransaction> selectInsTransactionByInsOrderForm(Long oid);

	public InsTransaction initInsTransaction();
	
	public List<TransactionVo> packagingTransactionVoListByInsTransactionList(List<InsTransaction> itList);
	
	public void accordingToTheTransactionVoSetUpInsTransaction(TransactionVo vo, Long insTransaction_id);
	
	public TransactionVo accordingToInsTransactionIntoTransactionVo(InsTransaction insTransaction);
	
	public void setOrderFormVoOfShowUrlByOrderID(OrderFormVo vo, Long order_id);
	
	public void uploadPayMentFileToTranction(String path_url, InsInsuranceSlip order, String path_sign, String payAmount, String paymentMethod);

	public String accordingToOrderIDGainPathSign(String order_id);

	public InsTransaction getTranctionByorderIDAndStatus(Long order_id);


	void saveTransaction(PolicyTransactionVo vo);

	void updateTransationMsg(PolicyTransactionVo vo);

	void savePolicyOther(PolicyTransactionVo vo);

	/**
	 * 更新交易表
	 * @param vo
	 */
	void updateTransaction(PolicyTransactionVo vo);

	void savePolicyExternalReference(PolicyTransactionVo vo);

	/**
	 * 保存保单(用于承保后支付状态的订单业务)
	 * 修改订单状态为承保后支付  orderstatus 16
	 * @param vo
	 */
	void savePolicyExternalReference_16(PolicyTransactionVo vo);

	void savePolicyExternalReferenceToDB(PolicyTransactionVo vo);

	void otherCZ(Long order_id, Long pro_id);
}
