package com.bcxin.ins.service.order;


import com.bcxin.ins.entity.policy_core.InsInsuranceSlip;
import com.bcxin.ins.entity.policy_core.InsRoleInpolicy;
import com.bcxin.ins.vo.DwzPage;
import com.bcxin.ins.vo.InsPreservationResultSetVo;
import com.bcxin.ins.vo.RoleSubjectVo;
import com.bcxin.ins.vo.excel.ResultSetExcelVo;
import com.bcxin.mybatisplus.service.IService;

import java.util.List;
import java.util.Map;


public interface InsRoleInpolicyAPIService extends IService<InsRoleInpolicy> {
	
	public List<InsRoleInpolicy> selectInsRoleInpolicyByInsInsuranceSlip(Long oid);

	public List<InsRoleInpolicy> findInsRoleInpolicyByPolicyAndKeywordForPage(DwzPage page, Long policyId, String keyword);
	
	public InsRoleInpolicy packagingInsRoleInpolicy(Long oid);

	public void createRole(InsRoleInpolicy insRoleInpolicy, InsInsuranceSlip insInsuranceSlip, String roleType);

	public List<InsRoleInpolicy> initInsRoleInpolicy(InsInsuranceSlip insInsuranceSlip, String roleType, String kind);

	public void setRoleInPolicyByRoleCompanyVo(List<RoleSubjectVo> voList, Long policyID);

	public void accordingToTheRoleSubjectVoSetUpInsRoleInpolicy(RoleSubjectVo vo, InsInsuranceSlip insInsuranceSlip);

	public RoleSubjectVo accordingToInsRoleInpolicyIntoRoleSubjectVo(InsRoleInpolicy role);

	public List<RoleSubjectVo> getRoleSubjectVoListByPolicyID(Long policyID);

	public List<InsRoleInpolicy> getInsRoleInpolicyListByIDAndKind(Long oid, String kind);

	public int countInsurancedByID(Long oid);

	public void createUserByRole(Long orderID);

	public boolean delectAllInsRole(Long order_id);

	/**
	 * <b> 根据投保人收录的银行信息转查太保银行信息 </b>
	 * @author ZXF
	 * @create 2024/04/17 0017 10:26
	 * @version
	 * @注意事项 </b>
	 */
	public Map<String,String> getTBBankByOrderId(Long order_id);

	/**
	 * <b> 根据订单id查询团险保障人员列表 </b>
	 * @author ZXF
	 * @create 2019/11/07 0007 14:57
	 * @version
	 * @注意事项 </b>
	 */
	public List<ResultSetExcelVo> selectRoleInPolicyListByOrderID(Long policyID);

	/**
	 * <b> 查询被保险人转成在保类 </b>
	 * @author ZXF
	 * @create 2020/03/18 0018 13:45
	 * @version
	 * @注意事项 </b>
	 */
	public InsPreservationResultSetVo setResultSetVo(Long role_id);

	/**
	 * <b> 获取投保人营业执照地址 </b>
	 * @author ZXF
	 * @create 2020/05/09 0009 16:52
	 * @version
	 * @注意事项 </b>
	 */
	public String getOrgUrlByOrderID(Long policyID);
}
