package com.bcxin.ins.service.order;


import com.bcxin.ins.entity.policy_report.InsCommonReport;
import com.bcxin.ins.vo.DwzPage;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.ResultDto;
import com.bcxin.ins.vo.report_pac.InsCommonReportVo;
import com.bcxin.mybatisplus.service.IService;

import java.util.List;
import java.util.Map;

public interface InsCommonReportAPIService extends IService<InsCommonReport> {

	/**
	 * <b> SAAS App保存理赔信息 </b>
	 * @author ZXF
	 * @create 2019/11/19 0019 14:55
	 * @version
	 * @注意事项 </b>
	 */
	public ResultDto saveInsCommonReportByApp(InsCommonReportVo vo,Long user_id);

	/**
	 * <b> saas图片地址上传平安ibos平台激活fileId </b>
	 * @author ZXF
	 * @create 2020/06/29 0029 16:22
	 * @version
	 * @注意事项 </b>
	 */
	String getFileIdByPath(String path, String sign);

	/**
	 * <b> 保存理赔信息 </b>
	 * @author ZXF
	 * @create 2019/11/19 0019 14:55
	 * @version
	 * @注意事项 </b>
	 */
	public ResultDto saveInsCommonReport(InsCommonReportVo vo,Long user_id);

	/**
	 * <b> 长安理赔查询 </b>
	 * @author ZXF
	 * @create 2021/04/13 0013 9:41
	 * @version
	 * @注意事项 </b>
	 */
	public void getCACaseById(InsCommonReportVo vo, Long report_id);

	/**
	 * <b> 太保理赔查询 </b>
	 * @author ZXF
	 * @create 2021/04/13 0013 9:41
	 * @version
	 * @注意事项 </b>
	 */
	public void getTBCaseById(InsCommonReportVo vo, Long report_id);

	/**
	 * <b> 理赔审批信息查询(请求平安接口) </b>
	 * 当报案传统为已归档
	 * @author ZXF
	 * @create 2019/11/27 0027 14:14
	 * @version
	 * @注意事项 </b>
	 */
	public void getCaseById(InsCommonReportVo vo, Long report_id);

	/**
	 * <b> 根据id查询报案结果 </b>
	 * @author ZXF
	 * @create 2019/11/19 0019 14:41
	 * @version
	 * @注意事项 </b>
	 */
	public InsCommonReportVo getInsCommonReportVoById(Long oid);

	public InsCommonReportVo getInsCommonReportVoInfoById(Long oid,int sign);

	/**
	 * <b> 附件补传 </b>
	 * @author ZXF
	 * @create 2019/11/29 0029 13:45
	 * @version
	 * @注意事项 </b>
	 */
	public ResultDto saveUploadFile(InsCommonReportVo vo);

	/**
	 * 根据id删除报案申请数据
	 * @param oid 雇员id
	 * @return
	 */
	public boolean delectInsCommonReportByOid(Long oid);

	/**
	 * <b> 根据订单id 查询报案列表</b>
	 * @author ZXF
	 * @create 2019/11/19 0019 14:37
	 * @version
	 * @注意事项 </b>
	 */
	public List<InsCommonReportVo> selectInsCommonReportVoListByOrderID(String keyword, String status, String startDate, String endDate, Long user_id, DwzPage page);

	public List<Map<String,String>> selectReportListByIdCardNo(String status, String saasIdCardNo);

	public String sendApi(String oid) throws Exception;

	public void findXXReportDetails();

	/**
	 * <b> 请求接口获取报案数据，保存到数据库 </b>
	 * @author ZXF
	 * @create 2020/04/27 0027 14:55
	 * @version
	 * @注意事项 </b>
	 */
	public boolean task_loadAndSetXXReport(Long userId, String policyNos);

	/**
	 * <b> 长安请求接口获取报案数据，保存到数据库(定时任务处理用) </b>
	 * @param userId 用户id
	 * @param policyNos 保单号列（多个"#"号隔开）
	 * @author ZXF
	 * @create 2020/04/27 0027 14:55
	 * @version
	 * @注意事项 </b>
	 */
	boolean task_loadAndSetCAXXReport(Long userId, String policyNos);

	/**
	 * <b> 通过aspose，生成doc初稿 </b>
	 * @author ZXF
	 * @create 2020/06/08 0008 11:14
	 * @version
	 * @注意事项 </b>
	 */
	public String draftWord(Long reportId);

	/**
	 * <b> 通过aspose，生成doc初稿 </b>
	 * @author ZXF
	 * @create 2020/06/08 0008 11:14
	 * @version
	 * @注意事项 </b>
	 */
	public String draft(InsCommonReportVo vo, OrderFormVo orderVo);

}
