package com.bcxin.ins.service.inf.impl;

import com.bcxin.ins.dao.inf.InformAPIMapper;
import com.bcxin.ins.service.inf.InformAPIService;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.core.entity.PageResult;
import com.bcxin.ins.core.entity.R;
import com.bcxin.ins.core.util.DOM;
import com.bcxin.ins.core.util.SysUserUtils;
import com.bcxin.ins.entity.common.ComInform;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.vo.ClientUserVo;
import com.bcxin.ins.vo.ComInformUserVo;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import com.bcxin.mybatisplus.toolkit.IdWorker;
import com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * <b> 公告业务 </b>
 * @author ZXF
 * @create 2018/07/31 0031 17:20
 * @version
 * @注意事项 </b>
 */
@Service
@Transactional
public class InformAPIServiceImpl extends ServiceImpl<InformAPIMapper, ComInform> implements InformAPIService {
    private static Logger log = LoggerFactory.getLogger(InformAPIServiceImpl.class);

    @Autowired
    private InformAPIMapper infM;

    /**
     * 根据当前时间查询公告记录
     */
    @Override
    public R queryNowTime() {
        List<ComInform> ciList = infM.queryNowTime(DateUtil.getCurrentDateTime());
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        List<ComInform> sList = Lists.newArrayList();
        List<ComInformUserVo> voList = Lists.newArrayList();
        ComInformUserVo vo = null;
        for(ComInform c : ciList){
            if(ConstProp.DIGIT_ONE.equals(c.getExecute_type())){//每次都提醒的
                sList.add(c);
            }else if(ConstProp.DIGIT_TWO.equals(c.getExecute_type())){//单次
                if(userdetail == null){
                    return new R(false,"暂无公告");
                }
                int count = infM.getReadByUAndI(Long.parseLong(userdetail.getOid()),c.getCom_inform_id());
                if(count == 0){
                    sList.add(c);
                    vo = new ComInformUserVo();
                    vo.setCiuID(String.valueOf(IdWorker.getId()));
                    vo.setUserID(userdetail.getOid());
                    vo.setInformID(String.valueOf(c.getCom_inform_id()));
                    voList.add(vo);
                    vo = null;
                }
            }
        }
        if(sList.size() > 0){
            if(voList.size()>0){
                infM.insertCIU(voList);
            }
            return new R(true,sList);
        }else{
            return new R(false,"暂无公告");
        }
    }

    /**
     * 公告列表查询
     *
     * @param p
     */
    @Override
    public PageResult query(Map<Object, Object> p) {
        return new PageResult(infM.queryCnt(p),infM.query(p));
    }

    /**
     * 新增公告记录
     *
     * @param p
     */
    @Override
    public R add(Map<Object, Object> p) {
        try{

            //插入公告
            ComInform  mpr = (ComInform) DOM.mtd(p,new ComInform()); //保存用户，弱数据安全，如果用户知道字段，可以插入其他字段
            mpr.setCom_inform_id(null); //保护ID
            mpr.setCreate_time(new Date());
            mpr.setCreate_by(SysUserUtils.getUser());
            mpr.setUpdate_time(new Date());
            mpr.setUpdate_by(SysUserUtils.getUser());
            insert(mpr);

            return new R(true,"操作成功");
        } catch (Exception e) {
            log.error("新增公告记录，事务发现异常，回滚数据",e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new R(false,"操作失败");
        }
    }

    /**
     * 修改公告信息
     *
     * @param p
     */
    @Override
    public R upd(Map<Object, Object> p) {
        try{
            //修改公告信息
            ComInform  mpr =  DOM.mtd(p,new ComInform()); //保存用户，弱数据安全，如果用户知道字段，可以插入其他字段
            mpr.setUpdate_time(new Date());
            mpr.setUpdate_by(SysUserUtils.getUser());
            updateById(mpr);

            return new R(true,"操作成功");
        } catch (Exception e) {
            log.error("修改公告信息，事务发现异常，回滚数据",e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new R(false,"操作失败");
        }

    }

    /**
     * 删除公告信息
     *
     * @param p
     */
    @Override
    public R del(Map<Object, Object> p) {
        try{
            //删除公告信息
            deleteById(Long.valueOf(String.valueOf(p.get("com_inform_id"))));
            return new R(true,"操作成功");
        } catch (Exception e) {
            log.error("新增用户，事务发现异常，回滚数据",e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new R(false,"操作失败");
        }

    }

}