package com.bcxin.ins.service.common.impl;

import com.bcxin.ins.dao.common.SysClientUserContractCMapper;
import com.bcxin.ins.dao.common.SysClientUserPostMapper;
import com.bcxin.ins.service.common.SysClientUserContractCService;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.core.entity.R;
import com.bcxin.ins.core.util.DOM;
import com.bcxin.ins.entity.user.SysClientUserContractC;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

import java.util.Date;
import java.util.Map;

@Service
@Transactional
public class SysClientUserContractCServiceImpl extends ServiceImpl<SysClientUserContractCMapper, SysClientUserContractC> implements SysClientUserContractCService {
	private static Logger log = LoggerFactory.getLogger(SysClientUserContractCServiceImpl.class);

	@Autowired
	private SysClientUserPostMapper sysClientUserPostMapper;

	@Override
	public R add(Map<Object, Object> p) {
		try{
			SysClientUserContractC row = (SysClientUserContractC)DOM.mtd(p,new SysClientUserContractC());
			row.setCreate_by(Long.valueOf(UserSupportUtil.getSessionUser().getOid()));
			row.setCreate_time(new Date());
			this.insert(row);
			return new R(true,"操作成功");
		} catch (Exception e) {
			log.error("新增常用投保人错误，事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			return new R(false,"操作失败");
		}
	}

	@Override
	public R upd(Map<Object, Object> p) {
		try{
			SysClientUserContractC row = (SysClientUserContractC) DOM.mtd(p,new SysClientUserContractC());
			row.setUpdate_by(Long.valueOf(UserSupportUtil.getSessionUser().getOid()));
			row.setUpdate_time(new Date());
			this.updateById(row);
			return new R(true,"操作成功");
		} catch (Exception e) {
			log.error("修改常用投保人错误，事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			return new R(false,"操作失败");
		}
	}

	@Override
	public R del(Map<Object, Object> p) {
		try{
			SysClientUserContractC row = new SysClientUserContractC();
			row.setSys_client_user_contract_c_id(Long.valueOf(String.valueOf(p.get("sys_client_user_contract_c_id"))));
			row.setStatus(2);
			this.updateById(row);
			return new R(true,"操作成功");
		} catch (Exception e) {
			log.error("删除常用投保人错误，事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			return new R(false,"操作失败");
		}
	}


}
