package com.bcxin.ins.dao.order;

import com.bcxin.ins.entity.policy_core.InsTransaction;
import com.bcxin.ins.spring.annotation.MyBatisDao;
import com.bcxin.mybatisplus.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;


/**
 * <b>交易表数据访问 </b>
 * 
 * @author zxf
 * @date 2017年1月5日 上午10:43:31
 * @注意事项 </b>
 * <b>
 */
@MyBatisDao
public interface InsTransactionAPIDao extends BaseMapper<InsTransaction> {

	public InsTransaction selectById(@Param("id") Long id);
	
	/**
	 * <b>订单id查询所有交易详细信息 </b> 
	 * 
	 * @param oid
	 * @return
	 * @author ZXF 
	 * @date 2017年1月6日 上午10:07:40
	 * @注意事项 </b>
	 * <b>
	 */
	public List<InsTransaction> selectInsTransactionByInsOrderForm(@Param("oid") Long oid);

	/**
	 * <b>根据订单id及上传标识查找交易信息 </b> 
	 * 
	 * @param path_sign
	 * @return
	 * @author ZXF 
	 * @date 2017年1月17日 下午5:27:07
	 * @注意事项 </b>
	 * <b>
	 */
	public InsTransaction selectInsTranctionByOrderIDAndSign(@Param("oid") Long oid,
                                                             @Param("path_sign") String path_sign);
}
