package com.bcxin.ins.dao.order;

import com.bcxin.ins.entity.policy_special.StTopBuyers;
import com.bcxin.ins.spring.annotation.MyBatisDao;
import com.bcxin.ins.vo.BuyersVo_two;
import com.bcxin.ins.vo.DwzPage;
import com.bcxin.ins.vo.TopBuyersVo;
import com.bcxin.mybatisplus.mapper.BaseMapper;
import com.bcxin.mybatisplus.plugins.Page;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@MyBatisDao
public interface InsTopBuyersAPIDao extends BaseMapper<StTopBuyers> {

	public StTopBuyers selectById(@Param("id") Long id);
	
	/**
	 * <b>根据id查询 InsTopBuyers</b> 
	 * 
	 * @param oid ins_top_buyers_id
	 * @return
	 * @author ZXF 
	 * @date 2017年1月5日 下午5:28:44
	 * @注意事项 </b>
	 * <b>
	 */
	public StTopBuyers getInsTopBuyers(@Param("oid") Long oid);
	
	/**
	 * <b>通过企业短期id查询所有关联买家 </b> 
	 * 
	 * @param oid
	 * @return
	 * @author ZXF 
	 * @date 2017年1月5日 下午4:59:37
	 * @注意事项 </b>
	 * <b>
	 */
	public List<StTopBuyers> selectInsTopBuyersBySpecialID(@Param("oid") Long oid);


	/**
	 * <b>查询所有卖家  剔除本保单的 买家</b> 
	 * 
	 * @param phPage
	 * @param topBuyersVo
	 * @return
	 * @author liyongqiang
	 * @date 2017年1月16日 下午8:13:36
	 * @注意事项 </b>
	 * <b>
	 */
	public List<StTopBuyers> findTopBuyers(Page<StTopBuyers> phPage, @Param("topBuyersVo") TopBuyersVo topBuyersVo);

	
	/**
	 * 根据订单ID获取该订单下所有的买家<br>
	 * @author liumd
	 * @date 2017年1月16日
	 */
	public List<StTopBuyers> getInsTopBuyersByOrderFormId(Page<StTopBuyers> page, @Param("orderFormId") Long orderFormId);
	
	public List<BuyersVo_two> getBuyersVoTwoByOrderFormId(Page<BuyersVo_two> page, @Param("orderFormId") Long orderFormId);

	public List<TopBuyersVo> findTopBuyersOrder(DwzPage page, @Param("oid") Long id);

	public TopBuyersVo getBuyersVoById(@Param("oid") Long oid);

	/**
	 * 根据某个订单下所有的买家   (分页加 自定义搜搜)<br>
	 */
	public List<StTopBuyers> selectInsTopBuyersListBySpecialID(Page<StTopBuyers> page, @Param("topBuyersVo") TopBuyersVo topBuyersVo);
	
	/**  根据订单ID,搜索输入的国家，搜索输入的公司获取该订单下所有的买家*/
	public List<BuyersVo_two> findBuyersListByOrderFormIdAndSearch(Page<BuyersVo_two> page, @Param("orderFormId") Long orderFormId, @Param("countrySearch") String countrySearch, @Param("companySearch") String companySearch);

	/**
	 * <b> 查询批复条数 </b> 
	 * 
	 * @param userId
	 * @return
	 * @author liyongqiang
	 * @date 2017年1月24日 下午1:49:54
	 * @注意事项 </b>
	 * <b>
	 */
	public Long getInsTopBuyerPifu(Long userId);

	/**
	 * <b>查询 未批复条数 </b> 
	 * 
	 * @param userId
	 * @return
	 * @author liyongqiang
	 * @date 2017年1月24日 下午1:50:10
	 * @注意事项 </b>
	 * <b>
	 */
	public Long getInsTopBuyerWPifu(Long userId);

	/**
	 * <b>未批复列表 </b> 
	 * 
	 * @param userId
	 * @return
	 * @author liyongqiang
	 * @date 2017年1月24日 下午2:50:00
	 * @注意事项 </b>
	 * <b>
	 */
	public List<TopBuyersVo> findNoPifuList(Page<TopBuyersVo> page, Long userId);

	/**
	 * <b>已批复列表 </b> 
	 * 
	 * @param userId
	 * @return
	 * @author liyongqiang
	 * @date 2017年1月24日 下午2:50:20
	 * @注意事项 </b>
	 * <b>
	 */
	public List<TopBuyersVo> findPifuList(Page<TopBuyersVo> page, Long userId);

	/**
	 * <b>查询该买家是否可以添加信用额度 </b>
	 *
	 * <b>
	 */
	Long findTopBuyersBySerach(@Param("country") String country, @Param("city") String city, @Param("customer_name") String customer_name, @Param("spid") String spid, @Param("oid") String oid);
}
