package com.bcxin.ins.dao.order;

import com.bcxin.ins.entity.policy_special.Hireling;
import com.bcxin.ins.spring.annotation.MyBatisDao;
import com.bcxin.ins.vo.HirelingVo;
import com.bcxin.ins.vo.excel.ResultSetExcelVo;
import com.bcxin.mybatisplus.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;


/**
 * <b>雇主责任险雇员特殊字段表数据访问 </b>
 * 
 * @author zxf
 * @date 2017年1月5日 上午10:43:31
 * @注意事项 </b>
 * <b>
 */
@MyBatisDao
public interface HirelingAPIDao extends BaseMapper<Hireling> {

    List<HirelingVo> selectHirelingVoByOrderId(@Param("order_id") Long order_id);

    void batchInsert(@Param("list") List<Hireling> list);
    void batchUpdate(@Param("list") List<Hireling> list);

    /**
     * <b> 根据订单id查询雇主保障人员列表，用ResultSetExcelVo对象接收 </b>
     * @author ZXF
     * @create 2019/11/07 0007 14:50
     * @version
     * @注意事项 </b>
     */
    List<ResultSetExcelVo> selectHirelingListByOrderID(@Param("order_id") Long order_id);
}
