/*
 * Decompiled with CFR 0.152.
 */
package com.pingan.iobs.sdk.storage;

import com.pingan.iobs.sdk.auth.AuthException;
import com.pingan.iobs.sdk.common.Config;
import com.pingan.iobs.sdk.common.IOBSException;
import com.pingan.iobs.sdk.http.Client;
import com.pingan.iobs.sdk.model.Response;
import com.pingan.iobs.sdk.util.Auth;
import java.io.UnsupportedEncodingException;

public class DownloadManager {
    private String SERVICE_PATH = "/download";
    private Client client = Client.getInstance();

    public Response download(String url) throws IOBSException {
        return this.client.download(url);
    }

    public Response downloadPublic(String bucket, String key) throws UnsupportedEncodingException, IOBSException {
        String url = this.downloadPublicUrl(bucket, key);
        return this.client.download(url);
    }

    public Response downloadPrivate(String bucket, String key) throws UnsupportedEncodingException, IOBSException, AuthException {
        String signedUrl = this.generateSignedUrl(bucket, key);
        return this.client.download(signedUrl);
    }

    public String generateSignedUrl(String bucket, String key) throws AuthException {
        String url = this.downloadPublicUrl(bucket, key);
        String signedUrl = Auth.authorization(url);
        return signedUrl;
    }

    public String generateSignedUrl(String bucket, String key, String attName) throws AuthException {
        String url = this.downloadPublicUrl(bucket, key);
        String signedUrl = Auth.authorization(url);
        if (attName == null) {
            return signedUrl;
        }
        return signedUrl + "&attname=" + attName;
    }

    public String downloadPublicUrl(String bucket, String key) {
        StringBuffer sb = new StringBuffer();
        sb.append(Config.HOST).append(this.SERVICE_PATH).append("/").append(bucket).append("/").append(key);
        return sb.toString();
    }

    public String downloadPublicUrl(String bucket, String key, String attName) {
        StringBuffer sb = new StringBuffer();
        sb.append(Config.HOST).append(this.SERVICE_PATH).append("/").append(bucket).append("/").append(key);
        if (attName != null) {
            sb.append("?attname=").append(attName);
        }
        return sb.toString();
    }
}

