/*
 * Decompiled with CFR 0.152.
 */
package com.pingan.iobs.sdk.storage;

import com.pingan.iobs.sdk.auth.AuthException;
import com.pingan.iobs.sdk.auth.UrlSafeBase64;
import com.pingan.iobs.sdk.common.Config;
import com.pingan.iobs.sdk.common.IOBSException;
import com.pingan.iobs.sdk.http.Client;
import com.pingan.iobs.sdk.model.Response;
import com.pingan.iobs.sdk.util.Auth;
import java.io.UnsupportedEncodingException;

public class DeleteManager {
    private String SERVICE_PATH = "/delete";
    private Client client = Client.getInstance();

    public Response delete(String bucket, String key) throws UnsupportedEncodingException, IOBSException, AuthException {
        String signedUrl = this.generateSignedUrl(bucket, key);
        return this.client.delete(signedUrl);
    }

    public String generateSignedUrl(String bucket, String key) throws UnsupportedEncodingException, AuthException {
        String url = this.baseDeleteUrl(bucket, key);
        String signedUrl = Auth.authorization(url);
        return signedUrl;
    }

    public Response delete(String signedUrl) throws IOBSException {
        return this.client.get(signedUrl);
    }

    public String baseDeleteUrl(String bucket, String key) throws UnsupportedEncodingException {
        StringBuffer sb = new StringBuffer();
        String encodedEntryURI = this.encodeBucketKey(bucket, key);
        sb.append(Config.HOST).append(this.SERVICE_PATH).append("/").append(encodedEntryURI);
        return sb.toString();
    }

    private String encodeBucketKey(String bucket, String key) throws UnsupportedEncodingException {
        return UrlSafeBase64.encodeToString(bucket + ":" + key);
    }
}

