/*
 * Decompiled with CFR 0.152.
 */
package com.pingan.iobs.sdk.service;

import com.pingan.iobs.sdk.model.Response;
import com.pingan.iobs.sdk.service.IobsService;
import com.pingan.iobs.sdk.util.EncryptAndDncrypt;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class IobsServiceDecorator
extends IobsService {
    private EncryptAndDncrypt encryptAndDncrypt;

    public IobsServiceDecorator(EncryptAndDncrypt encryptAndDncrypt) {
        this.encryptAndDncrypt = encryptAndDncrypt;
    }

    public Response uploadEncryptBigFile(String bucket, String key, File file, String passWord) throws Exception {
        File cacheFile = this.getCacheFile(bucket, file, passWord);
        Response resp = this.upload(bucket, key, cacheFile);
        cacheFile.deleteOnExit();
        return resp;
    }

    public Response uploadEncryptBigFile(String bucket, String key, File file, String token, String passWord) throws Exception {
        File cacheFile = this.getCacheFile(bucket, file, passWord);
        Response resp = this.upload(bucket, key, cacheFile, token);
        cacheFile.deleteOnExit();
        return resp;
    }

    public Response uploadStreamEncryptBigFile(String bucket, String key, InputStream ins, String fileName, String passWord) throws Exception {
        File cahefile = this.encryptAndDncrypt.cacheEncryptFile(ins, bucket, fileName);
        return this.uploadEncryptBigFile(bucket, key, cahefile, passWord);
    }

    public Response uploadStreamEncryptBigFile(String bucket, String key, InputStream ins, String fileName, String token, String passWord) throws Exception {
        File cahefile = this.encryptAndDncrypt.cacheEncryptFile(ins, bucket, fileName);
        return this.uploadEncryptBigFile(bucket, key, cahefile, token, passWord);
    }

    private File getCacheFile(String bucket, File file, String passWord) throws Exception {
        InputStream cacheIn = this.encryptAndDncrypt.encryptFile(file, passWord);
        return this.encryptAndDncrypt.cacheEncryptFile(cacheIn, bucket, file.getName());
    }

    public Response uploadEncrypt(String bucket, String key, File file, String passWord) throws Exception {
        InputStream ins = this.encryptAndDncrypt.encryptFile(file, passWord);
        return super.uploadStream(bucket, key, ins, file.getName(), 0L);
    }

    public Response uploadEncrypt(String bucket, String key, InputStream ins, String fileName, String passWord) throws Exception {
        InputStream in = this.encryptAndDncrypt.encryptInputStream(ins, passWord);
        return super.uploadStream(bucket, key, in, fileName, 0L);
    }

    public InputStream downloadDncrypt(String bucket, String key, String passWord) {
        Response resp = this.downloadPrivateRs(bucket, key);
        try {
            return this.encryptAndDncrypt.decryptInputStream(resp.downloadFileStream(), passWord);
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public InputStream downloadDncryptByUrl(String url, String passWord) {
        Response resp = this.download(url);
        try {
            return this.encryptAndDncrypt.decryptInputStream(resp.downloadFileStream(), passWord);
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public File downloadDncryptFile(String bucket, String key, File destFile, String passWord) throws FileNotFoundException, IOException {
        return this.encryptAndDncrypt.stream2file(this.downloadDncrypt(bucket, key, passWord), destFile);
    }

    public File downloadDncryptFileByUrl(String url, String passWord, File destFile) {
        try {
            return this.encryptAndDncrypt.stream2file(this.downloadDncryptByUrl(url, passWord), destFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

