/*
 * Decompiled with CFR 0.152.
 */
package com.pingan.iobs.sdk.repkg.org.apache.http.client.protocol;

import com.pingan.iobs.sdk.repkg.org.apache.http.Header;
import com.pingan.iobs.sdk.repkg.org.apache.http.HeaderIterator;
import com.pingan.iobs.sdk.repkg.org.apache.http.HttpException;
import com.pingan.iobs.sdk.repkg.org.apache.http.HttpResponse;
import com.pingan.iobs.sdk.repkg.org.apache.http.HttpResponseInterceptor;
import com.pingan.iobs.sdk.repkg.org.apache.http.annotation.Immutable;
import com.pingan.iobs.sdk.repkg.org.apache.http.client.CookieStore;
import com.pingan.iobs.sdk.repkg.org.apache.http.client.protocol.HttpClientContext;
import com.pingan.iobs.sdk.repkg.org.apache.http.cookie.Cookie;
import com.pingan.iobs.sdk.repkg.org.apache.http.cookie.CookieOrigin;
import com.pingan.iobs.sdk.repkg.org.apache.http.cookie.CookieSpec;
import com.pingan.iobs.sdk.repkg.org.apache.http.cookie.MalformedCookieException;
import com.pingan.iobs.sdk.repkg.org.apache.http.protocol.HttpContext;
import com.pingan.iobs.sdk.repkg.org.apache.http.util.Args;
import java.io.IOException;
import java.util.List;

@Immutable
public class ResponseProcessCookies
implements HttpResponseInterceptor {
    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Args.notNull(response, "HTTP request");
        Args.notNull(context, "HTTP context");
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        CookieSpec cookieSpec = clientContext.getCookieSpec();
        if (cookieSpec == null) {
            return;
        }
        CookieStore cookieStore = clientContext.getCookieStore();
        if (cookieStore == null) {
            return;
        }
        CookieOrigin cookieOrigin = clientContext.getCookieOrigin();
        if (cookieOrigin == null) {
            return;
        }
        HeaderIterator it = response.headerIterator("Set-Cookie");
        this.processCookies(it, cookieSpec, cookieOrigin, cookieStore);
        if (cookieSpec.getVersion() > 0) {
            it = response.headerIterator("Set-Cookie2");
            this.processCookies(it, cookieSpec, cookieOrigin, cookieStore);
        }
    }

    private void processCookies(HeaderIterator iterator, CookieSpec cookieSpec, CookieOrigin cookieOrigin, CookieStore cookieStore) {
        while (iterator.hasNext()) {
            Header header = iterator.nextHeader();
            try {
                List<Cookie> cookies = cookieSpec.parse(header, cookieOrigin);
                for (Cookie cookie : cookies) {
                    try {
                        cookieSpec.validate(cookie, cookieOrigin);
                        cookieStore.addCookie(cookie);
                    }
                    catch (MalformedCookieException ex) {}
                }
            }
            catch (MalformedCookieException ex) {
            }
        }
    }

    private static String formatCooke(Cookie cookie) {
        StringBuilder buf = new StringBuilder();
        buf.append(cookie.getName());
        buf.append("=\"");
        String v = cookie.getValue();
        if (v != null) {
            if (v.length() > 100) {
                v = v.substring(0, 100) + "...";
            }
            buf.append(v);
        }
        buf.append("\"");
        buf.append(", version:");
        buf.append(Integer.toString(cookie.getVersion()));
        buf.append(", domain:");
        buf.append(cookie.getDomain());
        buf.append(", path:");
        buf.append(cookie.getPath());
        buf.append(", expiry:");
        buf.append(cookie.getExpiryDate());
        return buf.toString();
    }
}

