/*
 * Decompiled with CFR 0.152.
 */
package com.pingan.iobs.sdk.repkg.org.apache.http.client.protocol;

import com.pingan.iobs.sdk.repkg.org.apache.http.HttpException;
import com.pingan.iobs.sdk.repkg.org.apache.http.HttpHost;
import com.pingan.iobs.sdk.repkg.org.apache.http.HttpRequest;
import com.pingan.iobs.sdk.repkg.org.apache.http.HttpRequestInterceptor;
import com.pingan.iobs.sdk.repkg.org.apache.http.annotation.Immutable;
import com.pingan.iobs.sdk.repkg.org.apache.http.auth.AuthProtocolState;
import com.pingan.iobs.sdk.repkg.org.apache.http.auth.AuthScheme;
import com.pingan.iobs.sdk.repkg.org.apache.http.auth.AuthScope;
import com.pingan.iobs.sdk.repkg.org.apache.http.auth.AuthState;
import com.pingan.iobs.sdk.repkg.org.apache.http.auth.Credentials;
import com.pingan.iobs.sdk.repkg.org.apache.http.client.AuthCache;
import com.pingan.iobs.sdk.repkg.org.apache.http.client.CredentialsProvider;
import com.pingan.iobs.sdk.repkg.org.apache.http.client.protocol.HttpClientContext;
import com.pingan.iobs.sdk.repkg.org.apache.http.conn.routing.RouteInfo;
import com.pingan.iobs.sdk.repkg.org.apache.http.protocol.HttpContext;
import com.pingan.iobs.sdk.repkg.org.apache.http.util.Args;
import java.io.IOException;

@Immutable
public class RequestAuthCache
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        AuthScheme authScheme;
        AuthScheme authScheme2;
        AuthState targetState;
        Args.notNull(request, "HTTP request");
        Args.notNull(context, "HTTP context");
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        AuthCache authCache = clientContext.getAuthCache();
        if (authCache == null) {
            return;
        }
        CredentialsProvider credsProvider = clientContext.getCredentialsProvider();
        if (credsProvider == null) {
            return;
        }
        RouteInfo route = clientContext.getHttpRoute();
        if (route == null) {
            return;
        }
        HttpHost target = clientContext.getTargetHost();
        if (target == null) {
            return;
        }
        if (target.getPort() < 0) {
            target = new HttpHost(target.getHostName(), route.getTargetHost().getPort(), target.getSchemeName());
        }
        if ((targetState = clientContext.getTargetAuthState()) != null && targetState.getState() == AuthProtocolState.UNCHALLENGED && (authScheme2 = authCache.get(target)) != null) {
            this.doPreemptiveAuth(target, authScheme2, targetState, credsProvider);
        }
        HttpHost proxy = route.getProxyHost();
        AuthState proxyState = clientContext.getProxyAuthState();
        if (proxy != null && proxyState != null && proxyState.getState() == AuthProtocolState.UNCHALLENGED && (authScheme = authCache.get(proxy)) != null) {
            this.doPreemptiveAuth(proxy, authScheme, proxyState, credsProvider);
        }
    }

    private void doPreemptiveAuth(HttpHost host, AuthScheme authScheme, AuthState authState, CredentialsProvider credsProvider) {
        String schemeName = authScheme.getSchemeName();
        AuthScope authScope = new AuthScope(host, AuthScope.ANY_REALM, schemeName);
        Credentials creds = credsProvider.getCredentials(authScope);
        if (creds != null) {
            if ("BASIC".equalsIgnoreCase(authScheme.getSchemeName())) {
                authState.setState(AuthProtocolState.CHALLENGED);
            } else {
                authState.setState(AuthProtocolState.SUCCESS);
            }
            authState.update(authScheme, creds);
        }
    }
}

