/*
 * Decompiled with CFR 0.152.
 */
package com.pingan.iobs.sdk.repkg.org.apache.http.client.methods;

import com.pingan.iobs.sdk.repkg.org.apache.http.ProtocolVersion;
import com.pingan.iobs.sdk.repkg.org.apache.http.RequestLine;
import com.pingan.iobs.sdk.repkg.org.apache.http.annotation.NotThreadSafe;
import com.pingan.iobs.sdk.repkg.org.apache.http.client.config.RequestConfig;
import com.pingan.iobs.sdk.repkg.org.apache.http.client.methods.AbstractExecutionAwareRequest;
import com.pingan.iobs.sdk.repkg.org.apache.http.client.methods.Configurable;
import com.pingan.iobs.sdk.repkg.org.apache.http.client.methods.HttpUriRequest;
import com.pingan.iobs.sdk.repkg.org.apache.http.message.BasicRequestLine;
import com.pingan.iobs.sdk.repkg.org.apache.http.params.HttpProtocolParams;
import java.net.URI;

@NotThreadSafe
public abstract class HttpRequestBase
extends AbstractExecutionAwareRequest
implements HttpUriRequest,
Configurable {
    private ProtocolVersion version;
    private URI uri;
    private RequestConfig config;

    @Override
    public abstract String getMethod();

    public void setProtocolVersion(ProtocolVersion version) {
        this.version = version;
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return this.version != null ? this.version : HttpProtocolParams.getVersion(this.getParams());
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public RequestLine getRequestLine() {
        String method = this.getMethod();
        ProtocolVersion ver = this.getProtocolVersion();
        URI uri = this.getURI();
        String uritext = null;
        if (uri != null) {
            uritext = uri.toASCIIString();
        }
        if (uritext == null || uritext.length() == 0) {
            uritext = "/";
        }
        return new BasicRequestLine(method, uritext, ver);
    }

    @Override
    public RequestConfig getConfig() {
        return this.config;
    }

    public void setConfig(RequestConfig config) {
        this.config = config;
    }

    public void setURI(URI uri) {
        this.uri = uri;
    }

    public void started() {
    }

    public void releaseConnection() {
        this.reset();
    }

    public String toString() {
        return this.getMethod() + " " + this.getURI() + " " + this.getProtocolVersion();
    }
}

