/*
 * Decompiled with CFR 0.152.
 */
package com.pingan.iobs.sdk.auth;

import com.pingan.iobs.core.util.SecretKeyUtils;
import com.pingan.iobs.sdk.auth.AuthException;
import com.pingan.iobs.sdk.auth.EncodeUtils;
import com.pingan.iobs.sdk.auth.JavaBase64;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.spec.SecretKeySpec;

public class Mac {
    public String accessKey;
    public String secretKey;

    public Mac(String accessKey, String secretKey) {
        this.accessKey = accessKey;
        this.secretKey = secretKey;
    }

    public String signByServer(byte[] data) throws AuthException {
        return this.sign(data, false);
    }

    public String signBySdk(byte[] data) throws AuthException {
        return this.sign(data, true);
    }

    private String sign(byte[] data, boolean isSdk) throws AuthException {
        try {
            javax.crypto.Mac jcMac = javax.crypto.Mac.getInstance("HmacSHA1");
            jcMac.init(new SecretKeySpec(this.makeSecretKeyWithSHA(isSdk), "HmacSHA1"));
            return this.accessKey + ":" + EncodeUtils.urlsafeEncodeString(jcMac.doFinal(data));
        }
        catch (InvalidKeyException e) {
            throw new AuthException("invalid key!", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AuthException("no algorithm called HmacSHA1!", e);
        }
        catch (Exception e) {
            throw new AuthException("base 64 error!", e);
        }
    }

    private byte[] makeSecretKeyWithSHA(boolean isSdk) throws Exception {
        if (isSdk) {
            return SecretKeyUtils.getSKWithSecretaryByte(this.secretKey);
        }
        return JavaBase64.decryptBASE64(this.secretKey);
    }

    public String signWithDataByServer(byte[] data) throws AuthException {
        return this.signWithData(data, false);
    }

    public String signWithDataBySdk(byte[] data) throws AuthException {
        return this.signWithData(data, true);
    }

    private String signWithData(byte[] data, boolean isSdk) throws AuthException {
        try {
            byte[] accessKey = this.accessKey.getBytes();
            byte[] policyBase64 = EncodeUtils.urlsafeEncodeBytes(data);
            javax.crypto.Mac jcMac = javax.crypto.Mac.getInstance("HmacSHA1");
            jcMac.init(new SecretKeySpec(this.makeSecretKeyWithSHA(isSdk), "HmacSHA1"));
            byte[] digestBase64 = EncodeUtils.urlsafeEncodeBytes(jcMac.doFinal(policyBase64));
            byte[] token = new byte[accessKey.length + 30 + policyBase64.length];
            System.arraycopy(accessKey, 0, token, 0, accessKey.length);
            token[accessKey.length] = 58;
            System.arraycopy(digestBase64, 0, token, accessKey.length + 1, digestBase64.length);
            token[accessKey.length + 29] = 58;
            System.arraycopy(policyBase64, 0, token, accessKey.length + 30, policyBase64.length);
            return new String(token);
        }
        catch (Exception e) {
            throw new AuthException("Fail to sign with data!", e);
        }
    }
}

