/*
 * Decompiled with CFR 0.152.
 */
package com.pingan.iobs.core.model.request;

import com.google.gson.Gson;
import com.pingan.iobs.core.auth.UrlSafeBase64;
import com.pingan.iobs.core.cache.UserBucketCacheManager;
import com.pingan.iobs.core.exception.IobsCoreException;
import com.pingan.iobs.core.model.Bucket;
import com.pingan.iobs.core.model.Context;
import com.pingan.iobs.core.model.request.BaseDownloadRequestParam;
import com.pingan.iobs.core.model.request.BputRequestParam;
import com.pingan.iobs.core.model.request.DownloadRequestParam;
import com.pingan.iobs.core.model.request.FileMetadataRequestParam;
import com.pingan.iobs.core.model.request.ImageViewRequestParam;
import com.pingan.iobs.core.model.request.MediaOpRequestParam;
import com.pingan.iobs.core.model.request.MkblkRequestParam;
import com.pingan.iobs.core.model.request.MkfileRequestParam;
import com.pingan.iobs.core.model.request.UploadRequestParam;
import java.io.InputStream;
import javax.servlet.ServletInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class RequestParamFactory {
    private static final Log log = LogFactory.getLog(RequestParamFactory.class);
    @Autowired
    private UserBucketCacheManager cacheManager;

    public DownloadRequestParam newDownloadRequestParam(String bucket, String key, String attName, Long e, String token) throws IobsCoreException {
        Bucket bucketInfo = this.getBucketFromCache(bucket);
        DownloadRequestParam requestParam = new DownloadRequestParam(bucketInfo, key, attName, e, token);
        return requestParam;
    }

    public FileMetadataRequestParam newFileMetadataRequestParam(String encodedEntryURI, Long e, String token) throws IobsCoreException {
        DecodedEntryURI decodedEntryURI = this.toDecodedEntryURI(encodedEntryURI);
        Bucket bucketInfo = this.getBucketFromCache(decodedEntryURI.bucket);
        FileMetadataRequestParam requestParam = new FileMetadataRequestParam(bucketInfo, decodedEntryURI.key, e, token);
        return requestParam;
    }

    public BaseDownloadRequestParam newBaseDownloadRequestParam(String encodedEntryURI, Long e, String token) throws IobsCoreException {
        DecodedEntryURI decodedEntryURI = this.toDecodedEntryURI(encodedEntryURI);
        Bucket bucketInfo = this.getBucketFromCache(decodedEntryURI.bucket);
        BaseDownloadRequestParam requestParam = new BaseDownloadRequestParam(bucketInfo, decodedEntryURI.key, e, token);
        return requestParam;
    }

    public BaseDownloadRequestParam newBaseDownloadRequestParam(String bucket, String key, Long e, String token) throws IobsCoreException {
        Bucket bucketInfo = this.getBucketFromCache(bucket);
        BaseDownloadRequestParam requestParam = new BaseDownloadRequestParam(bucketInfo, key, e, token);
        return requestParam;
    }

    public ImageViewRequestParam newImageViewRequestParam(String bucket, String key, Long e, String token) throws IobsCoreException {
        Bucket bucketInfo = this.getBucketFromCache(bucket);
        ImageViewRequestParam requestParam = new ImageViewRequestParam(bucketInfo, key, e, token);
        return requestParam;
    }

    public UploadRequestParam newUploadRequestParam(String bucket, String key, MultipartFile file, String token, String persistentOps, String persistentNotifyUrl) throws IobsCoreException {
        Bucket bucketInfo = this.getBucketFromCache(bucket);
        UploadRequestParam requestParam = new UploadRequestParam(bucketInfo, key, file, token, persistentOps, persistentNotifyUrl);
        return requestParam;
    }

    public UploadRequestParam newUploadRequestParam(String bucket, MultipartFile file, String token, String persistentOps, String persistentNotifyUrl) throws IobsCoreException {
        Bucket bucketInfo = this.getBucketFromCache(bucket);
        UploadRequestParam requestParam = new UploadRequestParam(bucketInfo, file, token, persistentOps, persistentNotifyUrl);
        return requestParam;
    }

    public MediaOpRequestParam newMediaOpRequestParam(String bucket, String key, String fops, String notifyURL, String token) throws IobsCoreException {
        Bucket bucketInfo = this.getBucketFromCache(bucket);
        MediaOpRequestParam requestParam = new MediaOpRequestParam(bucketInfo, key, fops, notifyURL, token);
        return requestParam;
    }

    public MkblkRequestParam newMkblkRequestParam(String bucket, String key, ServletInputStream inputStream, String blockIndex, String token) throws IobsCoreException {
        Bucket bucketInfo = this.getBucketFromCache(bucket);
        return new MkblkRequestParam(bucketInfo, key, (InputStream)inputStream, blockIndex, token);
    }

    public MkblkRequestParam newMkblkRequestParam(String bucket, String key, ServletInputStream inputStream, String blockIndex, String token, String md5) throws IobsCoreException {
        Bucket bucketInfo = this.getBucketFromCache(bucket);
        return new MkblkRequestParam(bucketInfo, key, (InputStream)inputStream, blockIndex, token, md5);
    }

    public BputRequestParam newBputRequestParam(String bucket, String key, ServletInputStream inputStream, String encodedCtxJson, int offset, String token) throws IobsCoreException {
        Bucket bucketInfo = this.getBucketFromCache(bucket);
        String ctxJson = new String(UrlSafeBase64.decode((String)encodedCtxJson));
        Context ctx = (Context)new Gson().fromJson(ctxJson, Context.class);
        return new BputRequestParam(bucketInfo, key, inputStream, ctx, offset, token);
    }

    public MkfileRequestParam newMkfileRequestParam(String bucket, String key, Long fileSize, String fileName, String md5, String token) throws IobsCoreException {
        Bucket bucketInfo = this.getBucketFromCache(bucket);
        return new MkfileRequestParam(bucketInfo, key, fileSize, fileName, md5, token);
    }

    private Bucket getBucketFromCache(String bucketName) throws IobsCoreException {
        Bucket bucketInfo = this.cacheManager.getUserBucketWrapper().findBucketByName(bucketName);
        if (bucketInfo == null) {
            throw new IobsCoreException(612, bucketName + ":this bucket cache not exist!");
        }
        return bucketInfo;
    }

    private DecodedEntryURI toDecodedEntryURI(String encodedEntryURI) throws IobsCoreException {
        DecodedEntryURI decodedEntryURI = null;
        try {
            String bucketAndKey = new String(UrlSafeBase64.decode((String)encodedEntryURI));
            String bucket = bucketAndKey.split(":")[0];
            String key = bucketAndKey.split(":")[1];
            decodedEntryURI = new DecodedEntryURI(bucket, key);
        }
        catch (Exception e) {
            throw new IobsCoreException(400, e.getMessage(), e);
        }
        return decodedEntryURI;
    }

    private class DecodedEntryURI {
        public String bucket;
        public String key;

        public DecodedEntryURI(String bucket, String key) {
            this.bucket = bucket;
            this.key = key;
        }
    }
}

