/*
 * Decompiled with CFR 0.152.
 */
package com.pingan.iobs.core.model;

import com.pingan.iobs.core.auth.UrlSafeBase64;
import com.pingan.iobs.core.exception.IobsCoreException;

public class PutResult {
    private String bucket;
    private String key;
    private String hash;

    public PutResult(String bucket, String key) {
        this.bucket = bucket;
        this.key = key;
    }

    public PutResult(String bucket, String key, String hash) {
        this(bucket, key);
        this.hash = hash;
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public static PutResult toFileObject(String encodedEntryURI) throws IobsCoreException {
        PutResult resourceLocateDTO = null;
        try {
            String bucket2key = new String(UrlSafeBase64.decode((String)encodedEntryURI));
            String bucket = bucket2key.split(":")[0];
            String key = bucket2key.split(":")[1];
            resourceLocateDTO = new PutResult(bucket, key);
        }
        catch (Exception e) {
            throw new IobsCoreException(400, e.getMessage(), e);
        }
        return resourceLocateDTO;
    }
}

