/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.rest.web.commons;

import com.bcxin.Infrastructures.exceptions.ConflictTenantException;
import com.bcxin.Infrastructures.exceptions.DataOperationTenantException;
import com.bcxin.Infrastructures.exceptions.ForbidTenantException;
import com.bcxin.Infrastructures.exceptions.NotAllowedTenantException;
import com.bcxin.Infrastructures.exceptions.NotFoundTenantException;
import com.bcxin.Infrastructures.exceptions.TenantExceptionAbstract;
import com.bcxin.Infrastructures.exceptions.UnAuthorizedTenantException;
import com.bcxin.Infrastructures.utils.ExceptionUtil;
import com.bcxin.rest.web.commons.ResponseBuilder;
import com.bcxin.rest.web.commons.ValidationErrorResponse;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@ControllerAdvice
public class RestResponseEntityExceptionHandler
extends ResponseEntityExceptionHandler {
    @ExceptionHandler
    public ResponseEntity exceptionHandle(Exception ex) {
        String detail = ExceptionUtil.getStackMessage((Throwable)ex);
        ex.printStackTrace();
        MethodArgumentNotValidException invalidException = (MethodArgumentNotValidException)ExceptionUtil.cast((Exception)ex, MethodArgumentNotValidException.class);
        if (invalidException != null) {
            Collection errors = invalidException.getBindingResult().getAllErrors().stream().map(ii -> {
                StringBuilder msg = new StringBuilder();
                Object[] arguments = ii.getArguments();
                if (arguments != null && arguments.length > 0) {
                    String fieldName = Arrays.stream(arguments).map(arg -> {
                        DefaultMessageSourceResolvable dmsr = (DefaultMessageSourceResolvable)arg;
                        if (dmsr != null) {
                            return dmsr.getDefaultMessage();
                        }
                        return null;
                    }).filter(arg -> arg != null).collect(Collectors.joining(","));
                    msg.append(fieldName);
                    msg.append(" ");
                }
                msg.append(ii.getDefaultMessage());
                return msg.toString();
            }).collect(Collectors.toList());
            return ResponseBuilder.build(HttpStatus.BAD_REQUEST, errors);
        }
        DataOperationTenantException dtx = (DataOperationTenantException)ExceptionUtil.cast((Exception)ex, DataOperationTenantException.class);
        if (dtx != null) {
            return ResponseBuilder.build(HttpStatus.METHOD_NOT_ALLOWED, dtx.getData(), dtx.getCode(), dtx.getMessage(), null);
        }
        UnAuthorizedTenantException authorizedException = (UnAuthorizedTenantException)ExceptionUtil.cast((Exception)ex, UnAuthorizedTenantException.class);
        if (authorizedException != null) {
            return ResponseBuilder.build(HttpStatus.UNAUTHORIZED, detail, ex.getMessage(), null);
        }
        ForbidTenantException forbidException = (ForbidTenantException)ExceptionUtil.cast((Exception)ex, ForbidTenantException.class);
        if (forbidException != null) {
            return ResponseBuilder.build(HttpStatus.FORBIDDEN, detail, forbidException.getMessage(), null);
        }
        NotFoundTenantException notFoundException = (NotFoundTenantException)ExceptionUtil.cast((Exception)ex, NotFoundTenantException.class);
        if (notFoundException != null) {
            return ResponseBuilder.build(HttpStatus.NOT_FOUND, detail, notFoundException.getMessage(), null);
        }
        NotAllowedTenantException notAllowedException = (NotAllowedTenantException)ExceptionUtil.cast((Exception)ex, NotAllowedTenantException.class);
        if (notAllowedException != null) {
            return ResponseBuilder.build(HttpStatus.METHOD_NOT_ALLOWED, detail, notAllowedException.getMessage(), null);
        }
        ConflictTenantException conflictTenantException = (ConflictTenantException)ExceptionUtil.cast((Exception)ex, ConflictTenantException.class);
        if (conflictTenantException != null) {
            return ResponseBuilder.build(HttpStatus.BAD_REQUEST, detail, conflictTenantException.getMessage(), null);
        }
        TenantExceptionAbstract tenantException = (TenantExceptionAbstract)ExceptionUtil.cast((Exception)ex, TenantExceptionAbstract.class);
        if (tenantException != null) {
            return ResponseBuilder.build(HttpStatus.BAD_REQUEST, detail, tenantException.getMessage(), null);
        }
        String detailException = ExceptionUtil.getStackMessage((Throwable)ex);
        if (detailException.contains("IdentityNotFoundException") || detailException.contains("\u627e\u4e0d\u5230\u8eab\u4efd\u4fe1\u606f")) {
            return ResponseBuilder.build(HttpStatus.BAD_REQUEST, detailException, "\u8d26\u53f7/\u5bc6\u7801\u4e0d\u6b63\u786e", null);
        }
        if (detailException.contains("IdentityNotMatchedException") || detailException.contains("\u8d26\u53f7/\u5bc6\u7801\u4e0d\u6b63\u786e")) {
            return ResponseBuilder.build(HttpStatus.BAD_REQUEST, detailException, "\u8d26\u53f7/\u5bc6\u7801\u4e0d\u6b63\u786e", null);
        }
        if (detailException.contains("TenantException:") && detailException.contains("\n")) {
            String msg = detailException.substring(detailException.indexOf("TenantException:") + 16, detailException.indexOf("\r"));
            return ResponseBuilder.build(HttpStatus.BAD_REQUEST, detail, msg, null);
        }
        return ResponseBuilder.build(HttpStatus.BAD_REQUEST, detail, "\u7cfb\u7edf\u5f02\u5e38, \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", null);
    }

    protected ResponseEntity<Object> handleMethodArgumentNotValid(MethodArgumentNotValidException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        ValidationErrorResponse validationErrorResponse = new ValidationErrorResponse("\u8bf7\u6c42\u53c2\u6570\u4e0d\u7b26\u5408\u8981\u6c42");
        for (ObjectError error : ex.getBindingResult().getAllErrors()) {
            if (error instanceof FieldError) {
                FieldError fieldError = (FieldError)error;
                validationErrorResponse.addFieldMessage(fieldError.getField(), fieldError.getDefaultMessage(), fieldError.getRejectedValue());
                continue;
            }
            validationErrorResponse.addFieldMessage(error.getObjectName(), error.getDefaultMessage());
        }
        return ResponseBuilder.build(HttpStatus.BAD_REQUEST, validationErrorResponse);
    }
}

