/**
 *
 */

(function ($) {
    'use strict';
    var sprintf = $.fn.bootstrapTable.utils.sprintf;

    $.extend($.fn.bootstrapTable.defaults, {
        showExport: false,
        exportDataType: 'basic', // basic, all, selected
        // 'json', 'xml', 'png', 'csv', 'txt', 'sql', 'doc', 'excel', 'powerpoint', 'pdf'
        exportTypes: ['excel','sql'],//
        exportOptions: {ignoreColumn: [0]}
    });

    $.extend($.fn.bootstrapTable.defaults.icons, {
        export: 'glyphicon-export icon-share'
    });

    $.extend($.fn.bootstrapTable.locales, {
        formatExport: function () {
            return 'Export data';
        }
    });
    $.extend($.fn.bootstrapTable.defaults, $.fn.bootstrapTable.locales);

    var BootstrapTable = $.fn.bootstrapTable.Constructor,
        _initToolbar = BootstrapTable.prototype.initToolbar;

    BootstrapTable.prototype.initToolbar = function () {
        this.showToolbar = this.options.showExport;

        _initToolbar.apply(this, Array.prototype.slice.apply(arguments));

        if (this.options.showExport) {
            var that = this,
                $btnGroup = this.$toolbar.find('>.btn-group'),
                $export = $btnGroup.find('div.export');

            if (!$export.length) {
                $export = $([
                    '<div class="export btn-group">',
                        '<button class="btn btn-info btn' +
                            sprintf(' btn-%s', this.options.buttonsClass) +
                            sprintf(' btn-%s', this.options.iconSize) +
                            ' dropdown-toggle" ' +
                            'title="' + this.options.formatExport() + '" ' +
                            'data-toggle="dropdown" type="button">',
                            sprintf('<i class="%s %s"></i> ', this.options.iconsPrefix, this.options.icons.export),
                            '<span>导出</span>&nbsp;<span class="caret"></span>',
                        '</button>',
                        '<ul class="dropdown-menu" role="menu">',
                        '</ul>',
                    '</div>'].join('')).appendTo($btnGroup);

                var $menu = $export.find('.dropdown-menu');
                $menu.append(['<li data-type="">',
                                '<a href="javascript:exportFile(1)">',
                                    "Excel 格式",
                                '</a>',
                            '</li>'].join(''));
                $menu.append(['<li data-type="">',
                                '<a href="javascript:exportFile(2)">',
                                    "Insert 脚本",
                                '</a>',
                            '</li>'].join(''));
                $menu.append(['<li data-type="">',
                                '<a href="javascript:exportFile(3)">',
                                    "Update 脚本",
                                '</a>',
                            '</li>'].join(''));

            }
        }
    };
})(jQuery);

function exportFile(exportType) {
    var dataParam = $("#dataForm").serializeArray();
    var columnName = $("#columnName").val();
    if(exportType == 3 && columnName ==''){
        layer.msg("请填写主键字段");
        return;
    }
    dataParam.push({ "name": "exportType", "value": exportType });
    dataParam.push({ "name": "columnName", "value": columnName });
    $.modal.loading("正在导出数据，请稍后...");
    $.post(table.options.exportUrl, dataParam, function(result) {
        if (result.code == web_status.SUCCESS) {
            window.location.href = ctx + "common/download?fileName=" + encodeURI(result.msg) + "&delete=" + true;
        } else if (result.code == web_status.WARNING) {
            $.modal.alertWarning(result.msg)
        } else {
            $.modal.alertError(result.msg);
        }
        $.modal.closeLoading();
    });
}


function getColumnValue(){
    var columnName = $("#columnName").val();
    if(columnName !=''){
        var columnValue = $.table.selectColumns(columnName);
        console.log("'"+columnValue.join("','")+"'");
    }
}


function showTable(){
    $(".tableArea").show();
    $(".textArea").hide();
    $(".jsonArea").hide();
}

function showText(){
    $(".textArea").show();
    $(".tableArea").hide();
    $(".jsonArea").hide();
}

function showJSON(){
    $(".tableArea").hide();
    $(".textArea").hide();
    $(".jsonArea").show();
}
