package com.bcxin.auth.web.controller.manage;

import com.bcxin.auth.common.core.controller.BaseController;
import com.bcxin.auth.common.core.domain.AjaxResult;
import com.bcxin.auth.common.core.page.TableDataInfo;
import com.bcxin.auth.system.util.ConfigUtil;
import com.bcxin.obpm.dto.AuthLog;
import com.bcxin.obpm.schedule.AuthTask;
import com.bcxin.obpm.service.IObpmSecurityManService;
import com.bcxin.obpm.service.ITenantUserService;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author linqinglin
 * @date 2021/08/01 0001 15:14
 */
@Controller
@RequestMapping("/manage/auth")
public class AuthManageController extends BaseController {

    private String prefix = "manage/auth";

    @Resource
    private IObpmSecurityManService obpmSecurityManService;

    @Resource
    private ITenantUserService tenantUserService;

    @Resource
    private ConfigUtil configUtil;

    @Resource
    private AuthTask authTask;

    @GetMapping()
    public String auth(ModelMap modelMap)
    {
        modelMap.addAttribute("v5url",configUtil.getV5URL());
        modelMap.addAttribute("intranet",configUtil.isIntranet());
        modelMap.addAttribute("police",configUtil.isPolice());
        return prefix + "/list";
    }

    @GetMapping("dataSync")
    public String dataSync(ModelMap modelMap)
    {
        modelMap.addAttribute("v5url",configUtil.getV5URL());
        return prefix + "/dataSync";
    }

    @PostMapping("/dataSyncFile")
    @ResponseBody
    public AjaxResult dataSyncFile(AuthLog authLog){
        try {
            obpmSecurityManService.dataSyncFile(authLog);
        } catch (Exception e) {
            return AjaxResult.error(e.getMessage());
        }
        return AjaxResult.success("已生成同步文件");
    }

    /*@PostMapping("/validateResult/{idNumber}")
    @ResponseBody
    public AjaxResult validateResult(@PathVariable String idNumber){
        try {
            authTask.validateResult(idNumber);
        } catch (Exception e) {
            return AjaxResult.error(e.getMessage());
        }
        return AjaxResult.success("已认证");
    }*/


    @PostMapping("/list")
    @ResponseBody
    public TableDataInfo list(AuthLog authLog)
    {
        startPage();
        List<AuthLog> list = null;
        if(configUtil.isPolice()){
            list = obpmSecurityManService.selectList(authLog);
        }else {
            list = tenantUserService.selectList(authLog);
        }
        return getDataTable(list);
    }

}
