package com.bcxin.auth.web.controller.auth;

import com.alibaba.fastjson.JSONArray;
import com.bcxin.obpm.dto.AuthAjaxResult;
import com.bcxin.obpm.dto.AuthLog;
import com.bcxin.obpm.service.ITenantUserService;
import com.bcxin.obpm.util.JwtUtil;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author linqinglin
 * @date 2021/08/01 0001 15:14
 */
@RestController
@RequestMapping("/auth")
public class AuthController {

    @Resource
    private ITenantUserService tenantUserService;

    @PostMapping("updateBatch")
    public AuthAjaxResult updateBatch(String authList){
        try {
            List<AuthLog> list = JSONArray.parseArray(JwtUtil.parseJwt(authList),AuthLog.class);
            tenantUserService.updateBatch(list);
            return AuthAjaxResult.success("更新成功");
        }catch (Exception e){
            return AuthAjaxResult.error("更新失败");
        }
    }
}
