/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.auth.common.utils;

import com.bcxin.auth.common.utils.StringUtils;
import com.bcxin.auth.common.vo.CommonClass;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.AcroFields;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PRIndirectReference;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfCopy;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfImportedPage;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.PdfStream;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDFUtils {
    static final Logger logger = LoggerFactory.getLogger(PDFUtils.class);
    private static final float SIGNATURE_SCALE = 0.95f;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createPDFForTemplate(String templatePath, String pdfPath, Object obj) throws IOException, DocumentException {
        PdfReader reader = null;
        FileOutputStream out = null;
        ByteArrayOutputStream bos = null;
        PdfStamper stamper = null;
        Document doc = null;
        try {
            out = new FileOutputStream(pdfPath);
            reader = new PdfReader(templatePath);
            bos = new ByteArrayOutputStream();
            stamper = new PdfStamper(reader, (OutputStream)bos);
            AcroFields form = stamper.getAcroFields();
            for (String fieldName : form.getFields().keySet()) {
                System.out.println(fieldName);
                String propertyValue = BeanUtils.getProperty((Object)obj, (String)fieldName);
                System.out.println("name:" + fieldName + "  value:" + propertyValue);
                form.setField(fieldName, propertyValue);
            }
            stamper.setFormFlattening(true);
            stamper.close();
            doc = new Document();
            PdfCopy copy = new PdfCopy(doc, (OutputStream)out);
            doc.open();
            PdfImportedPage importPage = copy.getImportedPage(new PdfReader(bos.toByteArray()), 1);
            copy.addPage(importPage);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (DocumentException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (stamper != null) {
                stamper.close();
            }
            if (doc != null) {
                doc.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createPDF(String templatePath, String pdfPath, Object obj) throws IOException, DocumentException {
        PdfReader reader = null;
        FileOutputStream out = null;
        ByteArrayOutputStream bos = null;
        PdfStamper stamper = null;
        Document doc = null;
        try {
            out = new FileOutputStream(pdfPath);
            reader = new PdfReader(templatePath);
            bos = new ByteArrayOutputStream();
            stamper = new PdfStamper(reader, (OutputStream)bos);
            BaseFont baseFont = PDFUtils.loadFontFromJar("fonts/\u5b8b\u4f53.ttf");
            AcroFields form = stamper.getAcroFields();
            form.addSubstitutionFont(baseFont);
            for (String fieldName : form.getFields().keySet()) {
                String propertyValue = BeanUtils.getProperty((Object)obj, (String)fieldName);
                System.out.println("name: " + fieldName + " value: " + propertyValue);
                form.setField(fieldName, propertyValue);
                form.setFieldProperty(fieldName, "textfont", (Object)BaseFont.createFont((String)"Helvetica-Bold", (String)"Cp1252", (boolean)true), null);
            }
            stamper.setFormFlattening(true);
            stamper.close();
            doc = new Document();
            PdfCopy copy = new PdfCopy(doc, (OutputStream)out);
            doc.open();
            PdfImportedPage importPage = copy.getImportedPage(new PdfReader(bos.toByteArray()), 1);
            copy.addPage(importPage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (stamper != null) {
                stamper.close();
            }
            if (doc != null) {
                doc.close();
            }
        }
    }

    private static BaseFont loadFontFromJar(String fontPath) throws IOException, DocumentException {
        InputStream fontStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(fontPath);
        if (fontStream == null) {
            throw new FileNotFoundException("Font file not found: " + fontPath);
        }
        File tempFile = File.createTempFile("font", ".ttf");
        try (FileOutputStream fos = new FileOutputStream(tempFile);){
            int bytesRead;
            byte[] buffer = new byte[1024];
            while ((bytesRead = fontStream.read(buffer)) != -1) {
                fos.write(buffer, 0, bytesRead);
            }
        }
        BaseFont baseFont = BaseFont.createFont((String)tempFile.getAbsolutePath(), (String)"Identity-H", (boolean)true);
        tempFile.deleteOnExit();
        return baseFont;
    }

    public static void addPDFChange(String templatePDF, String outFile, List<CommonClass> pdfChangeDTOList) throws IOException, DocumentException {
        PdfReader reader = new PdfReader(templatePDF);
        PdfStamper ps = new PdfStamper(reader, (OutputStream)new FileOutputStream(outFile));
        AcroFields s = ps.getAcroFields();
        PDFUtils.insertText(ps, s, pdfChangeDTOList);
        ps.close();
        reader.close();
    }

    public static void main(String[] args) throws Exception {
        ArrayList<String> pdfFiles = new ArrayList<String>();
        pdfFiles.add("D:\\data\\logs\\C610100queueId_601.pdf");
        pdfFiles.add("D:\\data\\logs\\C610700queueId_620.pdf");
        Document document = new Document(PageSize.A4);
        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream("D:\\data\\logs\\merged.pdf"));
        document.open();
        PdfContentByte canvas = writer.getDirectContent();
        PdfReader reader1 = new PdfReader("D:\\data\\logs\\C610100queueId_601.pdf");
        PdfReader reader2 = new PdfReader("D:\\data\\logs\\C610700queueId_620.pdf");
        PdfImportedPage page1 = writer.getImportedPage(reader1, 1);
        PdfImportedPage page2 = writer.getImportedPage(reader2, 1);
        float scaleX = PageSize.A4.getWidth() / page1.getWidth();
        float scaleY = PageSize.A4.getHeight() / (page1.getHeight() * 2.0f);
        float scale2X = PageSize.A4.getWidth() / page2.getWidth();
        float scale2Y = PageSize.A4.getHeight() / (page2.getHeight() * 2.0f);
        canvas.addTemplate((PdfTemplate)page1, scaleX, 0.0f, 0.0f, scaleY, -25.0f, PageSize.A4.getHeight() / 2.0f);
        canvas.addTemplate((PdfTemplate)page2, scale2X, 0.0f, 0.0f, scale2Y, -25.0f, 41.0f);
        document.close();
    }

    public static void mergePdf(String inpdf1, String inpdf2, String outpdf) throws Exception {
        if (StringUtils.isEmpty(inpdf1)) {
            throw new FileNotFoundException("Font file not found: " + inpdf1);
        }
        byte[] flattenedPdf1 = PDFUtils.flattenSignatureAnnotations(inpdf1);
        byte[] flattenedPdf2 = null;
        if (StringUtils.isNotEmpty(inpdf2)) {
            flattenedPdf2 = PDFUtils.flattenSignatureAnnotations(inpdf2);
        }
        Document document = new Document(PageSize.A4);
        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(outpdf));
        document.open();
        PdfContentByte canvas = writer.getDirectContent();
        PdfReader reader1 = new PdfReader(flattenedPdf1);
        PdfImportedPage page1 = writer.getImportedPage(reader1, 1);
        float scaleX = PageSize.A4.getWidth() / page1.getWidth();
        float scaleY = PageSize.A4.getHeight() / (page1.getHeight() * 2.0f);
        canvas.addTemplate((PdfTemplate)page1, scaleX, 0.0f, 0.0f, scaleY, -25.0f, PageSize.A4.getHeight() / 2.0f);
        if (StringUtils.isNotEmpty(inpdf2)) {
            PdfReader reader2 = new PdfReader(flattenedPdf2);
            PdfImportedPage page2 = writer.getImportedPage(reader2, 1);
            float scale2X = PageSize.A4.getWidth() / page2.getWidth();
            float scale2Y = PageSize.A4.getHeight() / (page2.getHeight() * 2.0f);
            canvas.addTemplate((PdfTemplate)page2, scale2X, 0.0f, 0.0f, scale2Y, -25.0f, 41.0f);
        }
        document.close();
    }

    public static void mergePdf1(String inpdf1, String inpdf2, String outpdf, float bl1, float bl2) throws Exception {
        if (StringUtils.isEmpty(inpdf1)) {
            throw new FileNotFoundException("Font file not found: " + inpdf1);
        }
        byte[] flattenedPdf1 = PDFUtils.flattenSignatureAnnotations(inpdf1);
        byte[] flattenedPdf2 = null;
        if (StringUtils.isNotEmpty(inpdf2)) {
            flattenedPdf2 = PDFUtils.flattenSignatureAnnotations(inpdf2);
        }
        Document document = new Document(PageSize.A4);
        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(outpdf));
        document.open();
        PdfContentByte canvas = writer.getDirectContent();
        PdfReader reader1 = new PdfReader(flattenedPdf1);
        Rectangle origSize = reader1.getPageSize(1);
        float origWidth = origSize.getWidth() * bl1;
        float origHeight = origSize.getHeight() * bl1;
        float availableWidth = PageSize.A4.getWidth();
        float availableHeight = PageSize.A4.getHeight() / 2.0f;
        float widthRatio = availableWidth / origWidth;
        float heightRatio = availableHeight / origHeight;
        float scale = Math.min(widthRatio, heightRatio);
        float scaledWidth = origWidth * scale;
        float x = (PageSize.A4.getWidth() - scaledWidth) / 2.0f;
        PdfImportedPage page = writer.getImportedPage(reader1, 1);
        float scaleY = PageSize.A4.getHeight() / (page.getHeight() * 2.0f);
        canvas.addTemplate((PdfTemplate)page, (double)scale, 0.0, 0.0, (double)scale, (double)x - 6.5, (double)(PageSize.A4.getHeight() / 2.0f + 10.0f));
        if (StringUtils.isNotEmpty(inpdf2)) {
            PdfReader reader2 = new PdfReader(flattenedPdf2);
            Rectangle origSize2 = reader2.getPageSize(1);
            System.out.println(origSize.getWidth());
            float origWidth2 = origSize2.getWidth() * bl2;
            float origHeight2 = origSize2.getHeight() * bl2;
            float availableWidth2 = PageSize.A4.getWidth();
            float availableHeight2 = PageSize.A4.getHeight() / 2.0f;
            float widthRatio2 = availableWidth2 / origWidth2;
            float heightRatio2 = availableHeight2 / origHeight2;
            float scale2 = Math.min(widthRatio2, heightRatio2);
            PdfImportedPage page2 = writer.getImportedPage(reader2, 1);
            float scale2Y = PageSize.A4.getHeight() / (page2.getHeight() * 2.0f);
            canvas.addTemplate((PdfTemplate)page2, (double)scale2, 0.0, 0.0, (double)scale2Y, (double)x - 6.5, 51.0);
        }
        document.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] flattenSignatureAnnotations(String inputPath) throws Exception {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            PdfReader reader = new PdfReader(inputPath);
            PdfStamper stamper = new PdfStamper(reader, (OutputStream)baos);
            stamper.setFormFlattening(true);
            stamper.close();
            reader.close();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void scaleAndPlaceSignatures(PdfContentByte canvas, PdfWriter writer, PdfReader reader, float pageScale, float pageX, float pageY) throws Exception {
        PdfDictionary pageDict = reader.getPageN(1);
        PdfArray annots = pageDict.getAsArray(PdfName.ANNOTS);
        if (annots == null) {
            return;
        }
        for (int i = 0; i < annots.size(); ++i) {
            PRIndirectReference ref;
            PdfArray rectArray;
            PdfDictionary annot = annots.getAsDict(i);
            PdfName subtype = annot.getAsName(PdfName.SUBTYPE);
            if (!PdfName.WIDGET.equals((Object)subtype) && !PdfName.SIG.equals((Object)subtype) || (rectArray = annot.getAsArray(PdfName.RECT)) == null || rectArray.size() < 4) continue;
            float llx = rectArray.getAsNumber(0).floatValue();
            float lly = rectArray.getAsNumber(1).floatValue();
            float urx = rectArray.getAsNumber(2).floatValue();
            float ury = rectArray.getAsNumber(3).floatValue();
            float width = urx - llx;
            float height = ury - lly;
            float scaledWidth = width * 0.95f;
            float scaledHeight = height * 0.95f;
            float centerX = llx + width / 2.0f;
            float centerY = lly + height / 2.0f;
            float newX = centerX - scaledWidth / 2.0f;
            float newY = centerY - scaledHeight / 2.0f;
            PdfStream xobject = annot.getAsStream(PdfName.AP);
            if (xobject == null || (ref = xobject.getIndRef()) == null) continue;
            PdfImportedPage signaturePage = writer.getImportedPage(reader, 1);
            float canvasX = pageX + newX * pageScale;
            float canvasY = pageY + newY * pageScale;
            canvas.addTemplate((PdfTemplate)signaturePage, pageScale * 0.95f, 0.0f, 0.0f, pageScale * 0.95f, canvasX, canvasY);
        }
    }

    private static void addScaledPage(PdfContentByte canvas, PdfWriter writer, byte[] pdfData, float yOffset, boolean isTop) throws Exception {
        PdfReader reader = new PdfReader(pdfData);
        PdfImportedPage page = writer.getImportedPage(reader, 1);
        Rectangle pageSize = reader.getPageSize(1);
        float origWidth = pageSize.getWidth();
        float origHeight = pageSize.getHeight();
        float availableHeight = PageSize.A4.getHeight() / 2.0f;
        float scale = Math.min((PageSize.A4.getWidth() - 50.0f) / origWidth, availableHeight / origHeight);
        float x = (PageSize.A4.getWidth() - origWidth * scale) / 2.0f;
        float y = isTop ? PageSize.A4.getHeight() - availableHeight + (availableHeight - origHeight * scale) / 2.0f : yOffset + (availableHeight - origHeight * scale) / 2.0f;
        canvas.addTemplate((PdfTemplate)page, scale, 0.0f, 0.0f, scale, x, y);
        reader.close();
    }

    public static void insertText(PdfStamper ps, AcroFields s, List<CommonClass> pdfChangeDTOList) throws IOException, DocumentException {
        PdfPCell blankCell;
        List list = s.getFieldPositions("change");
        Rectangle rect = ((AcroFields.FieldPosition)list.get((int)0)).position;
        PdfContentByte cb = ps.getOverContent(1);
        PdfPTable table = new PdfPTable(4);
        table.setTotalWidth(270.0f);
        table.setWidths(new float[]{14.0f, 29.0f, 16.0f, 20.0f});
        BaseFont bfChinese = BaseFont.createFont((String)"STSongStd-Light", (String)"UniGB-UCS2-H", (boolean)false);
        Font font_10 = new Font(bfChinese, 10.0f, 0);
        Font font_7 = new Font(bfChinese, 8.0f, 0);
        Font font_12 = new Font(bfChinese, 12.0f, 0);
        table.addCell(PDFUtils.changeCellAlignment("\u9879   \u76ee", font_12, true, true, 28.0f));
        table.addCell(PDFUtils.changeCellAlignment("\u53d8\u66f4\u540e\u5185\u5bb9", font_12, true, true, 28.0f));
        table.addCell(PDFUtils.changeCellAlignment("\u53d8\u66f4\u65f6\u95f4", font_12, true, true, 28.0f));
        table.addCell(PDFUtils.changeCellAlignment("\u53d8\u66f4\u4e13\u7528\u7ae0", font_12, true, true, 28.0f));
        if (pdfChangeDTOList != null) {
            for (CommonClass pdfChangeDTO : pdfChangeDTOList) {
                table.addCell(PDFUtils.changeCellAlignment(pdfChangeDTO.getField1(), font_10, true, true, 0.0f));
                table.addCell(PDFUtils.changeCellAlignment(pdfChangeDTO.getField2(), font_7, false, true, 0.0f));
                table.addCell(PDFUtils.changeCellAlignment(pdfChangeDTO.getField3(), font_10, true, true, 0.0f));
                blankCell = new PdfPCell();
                blankCell.setMinimumHeight(28.0f);
                table.addCell(blankCell);
            }
        } else {
            pdfChangeDTOList = new ArrayList<CommonClass>();
        }
        int size = 7 - pdfChangeDTOList.size();
        for (int i = 0; i < size; ++i) {
            blankCell = new PdfPCell();
            blankCell.setMinimumHeight(28.0f);
            table.addCell(blankCell);
            table.addCell((Phrase)new Paragraph("", font_10));
            table.addCell((Phrase)new Paragraph("", font_10));
            table.addCell(new PdfPCell(new Phrase("")));
        }
        table.writeSelectedRows(0, -1, rect.getLeft(), rect.getTop(), cb);
    }

    private static PdfPCell changeCellAlignment(String projectName, Font font, boolean horizontal, boolean vertical, float minimumHeight) {
        Paragraph paragraph = new Paragraph(projectName, font);
        paragraph.setAlignment(1);
        PdfPCell cell1 = new PdfPCell();
        cell1.setUseAscender(true);
        if (horizontal) {
            cell1.setHorizontalAlignment(1);
        }
        if (vertical) {
            cell1.setVerticalAlignment(5);
        }
        cell1.setPhrase((Phrase)paragraph);
        cell1.setMinimumHeight(minimumHeight);
        return cell1;
    }
}

