/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.auth.common.json;

import com.bcxin.auth.common.json.JSON;
import com.bcxin.auth.common.utils.StringUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSONObject
extends LinkedHashMap<String, Object> {
    private static final long serialVersionUID = 1L;
    private static final Pattern arrayNamePattern = Pattern.compile("(\\w+)((\\[\\d+\\])+)");
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public JSONObject() {
    }

    public JSONObject(JSONObject other) {
        super(other);
    }

    @Override
    public String toString() {
        try {
            return JSON.marshal(this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String toCompactString() {
        try {
            return objectMapper.writeValueAsString((Object)this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Integer intValue(String name) {
        return JSONObject.valueAsInt(this.value(name));
    }

    public Integer intValue(String name, Integer defaultValue) {
        return StringUtils.nvl(this.intValue(name), defaultValue);
    }

    public Long longValue(String name) {
        return JSONObject.valueAsLong(this.value(name));
    }

    public Long longValue(String name, Long defaultValue) {
        return StringUtils.nvl(this.longValue(name), defaultValue);
    }

    public Boolean boolValue(String name) {
        return JSONObject.valueAsBool(this.value(name));
    }

    public Boolean boolValue(String name, Boolean defaultValue) {
        return StringUtils.nvl(this.boolValue(name), defaultValue);
    }

    public String strValue(String name) {
        return JSONObject.valueAsStr(this.value(name));
    }

    public String strValue(String name, String defaultValue) {
        return StringUtils.nvl(this.strValue(name), defaultValue);
    }

    public Object value(String name) {
        int indexDot = name.indexOf(46);
        if (indexDot >= 0) {
            return this.obj(name.substring(0, indexDot)).value(name.substring(indexDot + 1));
        }
        Matcher matcher = arrayNamePattern.matcher(name);
        if (matcher.find()) {
            return this.endArray(matcher.group(1), matcher.group(2), new EndArrayCallback<Object>(){

                @Override
                public Object callback(JSONArray arr, int index) {
                    return JSONObject.elementAt(arr, index);
                }
            });
        }
        return this.get(name);
    }

    public JSONObject value(String name, final Object value) {
        int indexDot = name.indexOf(46);
        if (indexDot >= 0) {
            this.obj(name.substring(0, indexDot)).value(name.substring(indexDot + 1), value);
        } else {
            Matcher matcher = arrayNamePattern.matcher(name);
            if (matcher.find()) {
                this.endArray(matcher.group(1), matcher.group(2), new EndArrayCallback<Void>(){

                    @Override
                    public Void callback(JSONArray arr, int index) {
                        JSONObject.elementAt(arr, index, value);
                        return null;
                    }
                });
            } else {
                this.set(name, value);
            }
        }
        return this;
    }

    public JSONObject obj(String name) {
        Matcher matcher = arrayNamePattern.matcher(name);
        if (matcher.find()) {
            return this.endArray(matcher.group(1), matcher.group(2), new EndArrayCallback<JSONObject>(){

                @Override
                public JSONObject callback(JSONArray arr, int index) {
                    return JSONObject.objAt(arr, index);
                }
            });
        }
        JSONObject obj = this.getObj(name);
        if (obj == null) {
            obj = new JSONObject();
            this.put(name, (Object)obj);
        }
        return obj;
    }

    public JSONArray arr(String name) {
        JSONArray arr = this.getArr(name);
        if (arr == null) {
            arr = new JSONArray();
            this.put(name, (Object)arr);
        }
        return arr;
    }

    public JSONObject getObj(String name) {
        return (JSONObject)this.get(name);
    }

    public JSONArray getArr(String name) {
        return (JSONArray)this.get(name);
    }

    public Integer getInt(String name) {
        return JSONObject.valueAsInt(this.get(name));
    }

    public Integer getInt(String name, Integer defaultValue) {
        return StringUtils.nvl(this.getInt(name), defaultValue);
    }

    public Long getLong(String name) {
        return JSONObject.valueAsLong(this.get(name));
    }

    public Long getLong(String name, Long defaultValue) {
        return StringUtils.nvl(this.getLong(name), defaultValue);
    }

    public String getStr(String name) {
        return JSONObject.valueAsStr(this.get(name));
    }

    public String getStr(String name, String defaultValue) {
        return StringUtils.nvl(this.getStr(name), defaultValue);
    }

    public Boolean getBool(String name) {
        return JSONObject.valueAsBool(this.get(name));
    }

    public Boolean getBool(String name, Boolean defaultValue) {
        return StringUtils.nvl(this.getBool(name), defaultValue);
    }

    public JSONObject set(String name, Object value) {
        this.put(name, value);
        return this;
    }

    public <T> T asBean(Class<T> beanClass) {
        try {
            return JSON.unmarshal(JSON.marshal(this), beanClass);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object put(String key, Object value) {
        return super.put(key, JSONObject.transfer(value));
    }

    public static Integer valueAsInt(Object value) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            return Integer.valueOf((String)value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1 : 0;
        }
        return null;
    }

    public static Long valueAsLong(Object value) {
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            return Long.valueOf((String)value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1L : 0L;
        }
        return null;
    }

    public static String valueAsStr(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    public static Boolean valueAsBool(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue() != 0.0;
        }
        if (value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        return null;
    }

    private static Object transfer(Object value) {
        if (!(value instanceof JSONObject) && value instanceof Map) {
            return JSONObject.toObj((Map)value);
        }
        if (!(value instanceof JSONArray) && value instanceof Collection) {
            return JSONObject.toArr((Collection)value);
        }
        return value;
    }

    private static JSONArray toArr(Collection<Object> list) {
        JSONArray arr = new JSONArray(list.size());
        for (Object element : list) {
            arr.add(element);
        }
        return arr;
    }

    private static JSONObject toObj(Map<String, Object> map) {
        JSONObject obj = new JSONObject();
        for (Map.Entry<String, Object> ent : map.entrySet()) {
            obj.put(ent.getKey(), JSONObject.transfer(ent.getValue()));
        }
        return obj;
    }

    private static JSONArray arrayAt(JSONArray arr, int index) {
        JSONObject.expand(arr, index);
        if (arr.get(index) == null) {
            arr.set(index, new JSONArray());
        }
        return (JSONArray)arr.get(index);
    }

    private static JSONObject objAt(JSONArray arr, int index) {
        JSONObject.expand(arr, index);
        if (arr.get(index) == null) {
            arr.set(index, new JSONObject());
        }
        return (JSONObject)arr.get(index);
    }

    private static void elementAt(JSONArray arr, int index, Object value) {
        JSONObject.expand(arr, index).set(index, value);
    }

    private static Object elementAt(JSONArray arr, int index) {
        return JSONObject.expand(arr, index).get(index);
    }

    private static JSONArray expand(JSONArray arr, int index) {
        while (arr.size() <= index) {
            arr.add((Object)null);
        }
        return arr;
    }

    private <T> T endArray(String name, String indexesStr, EndArrayCallback<T> callback) {
        JSONArray endArr = this.arr(name);
        int[] indexes = JSONObject.parseIndexes(indexesStr);
        int i = 0;
        while (i < indexes.length - 1) {
            endArr = JSONObject.arrayAt(endArr, indexes[i++]);
        }
        return callback.callback(endArr, indexes[i]);
    }

    private static int[] parseIndexes(String s) {
        int[] indexes = null;
        ArrayList<Integer> list = new ArrayList<Integer>();
        StringTokenizer st = new StringTokenizer(s, "[]");
        while (st.hasMoreTokens()) {
            int index = Integer.valueOf(st.nextToken());
            if (index < 0) {
                throw new RuntimeException(String.format("Illegal index %1$d in \"%2$s\"", index, s));
            }
            list.add(index);
        }
        indexes = new int[list.size()];
        int i = 0;
        for (Integer tmp : list.toArray(new Integer[list.size()])) {
            indexes[i++] = tmp;
        }
        return indexes;
    }

    private static interface EndArrayCallback<T> {
        public T callback(JSONArray var1, int var2);
    }

    public static class JSONArray
    extends ArrayList<Object> {
        private static final long serialVersionUID = 1L;

        public JSONArray() {
        }

        public JSONArray(int size) {
            super(size);
        }

        @Override
        public String toString() {
            try {
                return JSON.marshal(this);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Object set(int index, Object element) {
            return super.set(index, JSONObject.transfer(element));
        }

        @Override
        public boolean add(Object element) {
            return super.add(JSONObject.transfer(element));
        }

        @Override
        public void add(int index, Object element) {
            super.add(index, JSONObject.transfer(element));
        }
    }
}

