package com.bcxin.auth.common.constant;

/**
 * 通用常量信息
 * 
 * @author bcxin
 */
public class Constants
{

    //zip压缩包后缀
    public static final String ZIP = ".zip";

    /**
     * UTF-8 字符集
     */
    public static final String UTF8 = "UTF-8";

    /**
     * GBK 字符集
     */
    public static final String GBK = "GBK";

    /**
     * 通用成功标识
     */
    public static final String SUCCESS = "0";

    /**
     * 通用失败标识
     */
    public static final String FAIL = "1";

    /**
     * 登录成功
     */
    public static final String LOGIN_SUCCESS = "Success";

    /**
     * 注销
     */
    public static final String LOGOUT = "Logout";

    /**
     * 注册
     */
    public static final String REGISTER = "Register";

    /**
     * 登录失败
     */
    public static final String LOGIN_FAIL = "Error";

    /**
     * 当前记录起始索引
     */
    public static final String PAGE_NUM = "pageNum";

    /**
     * 每页显示记录数
     */
    public static final String PAGE_SIZE = "pageSize";

    /**
     * 排序列
     */
    public static final String ORDER_BY_COLUMN = "orderByColumn";

    /**
     * 排序的方向 "desc" 或者 "asc".
     */
    public static final String IS_ASC = "isAsc";

    /**
     * 排序字段是否需要转换
     */
    public static final String ORDER_UNDER_SCORE = "orderUnderScore";

    /**
     * 系统用户授权缓存
     */
    public static final String SYS_AUTH_CACHE = "sys-authCache";

    /**
     * 参数管理 cache name
     */
    public static final String SYS_CONFIG_CACHE = "sys-config";

    /**
     * 参数管理 cache key
     */
    public static final String SYS_CONFIG_KEY = "sys_config:";

    /**
     * 字典管理 cache name
     */
    public static final String SYS_DICT_CACHE = "sys-dict";

    /**
     * 字典管理 cache key
     */
    public static final String SYS_DICT_KEY = "sys_dict:";

    /**
     * 资源映射路径 前缀
     */
    public static final String RESOURCE_PREFIX = "/profile";


    /**
     * 是
     */
    public static final String Y = "1";

    /**
     * 否
     */
    public static final String N = "0";

    public final static String COMMA = ","; // 逗号

    public final static String  PLAT_COM= "百川信"; // 平台企业

    public final static String TOFTP="TOFTP";

    public final static String INTRANET="INTRANET";

    public final static String HN_AUTH = "HN_AUTH";

    public final static String POLICE="POLICE";

    public final static String TEST="TEST";

    public final static String TESTSAVE="TESTSAVE";

    public static final String DATASYNC_RECEIVE_URL="/dataSync/receive";
    public static final String DATASYNC_CALLBACK_URL="/dataSync/callback";

    public static final String DATASYNC_FTP_URL = "/ftp/file/trans";

    public static final String SRC_HOST = "SRC_HOST";

    public static final String TARGET_HOST = "TARGET_HOST";

    public static final String FTP_HOST = "FTP_HOST";

    public static final String DEMO_PATH = "DEMO_PATH";

    public static final String V5URL = "V5URL";

    public static final String LOCAL_HOST_URL = "LOCAL_HOST_URL";

    public static final String CURRENT_PROVINCE = "CURRENT_PROVINCE";
    public static final String CURRENT_Native = "CURRENT_Native";
    public static final String CURRENT_Native_SHORT = "current_native_short";

    /**
     * 同步日期
     */
    public static final String DATASYNC_DATE = "DATASYNC_DATE";


    /**
     * 同步状态 0未同步
     */
    public static final String DATASYNCSTATE_0 = "0";
    /**
     * 同步状态 1同步给ftp
     */
    public static final String DATASYNCSTATE_1 = "1";
    /**
     * 同步状态 2同步到内网
     */
    public static final String DATASYNCSTATE_2 = "2";
    /**
     * 类型 0业务数据
     */
    public static final String DATASYNCTYPE_0 = "0";
    /**
     * 类型 1客户上传附件
     */
    public static final String DATASYNCTYPE_1 = "1";

    public static final String RETTYPE_SUCCESS = "0";

    public static final String RETTYPE_FAIL = "-1";

    //广西指纹地址
    public static final String GXZWAddress="http://10.148.1.197/tchserviceweb/services/dbService?wsdl";

    /***
     * 是否有指纹
     */
    public static final String FINGER_YES = "1";

    //部级系统配置
    public static final String CURRENT_NATIVE = "current_native";
    public static final String CURRENT_NATIVE_NAME = "current_native_name";
    /**
     * 上报部级数据限制
     */
    public static final String MINISTERIAL_LIMIT = "MINISTERIAL_LIMIT";
    //部级系统上报的数据时间
    public static final String CREATED = "CREATED";
    public static final String MINISTRY_CODE_SUCCESS = "10";
    public static final String MINISTRY_CODE_ERROR = "500";
    public static final String APPROVAL_SYSTEM = "system";




    /* 部级接口常量 start
     *************************************************************/
    /***
     * 部级对接：保安员信息
     */
    public static final String XXBA_BAYXXB = "xxba_bayxxb";
    /***
     * 保安服务公司信息
     */
    public static final String XXBA_BAGSXXB = "xxba_bagsxxb";
    /**
     * 保安服务公司出资人信息
     */
    public static final String XXBA_BAFWGSCZRXX = "xxba_bafwgsczrxx";
    /***
     * 保安服务公司主要管理人员信息
     */
    public static final String XXBA_BAFWGSGLRY = "xxba_bafwgsglry";
    /***
     * 保安服务公司分公司基本信息
     */
    public static final String XXBA_BAFWGSFGSXX = "xxba_bafwgsfgsxx";
    /***
     * 保安服务公司分公司主要管理人员信息
     */
    public static final String XXBA_BAFWGSFGSGLRY = "xxba_bafwgsfgsglry";
    /***
     * 保安服务公司跨区经营基本信息
     */
    public static final String XXBA_BAFWGSKQJYXX = "xxba_bafwgskqjyxx";
    /***
     * 自行招用保安员的单位
     */
    public static final String XXXBA_ZXZYBAYDWXX = "xxba_zxzybaydwxx";
    /**
     * 保安培训机构
     */
    public static final String XXBA_BAPXDWXX = "xxba_bapxdwxx";
    /***
     * 保安员从业情况基本信息
     */
    public static final String XXBA_BAYCYQKXX = "xxba_baycyqkxx";
    /***
     * 保安从业单位及保安培训机构监督检查情况
     */
    public static final String XXBA_BADWJDJCXX = "xxba_badwjdjcxx";
    /***
     * 保安员持枪情况
     */
    public static final String XXBA_BAYCQQKB = "xxba_baycqqkb";
    /***
     * 保安监管力量
     */
    public static final String XXBA_BAJGLL = "xxba_bajgll";
    /***
     * 照片信息上报
     */
    public static final String XXBA_ZPXXB = "xxba_zpxxb";
    /***
     * 海外经营信息
     */
    public static final String XXBA_HWJYXX = "xxba_hwjyxx";
    /**
     * 保安协会信息
     */
    public static final String XXBA_BAXHXX = "xxba_baxhxx";
    /**
     * 公安机关保安监管机构
     */
    public static final String XXBA_POLICESECSUPORG = "xxba_policesecsuporg";
    /**
     * 保安从业单位押运车辆配备情况基本信息
     */
    public static final String XXBA_BACYDWCLPBXX = "xxba_bacydwclpbxx";
    /**
     * 保安从业单位及保安培训机构监督检查被处理人基本信息
     */
    public static final String XXBA_BADWJDJCBCLRXX = "xxba_badwjdjcbclrxx";
    /**
     * 参与协助公安工作情况基本信息
     */
    public static final String XXBA_BACYXZGZXX = "xxba_bacyxzgzxx";

    /**
     * 保安服务公司枪支配备情况基本信息
     */
    public static final String XXBA_BACYDWQZPBXX = "xxba_bacydwqzpbxx";

    /**
     * 表彰奖励情况基本信息
     */
    public static final String XXBA_BABZJLXX = "xxba_babzjl";

    /**
     * 培训机构培训开展情况基本信息
     */
    public static final String XXBA_BAYPXQK = "xxba_baypxqk";
    /**
     * 其他信息
     */
    public static final String XXBA_BAQTXX = "xxba_baqtxx";



    /*********************************************
    * 部级接口常量 end
    */


    /**
     * 接口超时时间:30s
     */
    public static final int TIMEOUT = 30000;

    /**
     * 北京核查库变更 参数key mac地址
     */
    public static final String BEIJING_PARAM_DEVICE_ID = "deviceid";

    /**
     * 北京核查库变更 参数key 警察身份证号
     */
    public static final String BEIJING_PARAM_POLICE_IDENTITY_NUMBER = "policesfzh";

    /**
     * 北京核查库变更 不提醒参数key
     */
    public static final String BEIJING_BG = "BEIJING_BG_";

    /**
     * 北京核查库变更 参数key 警察姓名
     */
    public static final String BEIJING_PARAM_POLICE_NAME = "policename";

    /**
     * 北京核查库变更 参数key 被查询人的身份证号
     */
    public static final String BEIJING_PARAM_BE_QUERIED_IDENTITY_NUMBER = "sfzh";

    /**
     * 北京核查库变更 请求头参数key uid
     */
    public static final String BEIJING_HEADER_UID = "uid";

    /**
     * 北京核查库变更 请求头参数key username
     */
    public static final String BEIJING_HEADER_USERNAME = "username";

    /**
     * 北京核查库变更 请求头参数key userpwd
     */
    public static final String BEIJING_HEADER_USER_PWD = "userpwd";

    /**
     * 北京核查库变更 请求头参数uid 固定值
     */
    public static final String BEIJING_HEADER_UID_VALUE = "1100002200000700";

    /**
     * 北京核查库变更 请求头参数username 固定值
     */
    public static final String BEIJING_HEADER_USERNAME_VALUE = "baxt";

    /**
     * 北京核查库变更 请求头参数userpwd 固定值
     */
    public static final String BEIJING_HEADER_USER_PWD_VALUE = "Bzxt*bzxt";

    /**
     * 核查库返回的color green为正常保安员
     */
    public static final String BEIJING_COLOR_GREEN = "green";

    /**
     * 北京152服务器的mac地址
     */
    public static final String BEIJING_DEVICE_ID = "60:EB:69:8F:82:9C";

    /***
     * 警员组织机构
     */
    public static final String POLICEORG = "治安总队保安支队民警";
    /***
     * 警号
     */
    public static final String POLICEMANID = "004018";
    /***
     * 责任民警姓名
     */
    public static final String POLICENAME = "王光晖";
    public static final String CLIENTID = "C01";
    /**
     * 责任民警身份证号
     */
    public static final String POLICESFZH = "110226197803060034";


    //签章key
    public static final String STAMP_KEY_URL = "stampKeyUrl";
    //签章key
    public static final String STAMP_XML_URL = "stampXmlUrl";
    //签章地址
    public static final String STAMP_URL = "stampURL";
    //签章内容
    public static final String STAMP_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" +
            "<root>\n" +
            " <certPwd>123456</certPwd>\n" +
            " <certPath>{pfxPath}</certPath>\n" +
            " <sealXmlPath>{xmlPath}</sealXmlPath>\n" +
            " <pdfPath>{pdfPath}</pdfPath>\n" +
            " <signPage>1</signPage>\n" +
            " <sealPstX>{left}</sealPstX>\n" +
            " <sealPstY>{top}</sealPstY>\n" +
            "</root>";

    //公司证书背景图片路径 正本数据-单行
    public static final String COMPANY_PIC_1_1 = "COMPANY_PIC_1_1";
    // 公司证书背景图片路径 正本数据-多行
    public static final String COMPANY_PIC_1_2 = "COMPANY_PIC_1_2";
    // 公司证书背景图片路径 副本数据-单行
    public static final String COMPANY_PIC_2_1 = "COMPANY_PIC_2_1";
    // 公司证书背景图片路径 副本数据-多行
    public static final String COMPANY_PIC_2_2 = "COMPANY_PIC_2_2";

    public static final String SECURITY_PIC = "SECURITY_PIC";

    public static final String ACCESS_TOKEN="accessToken";

    public static final String V5_OUT_API_URL="V5_OUT_API_URL";

    public static final String V5IPURL = "V5_IP_URL";
    public static final String OLD_FROMID = "__fDt4Ag03zxUN868oylu";
    public static final String NEW_FROMID = "__v1P7JwYBSy6mP6TL3uZ";

    public static final String OLD_ZZG_FROMID = "OLD_ZZG_FROMID";
    public static final String NEW_ZZG_FROMID = "NEW_ZZG_FROMID";



    /***
     * 宁夏常住人口请求ID和服务ID
     */
    public static final String NX_CZ_REQUESTID = "C64-00000111";
    public static final String NX_CZ_SERVICEID_PHOTO = "S64-00000028";
    public static final String NX_CZ_SERVICEID_INFO = "S64-00000075";
    /***
     * 宁夏违法犯罪请求ID和服务ID
     */
    public static final String NX_WF_REQUESTID = "C64-00000111";
    public static final String NX_WF_SERVICEID = "S64-00000211";
    /***
     * 宁夏吸毒请求ID和服务ID
     */
    public static final String NX_XD_REQUESTID = "C64-00000111";
    public static final String NX_XD_SERVICEID = "S64-00000210";
    /***
     * 宁夏在逃请求ID和服务ID
     */
    public static final String NX_DT_REQUESTID = "C64-00000111";
    public static final String NX_DT_SERVICEID = "S64-00000212";
    public static final String BEIJING = "11";
    public static final String NINGXIA = "64";
    public static final String SHANXI = "61";
    public static final String GUANGXI = "45";
    public static final String JINCHENG = "1405";

    //宁夏重点人员
    public static String NX_ZDRY_DataObjectCode = "A071_640000";
    //宁夏常住基本信息
    public static String NX_CZINFO_DataObjectCode = "NX45";
    //宁夏常住图片信息
    public static String NX_CZPHOTO_DataObjectCode = "NX06";
     //人口库执行返回成功编码
    public static final String ZAFLAG_CODE_SUCCESS = "000";
    //人口库调用次数
    public static final int ZAFLAG_COUNT = 3;

    //人口库信息字段 XM 姓名  ZZXZ 详细地址信息 JGSSX 省市区  XP照片
    public static String INFO_XM = "XM";
    public static String INFO_XM_BJ = "personname";
    public static String INFO_ZZXZ = "ZZXZ";
    public static String INFO_ZZ = "ZZ";
    public static String INFO_ZZXZ_BJ = "personhuji";
    public static String INFO_DETAIL_ADDRESS = "DETAIL_ADDRESS";
    public static String INFO_JGSSX = "JGSSX";
    public static String INFO_XP_BJ = "xp";
    public static String INFO_XP = "XP";

    public static String INFO_ZXBS = "ZXBS";


    /**
     * 陕西背景筛查/人口库url
     */
    public static final String SN_BACKGROUND_CENSOR_PER_INFO_URL = "http://92.1.31.17/datac/service/support/es/query";

    /**
     * 吸毒
     */
    public static final String LIBRARYTYPE_XD = "2";
    public static final String LIBRARYTYPE_XD_FAIL = "吸毒人员";
    /**
     * 犯罪
     */
    public static final String LIBRARYTYPE_WF = "4";
    public static final String LIBRARYTYPE_WF_FAIL = "有违法犯罪记录";
    /***
     * 在逃
     */
    public static final String LIBRARYTYPE_DT = "3";
    public static final String LIBRARYTYPE_DT_FAIL = "在逃人员";
    public static final String LIBRARYTYPE_DT_QUERY = "在逃";


    /**
     * 晋城市公安局服务总线接口，人员身份核验
     */
    public static final String JC_PEOPLE_IDENTITY_VERIFY_URL = "http://23.232.14.211:8950/dataApi/services/v1.0.0/people/identity/verify?idNo=%s&name=%s";
    /**
     * 晋城市公安局服务总线接口，违法犯罪比对
     */
    public static final String JC_PEOPLE_BACKGROUND_CASE_COMPARE_URL = "http://23.232.14.211:8950/dataApi/services/v1.0.0/people/background/case/compare?idNo=%s";
    /**
     * 晋城市公安局服务总线接口，在逃比对
     */
    public static final String JC_PEOPLE_BACKGROUND_ZTRY_COMPARE_URL = "http://23.232.14.211:8950/dataApi/services/v1.0.0/people/background/ztry/compare?idNo=%s";
    /**
     * 晋城市公安局服务总线接口，重点人比对
     */
    public static final String JC_PEOPLE_BACKGROUND_ZDR_COMPARE_URL = "http://23.232.14.211:8950/dataApi/services/v1.0.0/people/background/zdr/compare?idNo=%s";

}
