/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.framework.shiro.web.filter.kickout;

import com.bcxin.platform.common.core.domain.AjaxResult;
import com.bcxin.platform.common.core.domain.entity.SysUser;
import com.bcxin.platform.common.utils.ServletUtils;
import com.bcxin.platform.common.utils.ShiroUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Deque;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.DefaultSessionKey;
import org.apache.shiro.session.mgt.SessionKey;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.AccessControlFilter;
import org.apache.shiro.web.util.WebUtils;

public class KickoutSessionFilter
extends AccessControlFilter {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private int maxSession = -1;
    private Boolean kickoutAfter = false;
    private String kickoutUrl;
    private SessionManager sessionManager;
    private Cache<String, Deque<Serializable>> cache;

    protected boolean isAccessAllowed(ServletRequest servletRequest, ServletResponse servletResponse, Object o) throws Exception {
        return false;
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        Subject subject = this.getSubject(request, response);
        if (!subject.isAuthenticated() && !subject.isRemembered() || this.maxSession == -1) {
            return true;
        }
        try {
            Session session = subject.getSession();
            SysUser user = ShiroUtils.getSysUser();
            String loginName = user.getLoginName();
            Serializable sessionId = session.getId();
            ArrayDeque<Serializable> deque = (ArrayDeque<Serializable>)this.cache.get((Object)loginName);
            if (deque == null) {
                deque = new ArrayDeque<Serializable>();
            }
            if (!deque.contains(sessionId) && session.getAttribute((Object)"kickout") == null) {
                deque.push(sessionId);
                this.cache.put((Object)loginName, deque);
            }
            while (deque.size() > this.maxSession) {
                Serializable kickoutSessionId = null;
                kickoutSessionId = this.kickoutAfter != false ? (Serializable)deque.removeFirst() : (Serializable)deque.removeLast();
                this.cache.put((Object)loginName, deque);
                try {
                    Session kickoutSession = this.sessionManager.getSession((SessionKey)new DefaultSessionKey(kickoutSessionId));
                    if (null == kickoutSession) continue;
                    kickoutSession.setAttribute((Object)"kickout", (Object)true);
                }
                catch (Exception exception) {}
            }
            if ((Boolean)session.getAttribute((Object)"kickout") != null && ((Boolean)session.getAttribute((Object)"kickout")).booleanValue()) {
                subject.logout();
                this.saveRequest(request);
                return this.isAjaxResponse(request, response);
            }
            return true;
        }
        catch (Exception e) {
            return this.isAjaxResponse(request, response);
        }
    }

    private boolean isAjaxResponse(ServletRequest request, ServletResponse response) throws IOException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        if (ServletUtils.isAjaxRequest((HttpServletRequest)req)) {
            AjaxResult ajaxResult = AjaxResult.error((String)"\u60a8\u5df2\u5728\u522b\u5904\u767b\u5f55\uff0c\u8bf7\u60a8\u4fee\u6539\u5bc6\u7801\u6216\u91cd\u65b0\u767b\u5f55");
            ServletUtils.renderString((HttpServletResponse)res, (String)objectMapper.writeValueAsString((Object)ajaxResult));
        } else {
            WebUtils.issueRedirect((ServletRequest)request, (ServletResponse)response, (String)this.kickoutUrl);
        }
        return false;
    }

    public void setMaxSession(int maxSession) {
        this.maxSession = maxSession;
    }

    public void setKickoutAfter(boolean kickoutAfter) {
        this.kickoutAfter = kickoutAfter;
    }

    public void setKickoutUrl(String kickoutUrl) {
        this.kickoutUrl = kickoutUrl;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cache = cacheManager.getCache("sys-userCache");
    }
}

